/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput.ftp;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.xinput.FileType;
import net.sourceforge.dvb.projectx.xinput.StreamInfo;
import net.sourceforge.dvb.projectx.xinput.XInputFileIF;
import net.sourceforge.dvb.projectx.xinput.XInputStream;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class XInputFileImpl
implements XInputFileIF {
    private boolean debug = false;
    private FileType fileType = null;
    private boolean isopen = false;
    private PushbackInputStream pbis = null;
    private File rafFile = null;
    private RandomAccessFile raf = null;
    private byte[] buffer = new byte[8];
    private FtpVO ftpVO = null;
    private FTPFile ftpFile = null;
    private FTPClient client = null;
    private DataInputStream in = null;
    public XInputStream xIs = null;
    private Object constructorParameter = null;
    private StreamInfo streamInfo = null;
    private boolean supportsResume = true;

    private XInputFileImpl() {
        throw new UnsupportedOperationException();
    }

    public XInputFileImpl(FtpVO ftpVO) {
        if (this.debug) {
            System.out.println("Try to create XInputFile of Type FTP");
        }
        this.ftpVO = ftpVO;
        this.ftpFile = ftpVO.getFtpFile();
        this.fileType = FileType.FTP;
        if (!this.exists()) {
            throw new IllegalArgumentException("File is not of type FileType.FTP");
        }
        if (this.debug) {
            System.out.println("Succeeded to create XInputFile of Type FTP");
        }
    }

    public String toString() {
        String string = this.ftpFile.getName();
        string = this.replaceStringByString(string, "\u00c3\u00a4", "\u00e4");
        string = this.replaceStringByString(string, "\u00c3\u00b6", "\u00f6");
        string = this.replaceStringByString(string, "\u00c3\u00bc", "\u00fc");
        string = this.replaceStringByString(string, "\u00c3\u201e", "\u00c4");
        string = this.replaceStringByString(string, "\u00c3\u2013", "\u00d6");
        string = this.replaceStringByString(string, "\u00c3\u0153", "\u00dc");
        string = this.replaceStringByString(string, "\u00c3\u0178", "\u00df");
        string = this.replaceStringByString(string, "\u00c3\u00a1", "\u00e1");
        string = this.replaceStringByString(string, "\u00c3\u00a0", "\u00e0");
        string = this.replaceStringByString(string, "\u00c3\u00a9", "\u00e9");
        string = this.replaceStringByString(string, "\u00c3\u00a8", "\u00e8");
        string = this.replaceStringByString(string, "\u00c3\u00ad", "\u00ed");
        string = this.replaceStringByString(string, "\u00c3\u00ac", "\u00ec");
        string = this.replaceStringByString(string, "\u00c3\u00b3", "\u00f3");
        string = this.replaceStringByString(string, "\u00c3\u00b2", "\u00f2");
        string = this.replaceStringByString(string, "\u00c3\u00ba", "\u00fa");
        string = this.replaceStringByString(string, "\u00c3\u00b9", "\u00f9");
        String string2 = "ftp://" + this.ftpVO.getUser() + ":" + this.ftpVO.getPassword() + "@" + this.ftpVO.getServer() + this.ftpVO.getPort(":") + this.ftpVO.getDirectory() + "/" + string;
        return string2;
    }

    private String replaceStringByString(String string, String string2, String string3) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while ((n = stringBuffer.toString().indexOf(string2, n)) != -1) {
            stringBuffer.replace(n, n + 2, string3);
        }
        return stringBuffer.toString();
    }

    public void setConstructorParameter(Object object) {
        this.constructorParameter = object;
    }

    public Object getConstructorParameter() {
        return this.constructorParameter;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public String getUrl() {
        String string = "ftp://" + this.ftpVO.getUser() + ":" + this.ftpVO.getPassword() + "@" + this.ftpVO.getServer() + this.ftpVO.getPort(":") + this.ftpVO.getDirectory() + "/" + this.ftpFile.getName();
        return string;
    }

    public long length() {
        return this.ftpFile.getSize();
    }

    public long lastModified() {
        return this.ftpFile.getTimestamp().getTime().getTime();
    }

    public boolean setLastModified() {
        return true;
    }

    public boolean exists() {
        boolean bl = false;
        if (this.ftpFile != null) {
            bl = true;
        }
        return bl;
    }

    public String getName() {
        String string = null;
        string = this.ftpFile.getName();
        string = this.replaceStringByString(string, "\u00c3\u00a4", "\u00e4");
        string = this.replaceStringByString(string, "\u00c3\u00b6", "\u00f6");
        string = this.replaceStringByString(string, "\u00c3\u00bc", "\u00fc");
        string = this.replaceStringByString(string, "\u00c3\u201e", "\u00c4");
        string = this.replaceStringByString(string, "\u00c3\u2013", "\u00d6");
        string = this.replaceStringByString(string, "\u00c3\u0153", "\u00dc");
        string = this.replaceStringByString(string, "\u00c3\u0178", "\u00df");
        string = this.replaceStringByString(string, "\u00c3\u00a1", "\u00e1");
        string = this.replaceStringByString(string, "\u00c3\u00a0", "\u00e0");
        string = this.replaceStringByString(string, "\u00c3\u00a9", "\u00e9");
        string = this.replaceStringByString(string, "\u00c3\u00a8", "\u00e8");
        string = this.replaceStringByString(string, "\u00c3\u00ad", "\u00ed");
        string = this.replaceStringByString(string, "\u00c3\u00ac", "\u00ec");
        string = this.replaceStringByString(string, "\u00c3\u00b3", "\u00f3");
        string = this.replaceStringByString(string, "\u00c3\u00b2", "\u00f2");
        string = this.replaceStringByString(string, "\u00c3\u00ba", "\u00fa");
        string = this.replaceStringByString(string, "\u00c3\u00b9", "\u00f9");
        return string;
    }

    public String getParent() {
        return this.ftpVO.getDirectory();
    }

    public InputStream getInputStream() throws FileNotFoundException, MalformedURLException, IOException {
        return this.getInputStream(0L);
    }

    public InputStream getInputStream(long l) throws FileNotFoundException, MalformedURLException, IOException {
        this.supportsResume = Common.getSettings().getBooleanProperty(Keys.KEY_useFtpServerResume);
        this.randomAccessOpen("r");
        if (this.supportsResume) {
            this.client.setRestartOffset(l);
        }
        if (this.debug) {
            System.out.println("gIS name " + this.getName());
        }
        this.xIs = new XInputStream(this.client.retrieveFileStream(this.ftpFile.getName()));
        if (this.debug) {
            System.out.println("gIS retriveStream " + this.client.getReplyString());
        }
        if (!this.supportsResume) {
            this.xIs.skip(l);
        }
        this.xIs.setFtpFile(this);
        return this.xIs;
    }

    public boolean rename() throws IOException {
        if (this.isopen) {
            return false;
        }
        this.randomAccessOpen("r");
        String string = this.getName();
        String string2 = null;
        boolean bl = false;
        string2 = Common.getGuiInterface().getUserInputDialog(string, Resource.getString("autoload.dialog.rename") + " " + this.getUrl());
        if (string2 != null && !string2.equals("")) {
            bl = this.client.rename(string, string2);
        }
        if (bl) {
            FTPFile[] fTPFileArray = this.client.listFiles();
            for (int i = 0; i < fTPFileArray.length; ++i) {
                if (!fTPFileArray[i].getName().equals(string2) || !fTPFileArray[i].isFile()) continue;
                this.ftpFile = fTPFileArray[i];
                this.ftpVO.setFtpFile(this.ftpFile);
                break;
            }
        }
        this.randomAccessClose();
        return bl;
    }

    public void randomAccessOpen(String string) throws IOException {
        if (this.isopen) {
            throw new IllegalStateException("XInputFile is already open!");
        }
        if (string.compareTo("r") != 0) {
            throw new IllegalStateException("Illegal access mode for FileType.FTP");
        }
        boolean bl = false;
        this.client = new FTPClient();
        this.client.connect(this.ftpVO.getServer(), this.ftpVO.getPortasInteger());
        if (this.debug) {
            System.out.println("rAO connect " + this.client.getReplyString());
        }
        bl = this.client.login(this.ftpVO.getUser(), this.ftpVO.getPassword());
        if (this.debug) {
            System.out.println("rAO login " + bl + " / " + this.client.getReplyString());
        }
        bl = this.client.changeWorkingDirectory(this.ftpVO.getDirectory());
        if (this.debug) {
            System.out.println("rAO cwd " + bl + " / " + this.client.getReplyString());
        }
        bl = this.client.setFileType(2);
        if (this.debug) {
            System.out.println("rAO binary " + bl + " / " + this.client.getReplyString());
        }
        this.client.enterLocalPassiveMode();
        if (this.debug) {
            System.out.println("rAO PASV " + this.client.getReplyString());
        }
        String[] stringArray = this.getUserFTPCommand();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            this.client.sendCommand(stringArray[i]);
            if (!this.debug) continue;
            System.out.println("rAO cmd " + this.client.getReplyString());
        }
        this.isopen = true;
    }

    public String[] getUserFTPCommand() {
        StringTokenizer stringTokenizer = new StringTokenizer(Common.getSettings().getProperty(Keys.KEY_FtpServer_Commands), "|");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextElement().toString().trim();
            ++n;
        }
        return stringArray;
    }

    private boolean EOF() throws IOException {
        int n;
        int n2;
        return this.in != null ? (n2 = this.in.read()) < 0 : this.xIs != null && (n = this.xIs.read()) < 0;
    }

    public void randomAccessClose() throws IOException {
        block16: {
            if (!this.isopen) {
                throw new IllegalStateException("XInputFile is already closed!");
            }
            boolean bl = false;
            if (this.debug) {
                System.out.println("rAC last " + this.client.getReplyCode() + " / " + this.client.getReplyString());
            }
            bl = this.client.isConnected();
            if (this.debug) {
                System.out.println("rAC isCon " + bl + " / " + this.client.getReplyCode() + " / " + this.client.getReplyString());
            }
            if (Common.getSettings().getBooleanProperty(Keys.KEY_killFtpClient)) {
                if (this.debug) {
                    System.out.println("rAC kill ");
                }
            } else {
                if (!this.EOF()) {
                    if (this.debug) {
                        System.out.println("rAC !eof ");
                    }
                    bl = this.client.abort();
                    if (this.debug) {
                        System.out.println("rAC abort " + bl + " / " + this.client.getReplyCode() + " / " + this.client.getReplyString());
                    }
                }
                bl = this.client.logout();
                if (this.debug) {
                    System.out.println("rAC logout " + bl + " / " + this.client.getReplyCode() + " / " + this.client.getReplyString());
                }
                bl = this.client.isConnected();
                if (this.debug) {
                    System.out.println("rAC isCon " + bl + " / " + this.client.getReplyCode() + " / " + this.client.getReplyString());
                }
                if (bl) {
                    try {
                        this.client.disconnect();
                        if (this.debug) {
                            System.out.println("rAC disc " + this.client.getReplyCode() + " / " + this.client.getReplyString());
                        }
                    }
                    catch (IOException iOException) {
                        if (!this.debug) break block16;
                        System.out.println("rAC disc-er " + iOException);
                    }
                }
            }
        }
        this.in = null;
        this.xIs = null;
        this.client = null;
        this.isopen = false;
        System.gc();
        if (this.debug) {
            System.out.println("rAC out ");
        }
    }

    public void randomAccessSeek(long l) throws IOException {
        this.client.setRestartOffset(l);
        if (this.debug) {
            System.out.println("rAS REST " + this.client.getReplyString() + " /aP " + l);
        }
        this.in = new DataInputStream(this.client.retrieveFileStream(this.ftpFile.getName()));
        if (this.debug) {
            System.out.println("rAS retriveStream " + this.client.getReplyString());
        }
    }

    public long randomAccessGetFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public int randomAccessRead() throws IOException {
        this.buffer[0] = -1;
        this.randomAccessRead(this.buffer, 0, 1);
        return this.buffer[0];
    }

    public int randomAccessRead(byte[] byArray) throws IOException {
        return this.randomAccessRead(byArray, 0, byArray.length);
    }

    public int randomAccessRead(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        while ((n3 = this.in.read(byArray, n4, n2 - n4)) > 0) {
            n4 += n3;
        }
        return n3;
    }

    public String randomAccessReadLine() throws IOException {
        return this.in.readLine();
    }

    public void randomAccessWrite(byte[] byArray) throws IOException {
        throw new IllegalStateException("Illegal access for FileType.FTP");
    }

    public void randomAccessSingleRead(byte[] byArray, long l) throws IOException {
        this.randomAccessOpen("r");
        this.randomAccessSeek(l);
        this.randomAccessRead(byArray);
        this.randomAccessClose();
    }

    public long randomAccessReadLong() throws IOException {
        return this.in.readLong();
    }

    public void setStreamInfo(StreamInfo streamInfo) {
        this.streamInfo = streamInfo;
    }

    public StreamInfo getStreamInfo() {
        return this.streamInfo;
    }
}

