/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput.ftp;

import java.net.URL;
import java.util.ArrayList;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.xinput.DirType;
import net.sourceforge.dvb.projectx.xinput.XInputDirectoryIF;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpServer;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;

public class XInputDirectoryImpl
implements XInputDirectoryIF {
    private DirType dirType = null;
    private FtpVO ftpVO = null;
    private FtpServer ftpServer = null;

    private XInputDirectoryImpl() {
        throw new UnsupportedOperationException("Usage is not allowed!");
    }

    public XInputDirectoryImpl(FtpVO ftpVO) {
        this.ftpVO = ftpVO;
        this.ftpServer = new FtpServer(this.ftpVO);
        this.dirType = DirType.FTP_DIR;
    }

    public XInputDirectoryImpl(String string) {
        if (string.startsWith("ftp://")) {
            int n = string.indexOf(58, 6);
            int n2 = string.indexOf(64, n);
            int n3 = string.indexOf(47, n2);
            if (n2 == -1 || n == -1 || n3 == -1) {
                throw new IllegalArgumentException("aFileIdentifier is a malformed ftp URL!");
            }
            String string2 = string.substring(6, n);
            String string3 = string.substring(n + 1, n2);
            String string4 = string.substring(n2 + 1, n3);
            String string5 = string.substring(n3);
            String string6 = null;
            int n4 = string4.indexOf(58);
            if (n4 != -1) {
                string4 = string4.substring(0, n4);
                string6 = string4.substring(n4 + 1);
            }
            this.ftpVO = new FtpVO(string4, string2, string3, string5, string6, null);
            this.ftpServer = new FtpServer(this.ftpVO);
            this.dirType = DirType.FTP_DIR;
            if (!this.test()) {
                this.ftpVO = null;
                this.ftpServer = null;
                this.dirType = null;
                throw new IllegalArgumentException(string + " is not a correct ftp URL!");
            }
        } else {
            throw new IllegalArgumentException(string + " is not a correct ftp URL!");
        }
    }

    public XInputDirectoryImpl(URL uRL) {
        if (uRL.getProtocol().compareTo("ftp") != -1) {
            int n;
            String string;
            String string2 = uRL.toString();
            int n2 = string2.indexOf(string = uRL.getHost());
            if (n2 > 6) {
                string = string2.substring(6, n2) + string;
            }
            String string3 = string;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            int n3 = string.indexOf("@");
            if (n3 != -1) {
                string3 = string.substring(n3 + 1);
                string4 = string.substring(0, n3);
                if ((n3 = string4.indexOf(":")) != -1) {
                    string5 = string4.substring(n3 + 1);
                    string4 = string4.substring(0, n3);
                }
            }
            if (string4 == null && string5 == null) {
                string4 = "anonymous";
                string5 = "";
            }
            string7 = (n = uRL.getPort()) != -1 ? String.valueOf(n) : null;
            String string8 = uRL.getFile();
            n3 = string8.lastIndexOf("/");
            string6 = string8.substring(0, n3);
            this.ftpVO = new FtpVO(string3, string4, string5, string6, string7, null);
            this.ftpServer = new FtpServer(this.ftpVO);
            this.dirType = DirType.FTP_DIR;
            if (!this.test()) {
                this.ftpVO = null;
                this.ftpServer = null;
                this.dirType = null;
                throw new IllegalArgumentException(uRL + " is not a correct ftp URL!");
            }
        } else {
            throw new IllegalArgumentException(uRL + " is not a correct ftp URL!");
        }
    }

    public String toString() {
        String string = null;
        string = "ftp://" + this.ftpVO.getUser() + ":" + this.ftpVO.getPassword() + "@" + this.ftpVO.getServer() + this.ftpVO.getPort(":") + this.ftpVO.getDirectory();
        return string;
    }

    public String getDirectory() {
        return this.ftpVO.getDirectory();
    }

    public String getPassword() {
        return this.ftpVO.getPassword();
    }

    public String getServer() {
        return this.ftpVO.getServer();
    }

    public String getPort() {
        return this.ftpVO.getPort();
    }

    public String getUser() {
        return this.ftpVO.getUser();
    }

    public String getLog() {
        return this.ftpServer.getLog();
    }

    public XInputFile[] getFiles() {
        int n;
        ArrayList<XInputFile> arrayList = new ArrayList<XInputFile>();
        this.ftpServer.open();
        XInputFile[] xInputFileArray = this.ftpServer.listFiles();
        this.ftpServer.close();
        int n2 = xInputFileArray.length;
        for (n = 0; n < n2; ++n) {
            arrayList.add(xInputFileArray[n]);
        }
        if (Common.getSettings().getBooleanProperty(Keys.KEY_InputDirectoriesDepth)) {
            this.getDirectories(this.ftpVO, arrayList);
        }
        xInputFileArray = new XInputFile[arrayList.size()];
        n2 = xInputFileArray.length;
        for (n = 0; n < n2; ++n) {
            xInputFileArray[n] = (XInputFile)arrayList.get(n);
        }
        return xInputFileArray;
    }

    private void getDirectories(FtpVO ftpVO, ArrayList arrayList) {
        FtpServer ftpServer = new FtpServer(ftpVO);
        ftpServer.open();
        FtpVO[] ftpVOArray = ftpServer.listDirectories();
        ftpServer.close();
        for (int i = 0; i < ftpVOArray.length; ++i) {
            ftpServer = new FtpServer(ftpVOArray[i]);
            ftpServer.open();
            XInputFile[] xInputFileArray = ftpServer.listFiles();
            ftpServer.close();
            for (int j = 0; j < xInputFileArray.length; ++j) {
                arrayList.add(xInputFileArray[j]);
            }
            this.getDirectories(ftpVOArray[i], arrayList);
        }
    }

    public boolean test() {
        return this.ftpServer.test();
    }

    public String getTestMsg() {
        return this.ftpServer.getTestMsg();
    }

    public DirType getDirType() {
        return this.dirType;
    }
}

