/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;
import net.sourceforge.dvb.projectx.xinput.ftp.StringCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpServer {
    private FtpVO ftpVO;
    private StringCommandListener scl;
    private FTPClient ftpClient;
    private boolean isOpen;
    private String testMsg;

    private FtpServer() {
        throw new UnsupportedOperationException();
    }

    public FtpServer(FtpVO ftpVO) {
        if (ftpVO == null) {
            throw new IllegalArgumentException("aFtpVO mustn't be null!");
        }
        this.ftpVO = ftpVO;
        this.scl = new StringCommandListener();
        this.ftpClient = new FTPClient();
        this.ftpClient.addProtocolCommandListener(this.scl);
        this.isOpen = false;
    }

    public boolean open() {
        boolean bl = false;
        if (this.isOpen) {
            throw new IllegalStateException("Is already open, must be closed before!");
        }
        try {
            this.ftpClient.connect(this.ftpVO.getServer(), this.ftpVO.getPortasInteger());
            int n = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion(n)) {
                this.ftpClient.disconnect();
                throw new IOException("Can't connect!");
            }
            if (!this.ftpClient.login(this.ftpVO.getUser(), this.ftpVO.getPassword())) {
                this.ftpClient.logout();
                throw new IOException("Can't login!");
            }
            if (!this.ftpClient.changeWorkingDirectory(this.ftpVO.getDirectory())) {
                this.ftpClient.logout();
                throw new IOException("Can't change directory!");
            }
            this.ftpClient.setFileType(2);
            this.ftpClient.enterLocalPassiveMode();
            bl = true;
        }
        catch (Exception exception) {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            bl = false;
        }
        this.isOpen = bl;
        return bl;
    }

    public XInputFile[] listFiles() {
        int n;
        ArrayList<XInputFile> arrayList = new ArrayList<XInputFile>();
        FTPFile[] fTPFileArray = null;
        try {
            fTPFileArray = this.ftpClient.listFiles();
            n = fTPFileArray.length;
            for (int i = 0; i < n; ++i) {
                if (!fTPFileArray[i].isFile()) continue;
                FtpVO ftpVO = (FtpVO)this.ftpVO.clone();
                ftpVO.setFtpFile(fTPFileArray[i]);
                arrayList.add(new XInputFile(ftpVO));
            }
        }
        catch (Exception exception) {
            System.err.println("!> error create ftp filelist: " + exception);
        }
        XInputFile[] xInputFileArray = new XInputFile[arrayList.size()];
        int n2 = xInputFileArray.length;
        for (n = 0; n < n2; ++n) {
            xInputFileArray[n] = (XInputFile)arrayList.get(n);
        }
        return xInputFileArray;
    }

    public FtpVO[] listDirectories() {
        int n;
        ArrayList<FtpVO> arrayList = new ArrayList<FtpVO>();
        FTPFile[] fTPFileArray = null;
        try {
            fTPFileArray = this.ftpClient.listFiles();
            n = fTPFileArray.length;
            for (int i = 0; i < n; ++i) {
                if (!fTPFileArray[i].isDirectory() || fTPFileArray[i].getName().startsWith(".")) continue;
                FtpVO ftpVO = (FtpVO)this.ftpVO.clone();
                ftpVO.setDirectory(ftpVO.getDirectory() + "/" + fTPFileArray[i].getName());
                ftpVO.setFtpFile(fTPFileArray[i]);
                arrayList.add(ftpVO);
            }
        }
        catch (Exception exception) {
            System.err.println("!> error create ftp directory list: " + exception);
        }
        FtpVO[] ftpVOArray = new FtpVO[arrayList.size()];
        int n2 = ftpVOArray.length;
        for (n = 0; n < n2; ++n) {
            ftpVOArray[n] = (FtpVO)arrayList.get(n);
        }
        return ftpVOArray;
    }

    public InputStream retrieveFileStream(String string) throws IOException {
        return this.ftpClient.retrieveFileStream(string);
    }

    public void close() {
        if (!this.isOpen) {
            throw new IllegalStateException("Is already closed, must be opened before!");
        }
        try {
            this.ftpClient.logout();
            this.ftpClient.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test() {
        boolean bl = false;
        boolean bl2 = false;
        this.testMsg = null;
        try {
            this.ftpClient.connect(this.ftpVO.getServer(), this.ftpVO.getPortasInteger());
            int n = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion(n)) {
                this.ftpClient.disconnect();
                this.testMsg = Resource.getString("ftpchooser.msg.noconnect");
                boolean bl3 = false;
                return bl3;
            }
            if (!this.ftpClient.login(this.ftpVO.getUser(), this.ftpVO.getPassword())) {
                this.ftpClient.logout();
                this.testMsg = Resource.getString("ftpchooser.msg.nologin");
                boolean bl4 = false;
                return bl4;
            }
            this.ftpClient.syst();
            if (!this.ftpClient.changeWorkingDirectory(this.ftpVO.getDirectory())) {
                this.testMsg = Resource.getString("ftpchooser.msg.nodirectory");
                boolean bl5 = false;
                return bl5;
            }
            this.testMsg = Resource.getString("ftpchooser.msg.success");
            this.ftpClient.logout();
        }
        catch (IOException iOException) {
            this.testMsg = iOException.getLocalizedMessage();
            bl2 = true;
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        if (bl2) return false;
        return true;
    }

    public String getTestMsg() {
        return this.testMsg;
    }

    public String getLog() {
        return this.scl.getMessages();
    }
}

