/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput;

import net.sourceforge.dvb.projectx.xinput.DirType;
import net.sourceforge.dvb.projectx.xinput.XInputDirectoryIF;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class XInputDirectory
implements XInputDirectoryIF {
    private XInputDirectoryIF impl = null;
    private boolean debug = false;
    private Object constructorParameter = null;

    private XInputDirectory() {
        throw new UnsupportedOperationException();
    }

    public XInputDirectory(Object object) {
        if (this.debug) {
            System.out.println("Enter XInputDirectory(Object '" + object + "')");
        }
        Class[] classArray = new Class[]{object.getClass()};
        Object[] objectArray = new Object[]{object};
        this.retrieveImplementation(classArray, objectArray);
        this.constructorParameter = object;
        if (this.debug) {
            System.out.println("Leave XInputDirectory(Object '" + object + "')");
        }
    }

    public XInputDirectory getNewInstance() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.getNewInstance()");
        }
        XInputDirectory xInputDirectory = new XInputDirectory(this.constructorParameter);
        if (this.debug) {
            System.out.println("Leave XInputDirectory.getNewInstance() returning " + xInputDirectory);
        }
        return xInputDirectory;
    }

    private void retrieveImplementation(Class[] classArray, Object[] objectArray) {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.retrieveImplementation(Class[] parameterTypes, Object[] parameterValues)");
        }
        DirType dirType2 = null;
        for (DirType dirType2 : DirType.getDirTypes()) {
            if (dirType2.equals(DirType.DEFAULT)) continue;
            try {
                if (this.debug) {
                    System.out.println("Try DirType '" + dirType2.getName() + "'");
                }
                this.impl = (XInputDirectoryIF)dirType2.getImplementation().getConstructor(classArray).newInstance(objectArray);
                if (this.debug) {
                    System.out.println("Use DirType '" + dirType2.getName() + "' for file '" + ((Object)this.impl).toString() + "'");
                }
                if (this.debug) {
                    System.out.println("Leave XInputDirectory.retrieveImplementation(Class[] parameterTypes, Object[] parameterValues)");
                }
                return;
            }
            catch (Exception exception) {
                this.impl = null;
            }
        }
        try {
            dirType2 = DirType.DEFAULT;
            if (this.debug) {
                System.out.println("Try default DirType '" + dirType2.getName() + "'");
            }
            this.impl = (XInputDirectoryIF)dirType2.getImplementation().getConstructor(classArray).newInstance(objectArray);
            if (this.debug) {
                System.out.println("Use default DirType '" + dirType2.getName() + "' for file '" + ((Object)this.impl).toString() + "'");
            }
            if (this.debug) {
                System.out.println("Leave XInputDirectory.retrieveImplementation(Class[] parameterTypes, Object[] parameterValues)");
            }
            return;
        }
        catch (Exception exception) {
            this.impl = null;
            if (this.debug) {
                System.out.println("No matching DirType found or directory doesn't exist");
            }
            if (this.debug) {
                System.out.println("XInputDirectory.Leave retrieveImplementation(Class[] parameterTypes, Object[] parameterValues)");
            }
            throw new IllegalArgumentException("No matching DirType found or directory doesn't exist");
        }
    }

    public boolean equals(Object object) {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.equals(Object '" + object + "')");
        }
        if (!(object instanceof XInputDirectory)) {
            if (this.debug) {
                System.out.println("Leave XInputDirectory.equals(Object '" + object + "') returning false");
            }
            return false;
        }
        XInputDirectory xInputDirectory = (XInputDirectory)object;
        if (xInputDirectory.getDirType().equals(this.getDirType()) && xInputDirectory.toString().equals(this.toString())) {
            if (this.debug) {
                System.out.println("Leave XInputDirectory.equals(Object '" + object + "') returning true");
            }
            return true;
        }
        if (this.debug) {
            System.out.println("Leave XInputDirectory.equals(Object '" + object + "') returning false");
        }
        return false;
    }

    public String getDirectory() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.getDirectory()");
        }
        String string = this.impl.getDirectory();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.getDirectory() returning " + string);
        }
        return string;
    }

    public DirType getDirType() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.getDirType()");
        }
        DirType dirType = this.impl.getDirType();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.getDirType() returning " + dirType);
        }
        return dirType;
    }

    public XInputFile[] getFiles() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.getFiles()");
        }
        XInputFile[] xInputFileArray = this.impl.getFiles();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.getFiles() returning " + xInputFileArray.length + " xInputFiles");
        }
        return xInputFileArray;
    }

    public String getLog() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.getLog()");
        }
        String string = this.impl.getLog();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.getLog() returning " + string);
        }
        return string;
    }

    public String getPassword() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.getPassword()");
        }
        String string = this.impl.getPassword();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.getPassword() returning " + string);
        }
        return string;
    }

    public String getServer() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.getServer()");
        }
        String string = this.impl.getServer();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.getServer() returning " + string);
        }
        return string;
    }

    public String getPort() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.getPort()");
        }
        String string = this.impl.getPort();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.getPort() returning " + string);
        }
        return string;
    }

    public String getTestMsg() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.getTestMsg()");
        }
        String string = this.impl.getTestMsg();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.getTestMsg() returning " + string);
        }
        return string;
    }

    public String getUser() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.getUser()");
        }
        String string = this.impl.getUser();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.getUser() returning " + string);
        }
        return string;
    }

    public int hashCode() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.hashCode()");
        }
        int n = this.impl.hashCode();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.hashCode() returning " + n);
        }
        return n;
    }

    public boolean test() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.getDirectory()");
        }
        boolean bl = this.impl.test();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.getDirectory() returning " + new Boolean(bl));
        }
        return bl;
    }

    public String toString() {
        if (this.debug) {
            System.out.println("Enter XInputDirectory.toString()");
        }
        String string = ((Object)this.impl).toString();
        if (this.debug) {
            System.out.println("Leave XInputDirectory.toString() returning " + string);
        }
        return string;
    }
}

