/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.video;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.video.PreviewObject;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class Preview {
    private byte[] preview_data;
    private int loadSizeForward;
    private int active_collection;
    private int processed_PID;
    private int[] position;
    private String processed_file;
    private List positionList;
    private PreviewObject preview_object;
    private Object[] predefined_Pids;

    public Preview(int n) {
        this.loadSizeForward = n;
        this.position = new int[2];
        this.positionList = new ArrayList();
        this.processed_PID = -1;
        this.processed_file = "";
    }

    public String getProcessedFile() {
        return this.processed_file;
    }

    public String getProcessedPID() {
        if (this.processed_PID < 0) {
            return "---";
        }
        return Integer.toHexString(this.processed_PID).toUpperCase();
    }

    public long load(long l, int n, List list, boolean bl, boolean bl2, boolean bl3, Object[] objectArray, int n2) throws IOException {
        int n3;
        this.predefined_Pids = objectArray;
        this.active_collection = n2;
        this.preview_data = new byte[n];
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < list.size(); ++i) {
            this.preview_object = (PreviewObject)list.get(i);
            n4 = this.preview_object.getType();
            if (l >= this.preview_object.getEnd()) continue;
            XInputFile xInputFile = this.preview_object.getFile();
            xInputFile.randomAccessOpen("r");
            xInputFile.randomAccessSeek(l - this.preview_object.getStart());
            xInputFile.randomAccessRead(this.preview_data, n5, n);
            xInputFile.randomAccessClose();
            if (this.preview_object.getEnd() - l >= (long)n || i >= list.size() - 1) break;
            n3 = (int)(this.preview_object.getEnd() - l);
            byte[] byArray = new byte[n];
            this.preview_object = (PreviewObject)list.get(++i);
            xInputFile = this.preview_object.getFile();
            xInputFile.randomAccessSingleRead(byArray, 0L);
            System.arraycopy(byArray, 0, this.preview_data, n3, n - n3);
            byArray = null;
            break;
        }
        this.preview_data = this.search(this.preview_data, l, n4);
        long l2 = Common.getMpvDecoderClass().decodeArray(this.preview_data, bl, bl2, bl3);
        for (n3 = this.positionList.size() - 1; n3 >= 0; --n3) {
            this.position = (int[])this.positionList.get(n3);
            if ((long)this.position[1] > l2) continue;
            l += (long)this.position[0];
            n3 = 0;
        }
        if (this.positionList.size() == 0) {
            l += l2;
        }
        for (n3 = 0; n3 < list.size(); ++n3) {
            this.preview_object = (PreviewObject)list.get(n3);
            if (l >= this.preview_object.getEnd()) continue;
            this.processed_file = "" + (n3 + 1) + "/" + list.size() + " - " + this.preview_object.getFile().getName();
            break;
        }
        this.preview_data = null;
        return l;
    }

    private byte[] search(byte[] byArray, long l, int n) {
        this.positionList.clear();
        int[] nArray = new int[this.predefined_Pids.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(this.predefined_Pids[i].toString().substring(2), 16);
        }
        Arrays.sort(nArray);
        switch (n) {
            case 8: {
                return byArray;
            }
            case 1: 
            case 3: {
                return this.parseMPG2(byArray, nArray);
            }
            case 2: {
                return this.parseMPG1(byArray, nArray);
            }
            case 4: {
                return this.parsePVA(byArray, nArray);
            }
            case 5: {
                return this.parseTS(byArray, nArray);
            }
        }
        return byArray;
    }

    private byte[] parseTS(byte[] byArray, int[] nArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[]{91, 72, 79, 74, 73, 78, 32, 65};
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = byArray.length - 9;
        for (int i = 0; i < n3; ++i) {
            if (byArray[i] == 127 && byArray[i + 1] == 65 && byArray[i + 2] == 4 && byArray[i + 3] == -3) {
                if (bl && n <= i) {
                    byteArrayOutputStream.write(byArray, n, i - n);
                }
                bl = false;
                n = (i += 1183) + 1;
                continue;
            }
            if (i < byArray.length - 36 && byArray[i + 2] == 0 && byArray[i + 3] == 0 && byArray[i + 36] == 71) {
                if (bl && n <= i) {
                    byteArrayOutputStream.write(byArray, n, i - n);
                }
                bl = false;
                n = (i += 35) + 1;
                continue;
            }
            if (i >= byArray.length - 188 || byArray[i] != 71) continue;
            int n4 = 0;
            if (byArray[i + 188] != 71 && byArray[i + 188] != 127) {
                int n5 = i + 188;
                int n6 = i + 189;
                int n7 = byArray2.length;
                while (n5 > i) {
                    int n8 = 0;
                    while (n5 > i && byArray[n5] != byArray2[n8]) {
                        --n5;
                    }
                    while (n5 > i && n8 < n7 && n5 + n8 < n6 && byArray[n5 + n8] == byArray2[n8]) {
                        ++n8;
                    }
                    if (n8 <= 0) continue;
                    if (n8 < n7 && n5 + n8 < n6) {
                        --n5;
                        continue;
                    }
                    if (n5 + 512 + (n6 - n5) >= byArray.length) break;
                    n4 = 512;
                    System.arraycopy(byArray, n5 + n4, byArray, n5, n6 - n5 - 1);
                    System.arraycopy(byArray, i, byArray, i + n4, n5 - i);
                    break;
                }
                if ((n4 != 0 || i >= byArray.length - 224 || byArray[i + 190] != 0 || byArray[i + 191] != 0 || byArray[i + 224] != 71) && n4 == 0) continue;
            }
            if (bl && n <= i) {
                byteArrayOutputStream.write(byArray, n, i - n);
            }
            n = i;
            int n9 = (0x1F & byArray[i + 1]) << 8 | 0xFF & byArray[i + 2];
            if (nArray.length > 0 && Arrays.binarySearch(nArray, n9) < 0) {
                bl = false;
            } else if ((n2 == n9 || n2 == -1) && (0xD & byArray[i + 3] >>> 4) == 1) {
                n = (0x20 & byArray[i + 3]) != 0 ? i + 5 + (0xFF & byArray[i + 4]) : i + 4;
                if ((0x40 & byArray[i + 1]) != 0) {
                    if (byArray[n] == 0 && byArray[n + 1] == 0 && byArray[n + 2] == 1 && (0xF0 & byArray[n + 3]) == 224) {
                        n2 = n9;
                        n = n + 9 + (0xFF & byArray[n + 8]);
                        int[] nArray2 = new int[]{i, byteArrayOutputStream.size()};
                        this.positionList.add(nArray2);
                    } else {
                        bl = false;
                    }
                }
                if (n2 == n9) {
                    bl = true;
                }
            } else {
                bl = false;
            }
            i += 187;
            i += n4;
            n += n4;
        }
        this.processed_PID = n2;
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] parseMPG2(byte[] byArray, int[] nArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n = 0;
        int n2 = 9;
        int n3 = 6;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = byArray.length - n2;
        while (n6 < n7) {
            int n8 = CommonParsing.validateStartcode(byArray, n6);
            if (n8 < 0) {
                n6 += -n8;
                continue;
            }
            int n9 = CommonParsing.getPES_IdField(byArray, n6);
            if (n9 < 185) {
                n6 += 4;
                continue;
            }
            if (bl) {
                byteArrayOutputStream.write(byArray, n, n6 - n);
            }
            n = n6;
            if (nArray.length > 0 && Arrays.binarySearch(nArray, n9) < 0) {
                bl = false;
            } else if ((n5 == n9 || n5 == -1) && (0xF0 & n9) == 224) {
                n5 = n9;
                n = n6 + n2 + CommonParsing.getPES_ExtensionLengthField(byArray, n6);
                int[] nArray2 = new int[]{n6, byteArrayOutputStream.size()};
                this.positionList.add(nArray2);
                bl = true;
            } else {
                bl = false;
            }
            int n10 = n9 < 187 ? 12 : 0;
            n4 = CommonParsing.getPES_LengthField(byArray, n6);
            if (n4 == 0) {
                n10 = n2;
            }
            n6 += n10 == 0 ? n3 + n4 : n10;
        }
        this.processed_PID = n5;
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] parseMPG1(byte[] byArray, int[] nArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n = 0;
        int n2 = 7;
        int n3 = 6;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = byArray.length - n2;
        while (n6 < n7) {
            int n8 = CommonParsing.validateStartcode(byArray, n6);
            if (n8 < 0) {
                n6 += -n8;
                continue;
            }
            int n9 = CommonParsing.getPES_IdField(byArray, n6);
            if (n9 < 185) {
                n6 += 4;
                continue;
            }
            if (bl) {
                byteArrayOutputStream.write(byArray, n, n6 - n);
            }
            n = n6;
            if (nArray.length > 0 && Arrays.binarySearch(nArray, n9) < 0) {
                bl = false;
            } else if ((n5 == n9 || n5 == -1) && (0xF0 & n9) == 224) {
                n5 = n9;
                int n10 = n6 + n3;
                block12: while (true) {
                    switch (0xC0 & byArray[n10]) {
                        case 64: {
                            n10 += 2;
                            continue block12;
                        }
                        case 128: {
                            n10 += 3;
                            continue block12;
                        }
                        case 192: {
                            ++n10;
                            continue block12;
                        }
                    }
                    switch (0x30 & byArray[n10]) {
                        case 32: {
                            n10 += 5;
                            break block12;
                        }
                        case 48: {
                            n10 += 10;
                            break block12;
                        }
                        case 16: {
                            n10 += 5;
                            break block12;
                        }
                        case 0: {
                            ++n10;
                            break block12;
                        }
                        default: {
                            continue block12;
                        }
                    }
                    break;
                }
                n = n10;
                int[] nArray2 = new int[]{n6, byteArrayOutputStream.size()};
                this.positionList.add(nArray2);
                bl = true;
            } else {
                bl = false;
            }
            int n11 = n9 < 187 ? 12 : 0;
            n4 = CommonParsing.getPES_LengthField(byArray, n6);
            if (n4 == 0) {
                n11 = n2;
            }
            n6 += n11 == 0 ? n3 + n4 : n11;
        }
        this.processed_PID = n5;
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] parsePVA(byte[] byArray, int[] nArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n = 0;
        int n2 = 8;
        int n3 = 8;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = byArray.length - n2;
        while (n6 < n7) {
            if ((0xFF & byArray[n6]) != 65 || (0xFF & byArray[n6 + 1]) != 86 || (0xFF & byArray[n6 + 4]) != 85) {
                ++n6;
                continue;
            }
            if (bl) {
                byteArrayOutputStream.write(byArray, n, n6 - n);
            }
            n = n6;
            int n8 = 0xFF & byArray[n6 + 2];
            if (n8 == 1) {
                n5 = 1;
                n = (0x10 & byArray[n6 + 5]) != 0 ? n6 + n3 + 4 : n6 + n3;
                int[] nArray2 = new int[]{n6, byteArrayOutputStream.size()};
                this.positionList.add(nArray2);
                bl = true;
            } else {
                bl = false;
            }
            n4 = (0xFF & byArray[n6 + 6]) << 8 | 0xFF & byArray[n6 + 7];
            n6 += n3 + n4;
        }
        this.processed_PID = n5;
        return byteArrayOutputStream.toByteArray();
    }
}

