/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.thirdparty;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.subtitle.Teletext;

public class TS {
    private static byte[] TF4000header = new byte[]{-51, 57, 12, 0, -51, 57, 12, 0, 0, 60, 0, 31, 0, 0, 5, 0, 6, -80, 1, 2, 1, 0, 0, -32, 0, -32, 0, -64, 77, 121, 32, 112, 101, 114, 115, 111, 110, 97, 108, 32, 84, 86, 32, 67, 104, 97, 110, 110, 101, 108, 0, 0, 5, 0, 48, -64, 107, 108, 0, 1, 64, 31, 1, 1, -51, 57, 11, 0, -51, 57, 12, 0, 0, 60, 4, 4, 84, 69, 83, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2};
    private static byte[] TF5000header = new byte[]{84, 70, 114, 99, 80, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 1, 48, 1, 2, 1, 0, 0, -32, 0, -32, 0, -64, 80, 114, 105, 118, 97, 116, 101, 32, 82, 101, 99, 111, 114, 100, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 0, 8, 7, 0, 107, 108, 0, 1, 64, 31, 1, 1, 0, 0, 0, 0, -128, 2, 0, 0, 0, 60, 4, 4, 84, 69, 83, 84, 0, 0, 0, 0, 4, 0, 0};
    private static byte[] pmt1 = new byte[]{71, 65, 0, 16, 0, 2, -80, -107, 1, 2, -63, 0, 0, -32, -32, -16, 0, 2, -32, -32, -16, 3, 82, 1, 1, 3, -32, -64, -16, 9, 82, 1, 3, 10, 4, 100, 101, 117, 1, 3, -32, -63, -16, 9, 82, 1, 4, 10, 4, 100, 101, 117, 1, 3, -32, -62, -16, 9, 82, 1, 5, 10, 4, 100, 101, 117, 1, 3, -32, -61, -16, 9, 82, 1, 6, 10, 4, 100, 101, 117, 1, 6, -32, -128, -16, 12, 82, 1, 17, 106, 1, 0, 10, 4, 100, 101, 117, 0, 6, -32, -127, -16, 12, 82, 1, 18, 106, 1, 0, 10, 4, 100, 101, 117, 0, 6, -32, -126, -16, 12, 82, 1, 19, 106, 1, 0, 10, 4, 100, 101, 117, 0, 6, -32, -112, -16, 16, 82, 1, -62, 86, 5, 101, 110, 103, 9, 0, 10, 4, 100, 101, 117, 0, -123, 51, 73, 126};
    private static int count1 = 0;
    private static int count2 = 0;
    private static int count3 = 0;
    private static byte[] pcr = new byte[188];
    private static byte[] pat = new byte[188];
    private static byte[] pmt = new byte[188];
    private static byte[] pmtHead = new byte[]{71, 1, 0, 16};
    private static byte[] pmtStart = new byte[]{0, 2, -80, 0, 1, 2, -63, 0};
    private static byte[] pmtPCR = new byte[]{0, -32, -32, -16, 0};
    private static byte[] pmtMPV = new byte[]{2, -32, -32, -16, 3, 82, 1, 1};
    private static byte[] pmtMPA = new byte[]{3, -32, -64, -16, 9, 82, 1, 3, 10, 4, 100, 101, 117, 1};
    private static byte[] pmtAC3 = new byte[]{6, -32, -128, -16, 12, 82, 1, 4, 106, 1, 0, 10, 4, 100, 101, 117, 0};
    private static byte[] pmtAC3_atsc = new byte[]{-127, -32, -128, -16, 15, 82, 1, 4, 10, 4, 101, 110, 103, 0, 5, 4, 65, 67, 45, 51};
    private static byte[] pmtTTX = new byte[]{6, -32, -112, -16, 31, 82, 1, 5, 86, 20, 101, 110, 103, 9, 0, 100, 101, 117, 17, 80, 103, 101, 114, 23, 119, 101, 110, 103, 16, -120, 10, 4, 100, 101, 117, 0};
    private static byte[] autopmt = new byte[0];
    private static int firstID = 224;
    private static boolean myTTX = false;
    private static byte[] pat1 = new byte[]{71, 64, 0, 16, 0, 0, -80, 13, 0, 1, 1, 0, 0, 1, 2, -31, 0, -113, -91, 38, -49};
    private static byte[] pcr1 = new byte[]{71, 0, -32, 32, -73, 16, 0, 0, 0, 0, 0, 0};
    private static byte[] ttx = new byte[]{71, 64, -97, 16, 0, 0, 1, -67, 0, -78, -124, -128, 36, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 16, 2, 44, -25, -28, 64, -88, -88, -50, -88, 11, -88, 11, 122, 64, 38, -50, 117, 87, -122, 79, 4, 42, -53, -75, -110, 118, 103, -9, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 44, -24, -28, 64, -39, 4, 55, -105, 118, -89, 4, 76, 76, 4, 107, 67, -110, 4, -116, -12, 28, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 44, -23, -28, -29, -39, 4, 55, -105, 118, -89, 4, 76, -51, 4, 107, 67, -110, 4, -116, -12, -99, 4, 11, 42, -53, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};

    public static void setPmtPids(List list) throws IOException {
        int n;
        Object[] objectArray;
        if (myTTX) {
            list.add("927");
        }
        if ((objectArray = list.toArray()).length == 0) {
            Common.setMessage(Resource.getString("ts.msg1"));
            autopmt = pmt;
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Arrays.sort(objectArray);
        int n2 = 1;
        byteArrayOutputStream.write(pmtStart);
        firstID = 0xFF & Integer.parseInt(objectArray[0].toString());
        TS.pmtPCR[2] = (byte)firstID;
        TS.updateHeader(23, firstID);
        byteArrayOutputStream.write(pmtPCR);
        block6: for (int i = 0; i < objectArray.length; ++i) {
            n = Integer.parseInt(objectArray[i].toString());
            switch (0xF & n >>> 8) {
                case 0: {
                    TS.pmtMPV[2] = (byte)(0xFF & n);
                    TS.pmtMPV[7] = (byte)n2++;
                    byteArrayOutputStream.write(pmtMPV);
                    continue block6;
                }
                case 1: {
                    TS.pmtMPA[2] = (byte)(0xFF & n);
                    TS.pmtMPA[7] = (byte)n2++;
                    byteArrayOutputStream.write(pmtMPA);
                    continue block6;
                }
                case 2: {
                    TS.pmtAC3[2] = (byte)(0xFF & n);
                    TS.pmtAC3[7] = (byte)n2++;
                    byteArrayOutputStream.write(pmtAC3);
                    TS.pmtAC3_atsc[2] = (byte)(0xFF & n);
                    TS.pmtAC3_atsc[7] = (byte)(n2 - 1);
                    byteArrayOutputStream.write(pmtAC3_atsc);
                    continue block6;
                }
                case 3: {
                    TS.pmtTTX[2] = (byte)(0xFF & n);
                    TS.pmtTTX[7] = (byte)n2++;
                    byteArrayOutputStream.write(pmtTTX);
                }
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        n = byArray.length;
        byArray[2] = (byte)(0xB0 | 0xF & n >> 8);
        byArray[3] = (byte)(0xFF & n);
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(TS.generateCRC32(byArray, 1));
        byArray = byteArrayOutputStream.toByteArray();
        int n3 = (byArray.length - 1) / 184 + 1;
        autopmt = new byte[n3 * 188];
        Arrays.fill(autopmt, (byte)-1);
        int n4 = 0;
        int n5 = 0;
        while (n4 < byArray.length) {
            System.arraycopy(pmtHead, 0, autopmt, n5, 4);
            if (byArray.length >= n4 + 184) {
                System.arraycopy(byArray, n4, autopmt, 4 + n5, 184);
                n4 += 184;
                n5 += 188;
                continue;
            }
            System.arraycopy(byArray, n4, autopmt, 4 + n5, byArray.length - n4);
            break;
        }
        TS.autopmt[1] = 65;
        byteArrayOutputStream.close();
    }

    public static byte[] getAutoPMT() {
        for (int i = 0; i < autopmt.length; i += 188) {
            TS.autopmt[i + 3] = (byte)(0x10 | 0xF & count1++);
        }
        return autopmt;
    }

    public static int getfirstID() {
        return firstID;
    }

    public static void setfirstID() {
        firstID = 224;
        TS.pmtPCR[2] = (byte)firstID;
        TS.updateHeader(23, firstID);
    }

    public static byte[] getTTX(byte[] byArray, int n, String string) {
        byte[] byArray2 = string.getBytes();
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = Teletext.bytereverse(Teletext.parity(byArray2[i]));
        }
        System.arraycopy(byArray2, 0, ttx, 169, byArray2.length);
        System.arraycopy(byArray, 9 + n, ttx, 13, 5);
        ttx[13] = (byte)(ttx[13] & 0xFFFFFFEF);
        TS.ttx[3] = (byte)(0x10 | 0xF & count3++);
        return ttx;
    }

    public static byte[] getPMT() {
        TS.pmt[3] = (byte)(0x10 | 0xF & count1++);
        return pmt;
    }

    public static byte[] getPAT() {
        TS.pat[3] = (byte)(0x10 | 0xF & count2++);
        return pat;
    }

    public static byte[] getPCR(long l, int n, int n2) {
        TS.pcr[2] = (byte)n2;
        TS.pcr[3] = (byte)(0x20 | 0xF & n);
        TS.pcr[6] = (byte)(0xFFL & l >>> 25);
        TS.pcr[7] = (byte)(0xFFL & l >>> 17);
        TS.pcr[8] = (byte)(0xFFL & l >>> 9);
        TS.pcr[9] = (byte)(0xFFL & l >>> 1);
        TS.pcr[10] = (byte)((1L & l) << 7);
        return pcr;
    }

    public static byte[] init(String string, boolean bl, boolean bl2, int n) {
        count3 = 0;
        count2 = 0;
        count1 = 0;
        myTTX = bl2;
        Arrays.fill(pat, (byte)-1);
        Arrays.fill(pmt, (byte)-1);
        Arrays.fill(pcr, (byte)-1);
        System.arraycopy(pmt1, 0, pmt, 0, pmt1.length);
        System.arraycopy(pat1, 0, pat, 0, pat1.length);
        System.arraycopy(pcr1, 0, pcr, 0, pcr1.length);
        switch (n) {
            case 1: {
                return TS.initTF4000header(string, bl);
            }
            case 2: {
                return TS.initTF5000header(string, bl, 1692);
            }
            case 3: {
                return TS.initTF5000header(string, bl, 3760);
            }
        }
        return new byte[0];
    }

    private static void updateHeader(int n, int n2) {
        TS.TF4000header[n] = (byte)n2;
        TS.TF5000header[n] = (byte)n2;
    }

    public static String updateAdditionalHeader(String string, long[] lArray, int n) throws IOException {
        String string2 = "";
        switch (n) {
            case 0: {
                return string;
            }
            case 1: {
                string2 = string.substring(0, string.length() - 3) + ".raw";
                if (new File(string2).exists()) {
                    new File(string2).delete();
                }
                Common.renameTo(string, string2);
                TS.finishTF4000header(string2, lArray);
                break;
            }
            case 2: 
            case 3: {
                string2 = string.substring(0, string.length() - 3) + ".rec";
                if (new File(string2).exists()) {
                    new File(string2).delete();
                }
                Common.renameTo(string, string2);
                TS.finishTF5000header(string2, lArray);
            }
        }
        return string2;
    }

    private static void finishTF4000header(String string, long[] lArray) throws IOException {
        long[] lArray2 = new long[4];
        long l = (lArray[1] - lArray[0]) / 90L;
        short s = (short)(0xFFFF & Math.round((float)l / 60000.0f));
        lArray2[0] = System.currentTimeMillis();
        lArray2[1] = lArray2[0] - l;
        lArray2[2] = lArray2[0] / 86400000L + 40587L;
        lArray2[3] = lArray2[1] / 86400000L + 40587L;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(lArray2[0]));
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        randomAccessFile.seek(0L);
        randomAccessFile.writeShort((short)lArray2[2]);
        randomAccessFile.writeByte((byte)calendar.get(11));
        randomAccessFile.writeByte((byte)calendar.get(12));
        randomAccessFile.writeShort((short)lArray2[2]);
        randomAccessFile.writeByte((byte)calendar.get(11));
        randomAccessFile.writeByte((byte)calendar.get(12));
        randomAccessFile.writeShort(s);
        randomAccessFile.seek(68L);
        randomAccessFile.writeShort((short)lArray2[2]);
        randomAccessFile.writeByte((byte)calendar.get(11));
        randomAccessFile.writeByte((byte)calendar.get(12));
        randomAccessFile.writeShort(s);
        calendar.setTime(new Date(lArray2[1]));
        randomAccessFile.seek(64L);
        randomAccessFile.writeShort((short)lArray2[3]);
        randomAccessFile.writeByte((byte)calendar.get(11));
        randomAccessFile.writeByte((byte)calendar.get(12));
        randomAccessFile.close();
    }

    private static void finishTF5000header(String string, long[] lArray) throws IOException {
        long[] lArray2 = new long[4];
        long l = (lArray[1] - lArray[0]) / 90L;
        short s = (short)(0xFFFF & Math.round((float)l / 60000.0f));
        lArray2[0] = System.currentTimeMillis();
        lArray2[1] = lArray2[0] - l;
        lArray2[2] = lArray2[0] / 86400000L + 40587L;
        lArray2[3] = lArray2[1] / 86400000L + 40587L;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(lArray2[0]));
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        randomAccessFile.seek(8L);
        randomAccessFile.writeShort(s);
        randomAccessFile.seek(70L);
        randomAccessFile.writeShort(s);
        randomAccessFile.seek(80L);
        randomAccessFile.writeShort((short)lArray2[2]);
        randomAccessFile.writeByte((byte)calendar.get(11));
        randomAccessFile.writeByte((byte)calendar.get(12));
        calendar.setTime(new Date(lArray2[1]));
        randomAccessFile.seek(76L);
        randomAccessFile.writeShort((short)lArray2[3]);
        randomAccessFile.writeByte((byte)calendar.get(11));
        randomAccessFile.writeByte((byte)calendar.get(12));
        String string2 = new File(string).getName();
        if (string2.length() > 128) {
            string2 = string2.substring(0, 128);
        }
        randomAccessFile.seek(85L);
        randomAccessFile.writeUTF(string2);
        randomAccessFile.seek(86L);
        int n = randomAccessFile.read();
        randomAccessFile.seek(85L);
        randomAccessFile.writeShort(n << 8);
        randomAccessFile.close();
    }

    private static byte[] initTF4000header(String string, boolean bl) {
        byte[] byArray = new byte[564];
        System.arraycopy(TF4000header, 0, byArray, 0, TF4000header.length);
        byte[] byArray2 = new File(string).getName().getBytes();
        byArray[75] = (byte)(byArray2.length - 3);
        System.arraycopy(byArray2, 0, byArray, 76, byArray2.length - 3);
        if (bl) {
            byArray[26] = 0;
            byArray[27] = -128;
        } else {
            byArray[26] = 0;
            byArray[27] = -64;
        }
        return byArray;
    }

    private static byte[] initTF5000header(String string, boolean bl, int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(TF5000header, 0, byArray, 0, TF5000header.length);
        byte[] byArray2 = new File(string).getName().getBytes();
        byArray[75] = (byte)(byArray2.length - 3);
        System.arraycopy(byArray2, 0, byArray, 76, byArray2.length - 3);
        if (bl) {
            byArray[26] = 0;
            byArray[27] = -128;
        } else {
            byArray[26] = 0;
            byArray[27] = -64;
        }
        return byArray;
    }

    private static byte[] generateCRC32(byte[] byArray, int n) {
        int n2;
        int[] nArray = new int[]{1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1};
        int[] nArray2 = new int[32];
        long l = 0L;
        byte[] byArray2 = new byte[4];
        Arrays.fill(nArray2, 1);
        int n3 = (byArray.length - n) * 8;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            int n6 = n5 = (byArray[n] & 128 >>> n4++) != 0 ? 1 : 0;
            if ((n4 &= 7) == 0) {
                ++n;
            }
            n5 ^= nArray2[31];
            for (int i = 31; i > 0; --i) {
                nArray2[i] = nArray[i] == 1 ? nArray2[i - 1] ^ n5 : nArray2[i - 1];
            }
            nArray2[0] = n5;
        }
        for (n2 = 0; n2 < 32; ++n2) {
            l = l << 1 | (long)nArray2[31 - n2];
        }
        for (n2 = 0; n2 < 4; ++n2) {
            byArray2[n2] = (byte)(0xFFL & l >>> (3 - n2) * 8);
        }
        return byArray2;
    }
}

