/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;

public final class VBI {
    private static long source_pts = 0L;
    private static String vps_str = "";
    private static String[] vps_sound_mode = new String[]{"n/a", "mono", "stereo", "dual"};
    private static byte[] wss = new byte[3];

    private VBI() {
    }

    public static void reset() {
        source_pts = 0L;
        vps_str = "";
        wss = new byte[3];
    }

    public static void parsePES(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        if (byArray[n] != 0 || byArray[1 + n] != 0 || byArray[2 + n] != 1) {
            return;
        }
        int n2 = 0xFF & byArray[3 + n];
        int n3 = (0xFF & byArray[4 + n]) << 8 | 0xFF & byArray[5 + n];
        int n4 = 0xC0 & byArray[6 + n];
        if (n4 != 128 && n4 != 64) {
            return;
        }
        int n5 = 0xFF & byArray[8 + n];
        boolean bl = (0x80 & byArray[7 + n]) != 0;
        source_pts = bl ? CommonParsing.getPTSfromBytes(byArray, 9 + n) : 0L;
        VBI.decodeVBI(byArray, 9 + n5 + n);
    }

    private static void decodeVBI(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        int n2;
        boolean bl = false;
        if ((0xFC & byArray[n]) != 152 || (3 & byArray[n]) == 0) {
            return;
        }
        for (int i = n + 1; i < byArray.length - 1; i += n2) {
            String string;
            int n3 = 0xFF & byArray[i++];
            n2 = 0xFF & byArray[i++];
            if (n3 == 195) {
                string = VBI.decodeVPS(byArray, i);
                if (string == null || string.equals(vps_str)) continue;
                vps_str = string;
                Common.setMessage(Resource.getString("teletext.msg.vps", string) + " " + Common.formatTime_1(source_pts / 90L));
                continue;
            }
            if (n3 == 196) {
                string = VBI.decodeWSS(byArray, i);
                if (string == null) continue;
                bl = true;
                if (string.length() > 0) {
                    Common.setMessage("-> WSS Status - changed @ PTS " + Common.formatTime_1(source_pts / 90L));
                    Common.setMessage(string);
                    continue;
                }
                if (wss[2] != 0) continue;
                Common.setMessage("-> WSS Status - no change @ PTS " + Common.formatTime_1(source_pts / 90L));
                VBI.wss[2] = -2;
                continue;
            }
            if (n3 != 255) continue;
        }
        if (!bl && wss[2] == -1) {
            VBI.wss[2] = 0;
            Common.setMessage("-> WSS Status - offline @ PTS " + Common.formatTime_1(source_pts / 90L));
        }
    }

    public static String decodeVPS(byte[] byArray, int n) {
        if (!Common.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg6)) {
            return null;
        }
        String string = "";
        if (byArray.length - 1 < n + 12) {
            return null;
        }
        int n2 = (0x3F & byArray[n + 9]) << 24 | (0xFF & byArray[n + 10]) << 16 | (0xFF & byArray[n + 11]) << 8 | 0xFF & byArray[n + 12];
        switch (0x1F & n2 >>> 16) {
            case 28: {
                string = "Contin.";
                break;
            }
            case 29: {
                string = "Pause  ";
                break;
            }
            case 30: {
                string = "Stop   ";
                break;
            }
            case 31: {
                string = "Timer  ";
                break;
            }
            default: {
                string = "" + VBI.formatString(0x1F & n2 >>> 25) + "." + VBI.formatString(0xF & n2 >>> 21) + ".  " + VBI.formatString(0x1F & n2 >>> 16) + ":" + VBI.formatString(0x3F & n2 >>> 10) + "  ";
            }
        }
        string = string + vps_sound_mode[3 & byArray[n + 3] >>> 6] + " " + Integer.toHexString(0xF & n2 >>> 6).toUpperCase() + " " + Integer.toHexString(0x3F & n2).toUpperCase();
        return string;
    }

    private static String formatString(int n) {
        String string = "00" + String.valueOf(n);
        return string.substring(string.length() - 2);
    }

    private static String decodeWSS(byte[] byArray, int n) {
        if (!Common.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg5)) {
            return null;
        }
        if (byArray.length - 1 < n + 2) {
            return null;
        }
        if (byArray[n + 1] == wss[0] && byArray[n + 2] == wss[1]) {
            return "";
        }
        System.arraycopy(byArray, n + 1, wss, 0, 2);
        VBI.wss[2] = -1;
        String string = VBI.getGroup1(wss);
        string = string + VBI.getGroup2(wss);
        string = string + VBI.getGroup3(wss);
        string = string + VBI.getGroup4(wss);
        return string;
    }

    private static String getGroup1(byte[] byArray) {
        String string = "";
        switch (0xF & byArray[0] >> 4) {
            case 1: {
                string = "  " + Resource.getString("wss.group_1.0001");
                break;
            }
            case 8: {
                string = "  " + Resource.getString("wss.group_1.1000");
                break;
            }
            case 4: {
                string = "  " + Resource.getString("wss.group_1.0100");
                break;
            }
            case 13: {
                string = "  " + Resource.getString("wss.group_1.1101");
                break;
            }
            case 2: {
                string = "  " + Resource.getString("wss.group_1.0010");
                break;
            }
            case 7: {
                string = "  " + Resource.getString("wss.group_1.0111");
                break;
            }
            case 14: {
                string = "  " + Resource.getString("wss.group_1.1110");
                break;
            }
            default: {
                string = "  " + Resource.getString("wss.group_1.error");
            }
        }
        string = string + "\n";
        return string;
    }

    private static String getGroup2(byte[] byArray) {
        String string = "";
        switch (1 & byArray[0] >> 3) {
            case 0: {
                string = string + "  " + Resource.getString("wss.group_2.0.01");
                break;
            }
            case 1: {
                string = string + "  " + Resource.getString("wss.group_2.0.10");
            }
        }
        string = string + ",";
        switch (1 & byArray[0] >> 2) {
            case 0: {
                string = string + "  " + Resource.getString("wss.group_2.1.01");
                break;
            }
            case 1: {
                string = string + "  " + Resource.getString("wss.group_2.1.10");
            }
        }
        string = string + ",";
        switch (1 & byArray[0] >> 1) {
            case 0: {
                string = string + "  " + Resource.getString("wss.group_2.2.01");
                break;
            }
            case 1: {
                string = string + "  " + Resource.getString("wss.group_2.2.10");
            }
        }
        string = string + ",";
        switch (1 & byArray[0]) {
            case 0: {
                string = string + "  " + Resource.getString("wss.group_2.3.01");
                break;
            }
            case 1: {
                string = string + "  " + Resource.getString("wss.group_2.3.10");
            }
        }
        string = string + "\n";
        return string;
    }

    private static String getGroup3(byte[] byArray) {
        String string = "";
        switch (1 & byArray[1] >> 7) {
            case 0: {
                string = string + "  " + Resource.getString("wss.group_3.0.01");
                break;
            }
            case 1: {
                string = string + "  " + Resource.getString("wss.group_3.0.10");
            }
        }
        string = string + ",";
        switch (3 & byArray[1] >> 5) {
            case 0: {
                string = string + "  " + Resource.getString("wss.group_3.1.00");
                break;
            }
            case 1: {
                string = string + "  " + Resource.getString("wss.group_3.1.01");
                break;
            }
            case 2: {
                string = string + "  " + Resource.getString("wss.group_3.1.10");
                break;
            }
            case 3: {
                string = string + "  " + Resource.getString("wss.group_3.1.11");
            }
        }
        string = string + "\n";
        return string;
    }

    private static String getGroup4(byte[] byArray) {
        String string = "";
        switch (1 & byArray[1] >> 4) {
            case 0: {
                string = string + "  " + Resource.getString("wss.group_4.0.01");
                break;
            }
            case 1: {
                string = string + "  " + Resource.getString("wss.group_4.0.10");
            }
        }
        string = string + ",";
        switch (1 & byArray[1] >> 3) {
            case 0: {
                string = string + "  " + Resource.getString("wss.group_4.1.01");
                break;
            }
            case 1: {
                string = string + "  " + Resource.getString("wss.group_4.1.10");
            }
        }
        string = string + ",";
        switch (1 & byArray[1] >> 2) {
            case 0: {
                string = string + "  " + Resource.getString("wss.group_4.2.01");
                break;
            }
            case 1: {
                string = string + "  " + Resource.getString("wss.group_4.2.10");
            }
        }
        return string;
    }
}

