/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PushbackInputStream;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StripRelook {
    private boolean debug = Common.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
    private int type = 0;

    public StripRelook(int n) {
        this.type = n;
    }

    public XInputFile[] process(XInputFile xInputFile, String string) {
        XInputFile[] xInputFileArray;
        String string2 = string + System.getProperty("file.separator") + xInputFile.getName();
        String string3 = string2 + "[stripped].vpes";
        String string4 = string2 + "[stripped].apes";
        String string5 = string2 + "[stripped].tpes";
        try {
            xInputFileArray = new PushbackInputStream(xInputFile.getInputStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string3), 5120000);
            BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(new FileOutputStream(string4), 4096000);
            BufferedOutputStream bufferedOutputStream3 = new BufferedOutputStream(new FileOutputStream(string5), 4096000);
            int n = 0;
            int[] nArray = new int[]{49152, 59392};
            long l = xInputFile.length();
            byte[] byArray = new byte[nArray[this.type]];
            for (long i = 0L; i < l; i += (long)byArray.length) {
                int n2;
                int n3 = xInputFileArray.read(byArray);
                if (n3 < byArray.length) {
                    xInputFileArray.read(byArray, n3, byArray.length - n3);
                }
                int n4 = this.getValue(byArray, 0);
                int n5 = this.getValue(byArray, 4);
                int n6 = this.getValue(byArray, 8);
                int n7 = this.getValue(byArray, 12);
                int n8 = this.getValue(byArray, 16);
                int n9 = this.getValue(byArray, 20);
                int n10 = n2 = this.type == 0 ? 0 : this.getValue(byArray, 32);
                if (this.debug) {
                    System.out.println("rl pos + " + i + " /v " + n6 + " /a " + n5 + " /t " + n2);
                }
                if (n6 > 0) {
                    bufferedOutputStream.write(byArray, 512, n6);
                }
                if (n5 > 0) {
                    bufferedOutputStream2.write(byArray, 37376, n5);
                }
                if (n2 > 0) {
                    bufferedOutputStream3.write(byArray, 49152, n2);
                }
                ++n;
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedOutputStream2.flush();
            bufferedOutputStream2.close();
            bufferedOutputStream3.flush();
            bufferedOutputStream3.close();
            xInputFileArray.close();
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
            return null;
        }
        xInputFileArray = new XInputFile[3];
        xInputFileArray = this.finishFile(string3, xInputFileArray, 0);
        xInputFileArray = this.finishFile(string4, xInputFileArray, 1);
        xInputFileArray = this.finishFile(string5, xInputFileArray, 2);
        return xInputFileArray;
    }

    private int getValue(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 |= (0xFF & byArray[n + i]) << (3 - i) * 8;
        }
        return n2;
    }

    private XInputFile[] finishFile(String string, XInputFile[] xInputFileArray, int n) {
        File file = new File(string);
        if (this.debug) {
            System.out.println("rl file + " + n + " /l " + file.length());
        }
        if (file.length() > 100L) {
            xInputFileArray[n] = new XInputFile(file);
        } else {
            file.delete();
        }
        return xInputFileArray;
    }
}

