/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.io.IDDBufferedOutputStream;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.StreamProcessBase;
import net.sourceforge.dvb.projectx.subtitle.BMP;
import net.sourceforge.dvb.projectx.subtitle.Bitmap;
import net.sourceforge.dvb.projectx.subtitle.Subpicture;
import net.sourceforge.dvb.projectx.subtitle.Sup2VobSub;
import net.sourceforge.dvb.projectx.subtitle.Teletext;
import net.sourceforge.dvb.projectx.thirdparty.Ifo;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StreamProcessSubpicture
extends StreamProcessBase {
    private final String[] subdecode_errors = new String[]{"", "", "", Resource.getString("subpicture.msg.error3"), Resource.getString("subpicture.msg.error4"), Resource.getString("subpicture.msg.error5"), Resource.getString("subpicture.msg.error6"), Resource.getString("subpicture.msg.error7"), Resource.getString("subpicture.msg.error8"), Resource.getString("subpicture.msg.error9")};
    private String Extension = ".new";
    private boolean debug;
    private boolean KeepOriginalTimecode;
    private boolean ExportAsVobSub;
    private boolean UseAdditionalOffset;
    private boolean ShowSubpictureWindow;
    private boolean Message_2;
    private int AdditionalOffset_Value;
    private int X_Offset = 0;
    private int Y_Offset = 0;
    private int DisplayMode = 0;
    private String SubpictureColorModel;
    private String PageId_Value;
    private String SubtitleExportFormat;

    public StreamProcessSubpicture(String string) {
        this.Extension = string;
    }

    public StreamProcessSubpicture(JobCollection jobCollection, XInputFile xInputFile, String string, String string2, String string3, int n) {
        this.get_XY_Offset(jobCollection, n);
        this.getDisplayMode(jobCollection, n);
        String string4 = jobCollection.getSettings().getProperty(Keys.KEY_SubtitleExportFormat);
        this.processStream(jobCollection, xInputFile, string, string2, string3, n, string4);
        string4 = jobCollection.getSettings().getProperty(Keys.KEY_SubtitleExportFormat_2);
        if (!string4.equalsIgnoreCase("null")) {
            this.processStream(jobCollection, xInputFile, string, string2, string3, n, string4);
        }
    }

    public void set_XY_Offset(int n, int n2) {
        this.X_Offset = n;
        this.Y_Offset = n2;
    }

    private void get_XY_Offset(JobCollection jobCollection, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(jobCollection.getSettings().getProperty(Keys.KEY_SubtitleMovePosition_Value), ",");
        int[] nArray = new int[2];
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < nArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.X_Offset = nArray[0];
        this.Y_Offset = nArray[1];
    }

    private void getDisplayMode(JobCollection jobCollection, int n) {
        this.DisplayMode = jobCollection.getSettings().getIntProperty(Keys.KEY_SubtitleChangeDisplay);
    }

    public void processStream(JobCollection jobCollection, XInputFile xInputFile, int n) {
        this.processStream(jobCollection, xInputFile, "-1", "sp", "-1", n, Keys.ITEMS_SubtitleExportFormat[7].toString());
    }

    private void processStream(JobCollection jobCollection, XInputFile xInputFile, String string, String string2, String string3, int n, String string4) {
        Subpicture subpicture = Common.getSubpictureClass();
        JobProcessing jobProcessing = jobCollection.getJobProcessing();
        String string5 = n == 1 ? jobCollection.getOutputName(xInputFile.getName()) : xInputFile.getName();
        String string6 = jobCollection.getOutputNameParent(string5);
        string6 = string6 + (n == 1 ? this.Extension : "");
        String string7 = string6 + ".sup";
        long l = xInputFile.length();
        byte[] byArray = new byte[12];
        byte[] byArray2 = new byte[]{};
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = -1L;
        long l9 = 0L;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        this.debug = jobCollection.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
        this.KeepOriginalTimecode = n == 1 ? true : jobCollection.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_keepOriginalTimecode);
        this.ExportAsVobSub = jobCollection.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_exportAsVobSub);
        this.UseAdditionalOffset = jobCollection.getSettings().getBooleanProperty(Keys.KEY_additionalOffset);
        this.ShowSubpictureWindow = jobCollection.getSettings().getBooleanProperty(Keys.KEY_showSubpictureWindow);
        this.Message_2 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg2);
        this.AdditionalOffset_Value = jobCollection.getSettings().getIntProperty(Keys.KEY_ExportPanel_additionalOffset_Value);
        this.SubpictureColorModel = jobCollection.getSettings().getProperty(Keys.KEY_SubpictureColorModel);
        this.PageId_Value = jobCollection.getSettings().getProperty(Keys.KEY_SubtitlePanel_PageId_Value);
        try {
            int n7;
            if (this.ShowSubpictureWindow) {
                Common.getGuiInterface().showSubpicture();
            }
            Hashtable hashtable = new Hashtable();
            ArrayList arrayList = Common.getColorModelsList();
            if (arrayList.indexOf(this.SubpictureColorModel) > 2) {
                hashtable = Common.getUserColourTable(this.SubpictureColorModel);
            }
            subpicture.reset();
            subpicture.dvb.setIRD(2 << arrayList.indexOf(this.SubpictureColorModel), hashtable, this.debug, this.PageId_Value);
            Common.setMessage(Resource.getString("subpicture.msg.model", this.SubpictureColorModel) + " " + this.PageId_Value);
            if (string4.equalsIgnoreCase(Keys.ITEMS_SubtitleExportFormat[6].toString())) {
                string7 = string6 + ".son";
                bl = true;
            }
            Common.setMessage("");
            Common.setMessage(Resource.getString("subpicture.msg.output") + " " + string7.substring(string7.length() - 3));
            PushbackInputStream pushbackInputStream = new PushbackInputStream(xInputFile.getInputStream(), 65536);
            IDDBufferedOutputStream iDDBufferedOutputStream = new IDDBufferedOutputStream(new FileOutputStream(string7), 65536);
            PrintStream printStream = new PrintStream(iDDBufferedOutputStream);
            Common.setMessage(Resource.getString("subpicture.msg.tmpfile", xInputFile.getName(), "" + l));
            if (!bl) {
                subpicture.set_XY_Offset(this.X_Offset, this.Y_Offset);
                subpicture.setDisplayMode(this.DisplayMode);
            }
            if (this.X_Offset != 0 || this.Y_Offset != 0) {
                Common.setMessage("-> move source picture position: X " + this.X_Offset + ", Y " + this.Y_Offset);
            }
            if (this.DisplayMode != 0) {
                Common.setMessage("-> set new picture display mode: " + Keys.ITEMS_SubtitleChangeDisplay[this.DisplayMode]);
            }
            Common.updateProgressBar(Resource.getString("subpicture.progress") + " " + xInputFile.getName(), 0L, 0L);
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long[] lArray3 = new long[]{0L};
            long l10 = this.UseAdditionalOffset ? 90L * (long)this.AdditionalOffset_Value : 0L;
            long[][] lArray4 = this.loadTempOtherPts(string, "subpicture.msg.discard", "audio.msg.pts.firstonly", "subpicture.msg.pts.start_end", "", 5, false, this.debug);
            if (lArray4 != null) {
                lArray = lArray4[0];
                lArray2 = lArray4[1];
                bl3 = true;
                lArray4 = null;
            }
            bl3 = true;
            lArray4 = this.loadTempVideoPts(string3, this.debug);
            if (lArray4 != null) {
                lArray3 = lArray4[0];
                bl2 = true;
                lArray4 = null;
            }
            if (bl2 && bl3) {
                n7 = this.checkPTSMatch(lArray3, lArray);
                if (n7 < 0) {
                    Common.setMessage(Resource.getString("subpicture.msg.pts.mismatch"));
                    bl2 = false;
                    n2 = 0;
                } else {
                    n2 = n7;
                }
            }
            if (bl2 && bl3) {
                Common.setMessage(Resource.getString("subpicture.msg.adjust.at.video"));
                l4 = lArray3[0];
            }
            if (!bl2 && bl3) {
                Common.setMessage(Resource.getString("subpicture.msg.adjust.at.own"));
                l4 = 0L;
            }
            if (bl3) {
                l6 = lArray[n2];
                l3 = lArray2[n2];
            }
            lArray = null;
            lArray2 = null;
            while (l2 < l3) {
                l2 += pushbackInputStream.skip(l3 - l2);
            }
            while (l2 < l) {
                Common.updateProgressBar(l2, l);
                while (this.pause()) {
                }
                if (CommonParsing.isProcessCancelled()) {
                    CommonParsing.setProcessCancelled(false);
                    jobProcessing.setSplitSize(0L);
                    break;
                }
                pushbackInputStream.read(byArray, 0, 12);
                if (byArray[0] != 83 || byArray[1] != 80) {
                    if (this.Message_2 && !bl5) {
                        Common.setMessage(Resource.getString("subpicture.msg.syncword.lost") + " " + l2);
                    }
                    bl5 = true;
                    ++l2;
                    pushbackInputStream.unread(byArray, 1, 11);
                    continue;
                }
                if (this.Message_2 && bl5) {
                    Common.setMessage(Resource.getString("subpicture.msg.syncword.found") + " " + l2);
                }
                pushbackInputStream.unread(byArray, 0, 12);
                bl5 = false;
                n5 = ((0xFF & byArray[10]) << 8 | 0xFF & byArray[11]) + 10;
                byArray2 = new byte[n5];
                pushbackInputStream.read(byArray2);
                l2 += (long)n5;
                l6 = 0L;
                for (n7 = 0; n7 < 5; ++n7) {
                    l6 |= (0xFFL & (long)byArray2[2 + n7]) << n7 * 8;
                }
                if (string.equals("-1")) {
                    l6 += l10;
                }
                if (l6 == l10 && l8 != -1L) {
                    l6 = l9;
                } else {
                    l9 = l6;
                }
                if (l8 == -1L) {
                    l8 = l6;
                }
                if (this.debug) {
                    System.out.println(" " + (l2 - (long)n5) + "/ " + n5 + "/ " + l6);
                }
                if (bl3) {
                    boolean bl7 = bl4 = !bl2;
                    while (bl2 && n4 < lArray3.length && l6 >= lArray3[n4]) {
                        if (l6 == lArray3[n4] || l6 < lArray3[n4 + 1]) {
                            bl4 = true;
                            break;
                        }
                        if ((n4 += 2) >= lArray3.length) continue;
                        l4 += lArray3[n4] - lArray3[n4 - 1];
                    }
                } else {
                    bl4 = true;
                }
                if (!bl2 && l4 == 0L && !this.KeepOriginalTimecode) {
                    l4 = l6;
                }
                l7 = l6 - l4;
                l5 = subpicture.decode_picture(byArray2, 10, Common.getGuiInterface().isSubpictureVisible(), jobProcessing.getStatusStrings(), l7, bl4, Common.getGuiInterface().isSubpictureVisible());
                if (l5 < -2L) {
                    Common.setMessage(Resource.getString("subpicture.msg.error", this.subdecode_errors[Math.abs((int)l5)], String.valueOf(l2 - (long)n5)));
                }
                if (this.debug) {
                    System.out.println("PTS: source " + Common.formatTime_1(l6 / 90L) + "(" + l6 + ")" + " /new " + Common.formatTime_1(l7 / 90L) + "(" + l7 + ")" + " / write: " + bl4 + " / dec.state: " + l5);
                }
                if (l5 < 0L) {
                    if (!bl6) {
                        Common.setMessage(Resource.getString("subpicture.msg.dvbsource"));
                    }
                    bl6 = true;
                    if (l5 == -1L) {
                        String string8 = "00000" + n3;
                        String string9 = string6 + "_st" + string8.substring(string8.length() - 5);
                        Enumeration enumeration = BMP.getKeys();
                        while (enumeration.hasMoreElements()) {
                            String string10 = enumeration.nextElement().toString();
                            int n8 = Integer.parseInt(string10);
                            String string11 = Integer.toHexString(n8).toUpperCase();
                            String string12 = string9 + "p" + string11;
                            Bitmap bitmap = BMP.getBitmap(n8);
                            if (!bl) {
                                iDDBufferedOutputStream.write(subpicture.writeRLE(bitmap));
                            } else {
                                int n9;
                                if (n3 == 0) {
                                    String[] stringArray = Teletext.getSONHead(new File(string7).getParent(), (long)CommonParsing.getVideoFramerate());
                                    for (int i = 0; i < stringArray.length; ++i) {
                                        printStream.println(stringArray[i]);
                                    }
                                }
                                subpicture.updateUserColorTable(bitmap);
                                string12 = BMP.buildBMP_palettized(string12, bitmap, subpicture.getUserColorTable(), 256);
                                jobProcessing.countMediaFilesExportLength(new File(string12).length());
                                int n10 = subpicture.setPGClinks();
                                if ((0xFFFF & n10) != (0xFFFF & n6)) {
                                    String string13 = "";
                                    for (n9 = 0; n9 < 4; ++n9) {
                                        string13 = string13 + "" + (0xF & n10 >>> n9 * 4) + " ";
                                    }
                                    printStream.println("Color\t\t(" + string13.trim() + ")");
                                }
                                if ((0xFFFF0000 & n10) != (0xFFFF0000 & n6)) {
                                    String string14 = "";
                                    for (n9 = 0; n9 < 4; ++n9) {
                                        string14 = string14 + "" + (0xF & n10 >>> (4 + n9) * 4) + " ";
                                    }
                                    printStream.println("Contrast\t(" + string14.trim() + ")");
                                }
                                n6 = n10;
                                printStream.println("Display_Area\t(" + Common.adaptString(bitmap.getX(), 3) + " " + Common.adaptString(bitmap.getY(), 3) + " " + Common.adaptString(bitmap.getMaxX(), 3) + " " + Common.adaptString(bitmap.getMaxY(), 3) + ")");
                                printStream.println(string9.substring(string9.length() - 4) + "\t\t" + Common.formatTime_2(bitmap.getInTime() / 90L, (long)CommonParsing.getVideoFramerate()) + "\t" + Common.formatTime_2(bitmap.getInTime() / 90L + (long)(bitmap.getPlayTime() * 10), (long)CommonParsing.getVideoFramerate()) + "\t" + new File(string12).getName());
                                if (this.debug) {
                                    System.out.println("-> " + string12);
                                }
                            }
                            Common.getGuiInterface().setSubpictureTitle(" " + Resource.getString("subpicture.preview.title.dvbexport", "" + bitmap.getPageId(), "" + n3, Common.formatTime_1(l7 / 90L)) + " " + Common.formatTime_1(bitmap.getPlayTime() * 10));
                        }
                        if (!BMP.isEmpty()) {
                            Common.getGuiInterface().showExportStatus(Resource.getString("subpicture.status"), ++n3);
                        }
                        BMP.clear();
                    }
                } else if (bl4) {
                    for (n7 = 0; n7 < 8; ++n7) {
                        byArray2[2 + n7] = (byte)(0xFFL & l7 >>> n7 * 8);
                    }
                    iDDBufferedOutputStream.write(byArray2);
                    Common.getGuiInterface().showExportStatus(Resource.getString("subpicture.status"), ++n3);
                    Common.getGuiInterface().setSubpictureTitle(" " + Resource.getString("subpicture.preview.title.dvdexport", "" + n3, Common.formatTime_1(l7 / 90L)) + " " + Common.formatTime_1(l5 / 90L));
                    String string15 = subpicture.isForced_Msg();
                    if (string15 != null) {
                        Common.setMessage(string15 + " " + Resource.getString("subpicture.msg.forced") + " " + n3);
                    }
                } else {
                    Common.getGuiInterface().setSubpictureTitle(" " + Resource.getString("subpicture.preview.title.noexport"));
                }
                if (!this.debug) continue;
                System.out.println("-> wr " + bl4 + " /v " + n4 + " /npts " + l7 + " /tdif " + l4 + " /pic " + n3 + " /dtim " + l5);
                System.out.println("");
            }
            pushbackInputStream.close();
            printStream.flush();
            printStream.close();
            iDDBufferedOutputStream.flush();
            iDDBufferedOutputStream.close();
            if (string.equals("-1")) {
                Common.setMessage(Resource.getString("subpicture.msg.pts.start_end", Common.formatTime_1(l8 / 90L)) + " " + Common.formatTime_1(l6 / 90L));
            }
            Common.setMessage(Resource.getString("subpicture.msg.summary", "" + n3));
            if (!bl6 && bl) {
                String string16 = string7.substring(0, string7.length() - 3) + "sup";
                Common.renameTo(string7, string16);
                string7 = string16;
            }
            File file = new File(string7);
            if (n3 == 0) {
                file.delete();
            } else {
                if (bl6 && !bl) {
                    jobProcessing.countMediaFilesExportLength(Ifo.createIfo(string7, subpicture.getUserColorTableArray()));
                } else if (bl6 && bl) {
                    jobProcessing.countMediaFilesExportLength(new File(BMP.write_ColorTable(string6, subpicture.getUserColorTable(), 256)).length());
                }
                Common.setMessage(Resource.getString("msg.newfile") + " " + string7);
                jobProcessing.countMediaFilesExportLength(file.length());
                jobProcessing.addSummaryInfo(Resource.getString("subpicture.summary", "" + jobProcessing.countPictureStream(), "" + n3, this.infoPTSMatch(string, string3, bl2, bl3)) + "'" + file + "'");
                if (!bl && this.ExportAsVobSub) {
                    new Sup2VobSub(string7, subpicture.getUserColorTableArray());
                }
            }
            Common.updateProgressBar(l, l);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        if (this.ShowSubpictureWindow) {
            Common.getGuiInterface().hideSubpicture();
        }
    }
}

