/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import net.sourceforge.dvb.projectx.audio.AudioFormat;
import net.sourceforge.dvb.projectx.audio.MpaConverter;
import net.sourceforge.dvb.projectx.audio.MpaDecoder;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.io.IDDBufferedOutputStream;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.StreamProcessBase;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StreamProcessAudio
extends StreamProcessBase {
    private final int AC3_AUDIOSTREAM = 0;
    private final int MP3_AUDIOSTREAM = 1;
    private final int MP2_AUDIOSTREAM = 2;
    private final int MP1_AUDIOSTREAM = 3;
    private final int DTS_AUDIOSTREAM = 4;
    private final int WAV_AUDIOSTREAM = 5;
    private final int NO_AUDIOSTREAM = 10;
    private MpaConverter MPAConverter = null;
    private MpaDecoder MPADecoder = null;
    private PushbackInputStream InputStream;
    private IDDBufferedOutputStream OutputStream_Ch1;
    private IDDBufferedOutputStream OutputStream_Ch2;
    private String FileName_Ch1;
    private String FileName_Ch2;
    private boolean HasNewFormat;
    private boolean Debug;
    private boolean CreateChapters;
    private boolean WriteEnabled;
    private boolean AddWaveHeaderACM;
    private boolean AddWaveHeaderBWF;
    private boolean AddWaveHeaderAC3;
    private boolean DecodeMpgAudio;
    private boolean ReplaceAc3withSilence;
    private boolean ContainsVideoPTS;
    private boolean ContainsAudioPTS;
    private boolean CreateM2sIndex;
    private boolean Message_2;
    private boolean Message_7;
    private boolean PitchAudio;
    private boolean AllowSpaces;
    private boolean ValidateCRC;
    private boolean Patch1stAc3Header;
    private boolean FillGapsWithLastFrame;
    private boolean LimitPts;
    private boolean AddFrames;
    private boolean DownMix;
    private boolean ChangeByteorder;
    private boolean AddRiffHeader;
    private boolean AddAiffHeader;
    private boolean ClearCRC;
    private boolean IgnoreErrors;
    private boolean CreateDDWave;
    private boolean FadeInOut;
    private boolean Normalize;
    private int FadeInOutMillis;
    private int ResampleAudioMode;
    private int PitchValue;
    private int AudioType;
    private long ModeChangeCount;
    private long ModeChangeCount_JSS;
    private final long ModeChangeCount_Max = 100L;
    private FrameExportInfo FrameExportInfo;
    private int MpaConversionMode;
    private final int MpaConversion_None = 0;
    private final int MpaConversion_Mode1 = 1;
    private final int MpaConversion_Mode2 = 2;
    private final int MpaConversion_Mode3 = 3;
    private final int MpaConversion_Mode4 = 4;
    private long FileLength;
    private final long FileLength_Min = 100L;
    private double TimeCounter;
    private long FramePosition;
    private long CurrentFramePosition;
    private long TimePosition;

    public StreamProcessAudio(JobCollection jobCollection, XInputFile xInputFile, String string, String string2, String string3, int n) {
        this.processStream(jobCollection, xInputFile, string, string2, string3, n);
    }

    private void processStream(JobCollection jobCollection, XInputFile xInputFile, String string, String string2, String string3, int n) {
        Common.updateProgressBar(Resource.getString("audio.progress") + "  " + xInputFile.getName(), 0L, 0L);
        this.Normalize = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_Normalize);
        this.DecodeMpgAudio = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_decodeMpgAudio);
        if (this.MPAConverter == null) {
            this.MPAConverter = new MpaConverter();
        }
        if (this.MPADecoder == null) {
            this.MPADecoder = new MpaDecoder();
        }
        MpaDecoder.RESET = false;
        MpaDecoder.MAX_VALUE = this.Normalize ? Integer.parseInt(jobCollection.getSettings().getProperty(Keys.KEY_AudioPanel_NormalizeValue)) * Short.MAX_VALUE / 100 : Short.MAX_VALUE;
        MpaDecoder.MULTIPLY = this.Normalize ? 32767.0 : 1.0;
        MpaDecoder.PRESCAN = MpaDecoder.NORMALIZE = this.Normalize;
        if (MpaDecoder.MAX_VALUE > Short.MAX_VALUE) {
            MpaDecoder.MAX_VALUE = Short.MAX_VALUE;
            Common.setMessage(Resource.getString("audio.msg.normalize.fixed") + " 100%");
        }
        this.MpaConversionMode = jobCollection.getSettings().getIntProperty(Keys.KEY_AudioPanel_losslessMpaConversionMode);
        if (this.MpaConversionMode > 0) {
            Common.setMessage(Resource.getString("audio.convert") + " " + Keys.ITEMS_losslessMpaConversionMode[this.MpaConversionMode]);
        }
        if (this.DecodeMpgAudio) {
            Common.setMessage(Resource.getString("audio.decode"));
            Common.setMessage("-> " + Keys.ITEMS_resampleAudioMode[jobCollection.getSettings().getIntProperty(Keys.KEY_AudioPanel_resampleAudioMode)]);
            if (this.Normalize) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_Normalize[0]) + " " + 100 * MpaDecoder.MAX_VALUE / Short.MAX_VALUE + "%");
            }
            if (jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_Downmix)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_Downmix[0]));
            }
            if (jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_fadeInOut)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_fadeInOut[0]));
            }
            if (jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_changeByteorder)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_changeByteorder[0]));
            }
            if (jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addRiffHeader)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_addRiffHeader[0]));
            }
            if (jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addAiffHeader)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_addAiffHeader[0]));
            }
        }
        while (this.processAudio(jobCollection, xInputFile, string, string2, string3, n)) {
            CommonParsing.setAudioProcessingFlags(CommonParsing.getAudioProcessingFlags() & 0xFFFFFFFFFFFFFFF3L);
            Common.setMessage(" ");
            Common.setMessage(Resource.getString("audio.restart") + " " + ((CommonParsing.getAudioProcessingFlags() >>> 18) - 1L));
            if (this.DecodeMpgAudio && this.Normalize) {
                Common.setMessage("-> normalize: multiply factor: " + MpaDecoder.MULTIPLY);
            }
            if ((0x10000L & CommonParsing.getAudioProcessingFlags()) != 0L) {
                this.MpaConversionMode = 0;
            }
            this.MPAConverter.resetBuffer();
        }
        CommonParsing.setAudioProcessingFlags(CommonParsing.getAudioProcessingFlags() & 3L);
    }

    private boolean processAudio(JobCollection jobCollection, XInputFile xInputFile, String string, String string2, String string3, int n) {
        String string4 = n == 1 ? jobCollection.getOutputName(xInputFile.getName()) : xInputFile.getName();
        String string5 = jobCollection.getOutputNameParent(string4);
        Common.getGuiInterface().showAVOffset(Resource.getString("MainPanel.AudioVideoOffset"));
        Common.getGuiInterface().showExportStatus(Resource.getString("MainPanel.nonVideoExportStatus"));
        JobProcessing jobProcessing = jobCollection.getJobProcessing();
        if (n == 1 && jobProcessing.getSplitSize() > 0L) {
            string5 = string5 + "(" + jobProcessing.getSplitPart() + ")";
        }
        this.FileName_Ch1 = string5 + ".$mpL$";
        this.FileName_Ch2 = string5 + ".$mpR$";
        this.getSettings(jobCollection);
        this.messageSettings();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        this.ContainsAudioPTS = false;
        this.ContainsVideoPTS = false;
        this.HasNewFormat = true;
        this.WriteEnabled = false;
        byte[] byArray = new byte[4];
        byte[][] byArray2 = new byte[2][1];
        byte[][] byArray3 = new byte[2][1];
        byte[][] byArray4 = new byte[2][0];
        byte[] byArray5 = new byte[10];
        byte[] byArray6 = new byte[1];
        byte[] byArray7 = new byte[4];
        byte[] byArray8 = new byte[24];
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long[] lArray3 = new long[]{0L};
        long[] lArray4 = new long[]{0L};
        this.FramePosition = 0L;
        this.CurrentFramePosition = 0L;
        this.TimePosition = 0L;
        this.TimeCounter = 0.0;
        this.ModeChangeCount = 0L;
        this.ModeChangeCount_JSS = 0L;
        this.FileLength = 0L;
        int[] nArray = new int[]{1, this.PitchValue};
        int n2 = 0;
        this.FrameExportInfo = new FrameExportInfo();
        this.AudioType = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray2 = new int[2];
        boolean bl6 = false;
        boolean bl7 = false;
        int n6 = this.determineStreamType(string2);
        AudioFormat audioFormat = new AudioFormat(n6);
        AudioFormat audioFormat2 = new AudioFormat(6);
        try {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream;
            long[] lArray5;
            block253: {
                int n7;
                long[][] lArray6 = this.loadTempOtherPts(string, "audio.msg.pts.discard", "audio.msg.pts.firstonly", "audio.msg.pts.start_end", "", 0, this.IgnoreErrors, this.Debug);
                if (lArray6 != null) {
                    lArray = lArray6[0];
                    lArray2 = lArray6[1];
                    this.ContainsAudioPTS = true;
                    lArray6 = null;
                }
                if ((lArray6 = this.loadTempVideoPts(string3, this.Debug)) != null) {
                    lArray3 = lArray6[0];
                    lArray4 = lArray6[1];
                    this.ContainsVideoPTS = true;
                    lArray6 = null;
                }
                this.FileLength = xInputFile.length();
                lArray5 = new long[]{0L, 0L};
                if (this.FileLength < 1000L) {
                    Common.setMessage(" Filesize < 1000 byte");
                }
                this.initInputStream(xInputFile);
                this.initOutputStreams();
                this.initProjectFiles();
                byteArrayOutputStream = new ByteArrayOutputStream();
                if (this.ContainsVideoPTS && this.ContainsAudioPTS) {
                    n7 = this.checkPTSMatch(lArray3, lArray);
                    if (n7 < 0) {
                        Common.setMessage(Resource.getString("audio.msg.pts.mismatch"));
                        this.ContainsVideoPTS = false;
                        n3 = 0;
                    } else {
                        n3 = n7;
                    }
                }
                if (this.ContainsVideoPTS) {
                    Common.setMessage(Resource.getString("audio.msg.adjust.at.videopts"));
                } else if (this.ContainsAudioPTS && n != 1) {
                    Common.setMessage(Resource.getString("audio.msg.adjust.at.ownpts"));
                }
                if (this.ContainsAudioPTS) {
                    this.TimePosition = lArray[n3];
                    this.FramePosition = lArray2[n3];
                }
                if (this.FramePosition > 0L) {
                    this.skipInputStream(this.FramePosition);
                }
                audioFormat.initExtraWaveHeader(this.AddWaveHeaderACM, this.AddWaveHeaderBWF, this.AddWaveHeaderAC3);
                this.addWaveHeader(audioFormat, n6);
                this.initDecoder(audioFormat, n6);
                audioFormat.setAncillaryDataDecoder(this.Message_7, this.Debug);
                if (n6 == 4) {
                    this.processPCMData(jobProcessing, audioFormat, lArray3, lArray);
                } else {
                    byte[] byArray9;
                    block11: while ((n6 == 0 || n6 == 6) && this.FramePosition < this.FileLength - 10L) {
                        Common.updateProgressBar(this.FramePosition, this.FileLength);
                        if (this.Debug) {
                            System.out.println("FramePosition " + this.FramePosition);
                        }
                        while (this.pause()) {
                        }
                        if (this.isCancelled(jobProcessing)) break block253;
                        if (lArray2[n3 + 1] != -1L && this.FramePosition > lArray2[n3 + 1]) {
                            Common.setMessage(Resource.getString("audio.msg.pts.wo_frame") + " (" + lArray2[n3 + 1] + "/" + this.FramePosition + ")");
                            ++n3;
                        }
                        this.FramePosition += (long)this.readInputStream(byArray5, 0, 10);
                        int n8 = this.ERRORCODE = bl5 || !bl4 ? audioFormat.parseHeader(byArray5, 0) : 0;
                        if (this.ERRORCODE < 1) {
                            if (!bl5 || bl4) {
                                this.ERRORCODE = audioFormat2.parseHeader(byArray5, 0);
                            }
                            if (this.ERRORCODE < 1) {
                                this.unreadInputStream(byArray5, 1, 9);
                                if (this.Message_2 && !bl3) {
                                    Common.setMessage(Resource.getString("audio.msg.syncword.lost", " " + (this.FramePosition - 10L)) + " " + this.formatFrameTime(this.TimeCounter));
                                }
                                bl3 = true;
                                this.FramePosition -= 9L;
                                continue;
                            }
                            bl4 = true;
                            bl5 = false;
                            n6 = 6;
                            audioFormat = new AudioFormat(n6);
                            audioFormat.parseHeader(byArray5, 0);
                        } else {
                            bl4 = false;
                            bl5 = true;
                        }
                        this.OutputStream_Ch1.setWave(this.CreateDDWave, bl5, bl4, audioFormat.getBitrate());
                        this.FramePosition -= (long)this.unreadInputStream(byArray5, 0, 10);
                        byArray6 = new byte[audioFormat.getSize()];
                        this.readInputStream(byArray6, 0, audioFormat.getSize());
                        this.CurrentFramePosition = this.FramePosition;
                        this.FramePosition += (long)audioFormat.getSize();
                        if (this.PitchAudio && nArray[1] * nArray[0] == this.FrameExportInfo.getWrittenFrames()) {
                            Common.setMessage(Resource.getString("audio.msg.frame.discard") + " " + this.FrameExportInfo.getWrittenFrames() + " (" + nArray[0] + ")");
                            nArray[0] = nArray[0] + 1;
                            continue;
                        }
                        if (this.FramePosition > this.FileLength) break;
                        if (this.FramePosition < this.FileLength - 10L) {
                            if (!this.AllowSpaces) {
                                this.readInputStream(byArray8, 0, 24);
                                for (n7 = 0; n7 < (bl4 ? 15 : 17); ++n7) {
                                    this.ERRORCODE = audioFormat.parseNextHeader(byArray8, n7);
                                    if (this.ERRORCODE > 0) break;
                                }
                                this.unreadInputStream(byArray8, 0, 24);
                            }
                            if (this.ERRORCODE < 1) {
                                this.unreadInputStream(byArray6, 1, byArray6.length - 1);
                                this.FramePosition = this.CurrentFramePosition + 1L;
                                continue;
                            }
                            this.AudioType = bl4 ? 4 : 0;
                            this.skipInputStream(n7);
                            this.FramePosition += (long)n7;
                        }
                        if (this.ValidateCRC && (this.ERRORCODE = audioFormat.validateCRC(byArray6, 2, audioFormat.getSize())) != 0) {
                            Common.setMessage(Resource.getString("audio.msg.crc.error", "" + this.ERRORCODE) + " " + this.CurrentFramePosition);
                            this.unreadInputStream(byArray6, 2, byArray6.length - 2);
                            this.FramePosition = this.CurrentFramePosition + 2L;
                            continue;
                        }
                        if (this.Message_2 && bl3) {
                            Common.setMessage(Resource.getString("audio.msg.syncword.found") + " " + this.CurrentFramePosition);
                        }
                        bl3 = false;
                        this.determineFormatChange(audioFormat, n6);
                        audioFormat.saveHeader();
                        byArray6 = this.getReplacementFrame(audioFormat, byArray6, n6);
                        Common.setFps(this.FrameExportInfo.getWrittenFrames());
                        if ((!bl2 || n4 < lArray3.length) && bl2 && this.ContainsVideoPTS && (double)lArray3[n4] < (double)this.TimePosition - audioFormat.getFrameTimeLength() / 2.0) {
                            if (!bl4 && this.Patch1stAc3Header && this.FrameExportInfo.getWrittenFrames() == 0) {
                                byArray6 = audioFormat.editFrame(byArray6, audioFormat.getSize(), 1);
                            }
                            long l = lArray3[n4];
                            long[] lArray7 = new long[]{(long)this.TimeCounter, 0L};
                            byteArrayOutputStream.reset();
                            if (!bl4 && !this.FillGapsWithLastFrame) {
                                for (int i = 0; i < Common.getAC3list().size(); ++i) {
                                    object = (byte[])Common.getAC3list().get(i);
                                    if ((0xFE & object[4]) != (0xFE & byArray6[4]) || (7 & object[5]) != (7 & byArray6[5]) || (0xE0 & object[6]) != (0xE0 & byArray6[6])) continue;
                                    byteArrayOutputStream.write((byte[])object);
                                    break;
                                }
                            } else {
                                byteArrayOutputStream.write(byArray6);
                            }
                            while ((double)l < (double)this.TimePosition - audioFormat.getFrameTimeLength() / 2.0) {
                                double d;
                                if (this.ContainsVideoPTS && n5 < lArray3.length) {
                                    double d2 = l - lArray3[n5 + 1];
                                    d = this.TimeCounter - (double)lArray4[n5 + 1];
                                    if (Math.abs(d) <= audioFormat.getFrameTimeLength() / 2.0) {
                                        this.WriteEnabled = false;
                                        n5 += 2;
                                    } else if (Math.abs(d2) <= audioFormat.getFrameTimeLength() / 2.0) {
                                        this.WriteEnabled = false;
                                        n5 += 2;
                                    }
                                }
                                if (this.ContainsVideoPTS && n4 < lArray3.length) {
                                    double d3 = l - lArray3[n4];
                                    d = this.TimeCounter - (double)lArray4[n4];
                                    if (this.Debug) {
                                        System.out.println(" \u00f6" + d3 + "/" + d + "/" + (d - d3));
                                    }
                                    if (!this.WriteEnabled && Math.abs(this.TimeCounter - (double)lArray4[n4] - (double)(l - lArray3[n4])) <= audioFormat.getFrameTimeLength() / 2.0) {
                                        this.WriteEnabled = true;
                                        double d4 = l - lArray3[(n4 += 2) - 2];
                                        double d5 = this.TimeCounter - (double)lArray4[n4 - 2];
                                        Common.getGuiInterface().showAVOffset("" + (int)(d4 / 90.0) + "/" + (int)(d5 / 90.0) + "/" + (int)((d5 - d4) / 90.0));
                                        if (this.Debug) {
                                            System.out.println(" \u00e4" + d4 + "/" + d5 + "/" + (d5 - d4));
                                        }
                                    }
                                }
                                if (n4 < lArray3.length) {
                                    if ((double)Math.abs(lArray3[n4] - l) <= audioFormat.getFrameTimeLength() / 2.0) {
                                        this.WriteEnabled = true;
                                        double d6 = l - lArray3[(n4 += 2) - 2];
                                        d = this.TimeCounter - (double)lArray4[n4 - 2];
                                        Common.getGuiInterface().showAVOffset("" + (int)(d6 / 90.0) + "/" + (int)(d / 90.0) + "/" + (int)((d - d6) / 90.0));
                                        if (this.Debug) {
                                            System.out.println(" \u00fc" + d6 + "/" + d + "/" + (d - d6));
                                        }
                                    }
                                    if (this.WriteEnabled && Math.abs(this.TimeCounter - (double)lArray4[n4 - 2] - (double)(l - lArray3[n4 - 2])) > audioFormat.getFrameTimeLength() / 2.0) {
                                        this.WriteEnabled = false;
                                        n4 -= 2;
                                    }
                                }
                                Common.getGuiInterface().showExportStatus(this.WriteEnabled || !this.ContainsVideoPTS ? Resource.getString("audio.status.pre-insert") : Resource.getString("audio.status.pause"));
                                if (!this.checkLastAudioBound(this.ContainsVideoPTS, l, lArray3, this.FileLength)) break block11;
                                if (this.WriteEnabled) {
                                    this.writeChannel1(byteArrayOutputStream.toByteArray());
                                    if (!bl4 && this.AddWaveHeaderAC3) {
                                        audioFormat.parseRiffData(byArray6, 1);
                                    }
                                    this.FrameExportInfo.countWrittenFrames(1);
                                    this.FrameExportInfo.countPreInsertedFrames(1);
                                    lArray7[1] = lArray7[1] + 1L;
                                    this.TimeCounter += audioFormat.getFrameTimeLength();
                                }
                                l = (long)((double)l + audioFormat.getFrameTimeLength());
                                if (!this.Debug) continue;
                                System.out.println(this.FrameExportInfo.getSummary() + "  @ " + this.formatFrameTime(this.TimeCounter) + "  ");
                            }
                            this.FramePosition = this.CurrentFramePosition;
                            this.unreadInputStream(byArray6, 0, byArray6.length);
                            if (lArray7[1] <= 0L) continue;
                            Common.setMessage(Resource.getString("audio.msg.summary.pre-insert", "" + lArray7[1], this.FramesToTime((int)lArray7[1], audioFormat.getFrameTimeLength())) + " " + this.formatFrameTime(lArray7[0]));
                            continue;
                        }
                        bl2 = false;
                        if (this.ContainsVideoPTS) {
                            nArray2[0] = n4;
                            nArray2[1] = n5;
                            this.WriteEnabled = this.SyncCheck(nArray2, this.TimeCounter, audioFormat.getFrameTimeLength(), this.TimePosition, this.FrameExportInfo.getWrittenFrames(), lArray3, lArray4, this.WriteEnabled, this.Debug);
                            n4 = nArray2[0];
                            n5 = nArray2[1];
                        }
                        Common.getGuiInterface().showExportStatus(this.WriteEnabled || !this.ContainsVideoPTS ? Resource.getString("audio.status.write") : Resource.getString("audio.status.pause"));
                        if (this.Debug) {
                            System.out.println(" k)" + this.TimePosition + " l)" + audioFormat.getFrameTimeLength() / 2.0 + " u)" + audioFormat.getSize() + " m)" + this.WriteEnabled + " FramePosition)" + n5 + " o)" + n4 + " p)" + this.FramePosition);
                        }
                        if (!this.checkLastAudioBound(this.ContainsVideoPTS, this.TimePosition, lArray3, this.FileLength)) break;
                        this.messageSourceFormat(jobProcessing, audioFormat, this.ContainsVideoPTS, this.TimeCounter);
                        if (this.ClearCRC) {
                            audioFormat.removeCRC(byArray6);
                        }
                        if (!bl4 && this.Patch1stAc3Header && this.FrameExportInfo.getWrittenFrames() == 0) {
                            byArray6 = audioFormat.editFrame(byArray6, audioFormat.getSize(), 1);
                        }
                        if (this.Debug) {
                            System.out.println(this.FrameExportInfo.getSummary() + "  @ " + this.formatFrameTime(this.TimeCounter));
                            System.out.println(" x" + (n3 < lArray2.length - 1 ? n3 + "/" + lArray[n3 + 1] + "/" + lArray2[n3 + 1] : "-"));
                        }
                        this.TimePosition = (long)((double)this.TimePosition + audioFormat.getFrameTimeLength());
                        byteArrayOutputStream.reset();
                        byteArrayOutputStream.write(byArray6);
                        if (this.LimitPts && lArray2[n3 + 1] != -1L && lArray2[n3 + 1] < this.FramePosition) {
                            if (this.Debug) {
                                System.out.println(" minSync " + n2 + "/ " + n3);
                            }
                            if (++n2 < 20) {
                                ++n3;
                            } else {
                                n2 = 0;
                            }
                        }
                        if (this.writeSuccessiveFrame(audioFormat, byArray6, byArray2, this.ContainsVideoPTS, this.FramePosition, lArray2, n3, n6)) continue;
                        n2 = 0;
                        if ((double)Math.abs(lArray[n3 + 1] - this.TimePosition) < audioFormat.getFrameTimeLength() / 2.0) {
                            this.TimePosition = lArray[n3 + 1];
                            ++n3;
                            this.writeFrame(audioFormat, byArray6, byArray2, this.ContainsVideoPTS, n6);
                            continue;
                        }
                        if (lArray[n3 + 1] > this.TimePosition) {
                            bl = true;
                        }
                        if (lArray[n3 + 1] < this.TimePosition) {
                            this.TimePosition = lArray[++n3];
                            Common.setMessage(Resource.getString("audio.msg.summary.skip") + " " + this.formatFrameTime(this.TimeCounter));
                            this.FrameExportInfo.countSkippedFrames(1);
                        }
                        if (bl) {
                            this.writeFrame(audioFormat, byArray6, byArray2, this.ContainsVideoPTS, n6);
                            this.TimePosition = (long)((double)this.TimePosition + audioFormat.getFrameTimeLength());
                            if (!bl4 && !this.FillGapsWithLastFrame) {
                                for (n7 = 0; n7 < Common.getAC3list().size(); ++n7) {
                                    byArray9 = (byte[])Common.getAC3list().get(n7);
                                    if ((0xFE & byArray9[4]) != (0xFE & byArray6[4]) || (7 & byArray9[5]) != (7 & byArray6[5]) || (0xE0 & byArray9[6]) != (0xE0 & byArray6[6])) continue;
                                    byteArrayOutputStream.reset();
                                    byteArrayOutputStream.write(byArray9);
                                    break;
                                }
                            }
                            long[] lArray8 = new long[]{(long)this.TimeCounter, 0L};
                            while ((double)lArray[n3 + 1] > (double)this.TimePosition - audioFormat.getFrameTimeLength() / 2.0) {
                                double d;
                                if (this.ContainsVideoPTS && n5 < lArray3.length) {
                                    double d7 = (double)this.TimePosition - audioFormat.getFrameTimeLength() - (double)lArray3[n5 + 1];
                                    d = this.TimeCounter - (double)lArray4[n5 + 1];
                                    if (Math.abs(d) <= audioFormat.getFrameTimeLength() / 2.0) {
                                        this.WriteEnabled = false;
                                        n5 += 2;
                                    } else if (Math.abs(d7) <= audioFormat.getFrameTimeLength() / 2.0) {
                                        this.WriteEnabled = false;
                                        n5 += 2;
                                    }
                                }
                                if (this.ContainsVideoPTS && n4 < lArray3.length && !this.WriteEnabled && Math.abs(this.TimeCounter - (double)lArray4[n4] - ((double)this.TimePosition - audioFormat.getFrameTimeLength() - (double)lArray3[n4])) <= audioFormat.getFrameTimeLength() / 2.0) {
                                    double d8 = (double)this.TimePosition - audioFormat.getFrameTimeLength() - (double)lArray3[n4];
                                    d = this.TimeCounter - (double)lArray4[n4];
                                    Common.getGuiInterface().showAVOffset("" + (int)(d8 / 90.0) + "/" + (int)(d / 90.0) + "/" + (int)((d - d8) / 90.0));
                                    if (this.Debug) {
                                        System.out.println(" \u00a7" + d8 + "/" + d + "/" + (d - d8));
                                    }
                                    this.WriteEnabled = true;
                                    n4 += 2;
                                }
                                if (this.ContainsVideoPTS && n4 < lArray3.length) {
                                    if (Math.abs((double)lArray3[n4] - ((double)this.TimePosition - audioFormat.getFrameTimeLength())) <= audioFormat.getFrameTimeLength() / 2.0) {
                                        double d9 = (double)this.TimePosition - audioFormat.getFrameTimeLength() - (double)lArray3[n4];
                                        d = this.TimeCounter - (double)lArray4[n4];
                                        Common.getGuiInterface().showAVOffset("" + (int)(d9 / 90.0) + "/" + (int)(d / 90.0) + "/" + (int)((d - d9) / 90.0));
                                        if (this.Debug) {
                                            System.out.println(" \u00df" + d9 + "/" + d + "/" + (d - d9));
                                        }
                                        this.WriteEnabled = true;
                                        n4 += 2;
                                    }
                                    if (this.WriteEnabled && Math.abs(this.TimeCounter - (double)lArray4[n4 - 2] - ((double)this.TimePosition - audioFormat.getFrameTimeLength() - (double)lArray3[n4 - 2])) > audioFormat.getFrameTimeLength() / 2.0) {
                                        this.WriteEnabled = false;
                                        n4 -= 2;
                                    }
                                }
                                Common.getGuiInterface().showExportStatus(this.WriteEnabled || !this.ContainsVideoPTS ? Resource.getString("audio.status.insert") : Resource.getString("audio.status.pause"));
                                if (!this.ContainsVideoPTS || this.ContainsVideoPTS && this.WriteEnabled) {
                                    this.writeChannel1(byteArrayOutputStream.toByteArray());
                                    if (!bl4 && this.AddWaveHeaderAC3) {
                                        audioFormat.parseRiffData(byteArrayOutputStream.toByteArray(), 1);
                                    }
                                    this.FrameExportInfo.countWrittenFrames(1);
                                    this.FrameExportInfo.countInsertedFrames(1);
                                    this.TimeCounter += audioFormat.getFrameTimeLength();
                                    lArray8[1] = lArray8[1] + 1L;
                                }
                                if (this.Debug) {
                                    System.out.println(this.FrameExportInfo.getSummary() + "  @ " + this.formatFrameTime(this.TimeCounter) + " ");
                                    System.out.println(" t)" + this.TimePosition);
                                    System.out.println(" x" + (n3 < lArray2.length - 1 ? n3 + "/" + lArray[n3 + 1] + "/" + lArray2[n3 + 1] : "-"));
                                }
                                this.TimePosition = (long)((double)this.TimePosition + audioFormat.getFrameTimeLength());
                            }
                            this.TimePosition = (long)((double)this.TimePosition - audioFormat.getFrameTimeLength());
                            bl = false;
                            ++n3;
                            if (lArray8[1] > 0L) {
                                Common.setMessage(Resource.getString("audio.msg.summary.insert", "" + lArray8[1], this.FramesToTime((int)lArray8[1], audioFormat.getFrameTimeLength())) + " " + this.formatFrameTime(lArray8[0]));
                            }
                            this.TimePosition = lArray[n3];
                            continue;
                        }
                        if (this.CurrentFramePosition + (long)audioFormat.getSize() < this.FileLength) continue;
                    }
                    if ((n6 == 0 || n6 == 6) && this.AddFrames && this.ContainsVideoPTS && this.WriteEnabled && n5 < lArray3.length) {
                        this.TimePosition = (long)((double)this.TimePosition + audioFormat.getFrameTimeLength());
                        lArray5[0] = (long)this.TimeCounter;
                        if (!bl4 && !this.FillGapsWithLastFrame) {
                            for (n7 = 0; n7 < Common.getAC3list().size(); ++n7) {
                                byArray9 = (byte[])Common.getAC3list().get(n7);
                                if ((0xFE & byArray9[4]) != (0xFE & byArray6[4]) || (7 & byArray9[5]) != (7 & byArray6[5]) || (0xE0 & byArray9[6]) != (0xE0 & byArray6[6])) continue;
                                byteArrayOutputStream.reset();
                                byteArrayOutputStream.write(byArray9);
                                break;
                            }
                        }
                        while (n5 < lArray3.length) {
                            while ((double)lArray4[n5 + 1] > this.TimeCounter && Math.abs((double)lArray4[n5 + 1] - this.TimeCounter) > audioFormat.getFrameTimeLength() / 2.0) {
                                this.writeChannel1(byteArrayOutputStream.toByteArray());
                                if (!bl4 && this.AddWaveHeaderAC3) {
                                    audioFormat.parseRiffData(byteArrayOutputStream.toByteArray(), 1);
                                }
                                Common.getGuiInterface().showExportStatus(Resource.getString("audio.status.add"));
                                this.FrameExportInfo.countWrittenFrames(1);
                                this.FrameExportInfo.countAddedFrames(1);
                                this.TimeCounter += audioFormat.getFrameTimeLength();
                                this.TimePosition = (long)((double)this.TimePosition + audioFormat.getFrameTimeLength());
                                lArray5[1] = lArray5[1] + 1L;
                                if (!this.Debug) continue;
                                System.out.println(this.FrameExportInfo.getSummary() + "  @ " + this.formatFrameTime(this.TimeCounter));
                                System.out.print(" t)" + (long)((double)this.TimePosition - audioFormat.getFrameTimeLength()) + " w)" + n5);
                            }
                            n5 += 2;
                        }
                        n5 -= 2;
                        this.TimePosition = (long)((double)this.TimePosition - audioFormat.getFrameTimeLength());
                        if (this.Debug) {
                            System.out.println(" eot_video:" + lArray3[n5 + 1] / 90L + "ms, eot_audio:" + this.TimePosition / 90L + "ms ");
                        }
                    }
                    block21: while (n6 == 2 && this.FramePosition < this.FileLength - 4L) {
                        Common.updateProgressBar(this.FramePosition, this.FileLength);
                        if (this.Debug) {
                            System.out.println(" FramePosition" + this.FramePosition);
                        }
                        while (this.pause()) {
                        }
                        if (!this.isCancelled(jobProcessing)) {
                            CommonParsing.setAudioProcessingFlags(0x3FFFFL & CommonParsing.getAudioProcessingFlags() | (long)this.FrameExportInfo.getWrittenFrames() << 18);
                            if (MpaDecoder.RESET) {
                                return true;
                            }
                            if (!MpaDecoder.PRESCAN && (0xCL & CommonParsing.getAudioProcessingFlags()) != 0L) {
                                return true;
                            }
                            if (lArray2[n3 + 1] != -1L && this.FramePosition > lArray2[n3 + 1]) {
                                Common.setMessage(Resource.getString("audio.msg.pts.wo_frame") + " (" + lArray2[n3 + 1] + "/" + this.FramePosition + ")");
                                ++n3;
                            }
                            this.FramePosition += (long)this.readInputStream(byArray7, 0, 4);
                            this.ERRORCODE = audioFormat.parseHeader(byArray7, 0);
                            if (this.ERRORCODE < 1) {
                                this.unreadInputStream(byArray7, 1, 3);
                                if (this.Message_2 && !bl3) {
                                    Common.setMessage(Resource.getString("audio.msg.syncword.lost", " " + (this.FramePosition - 4L)) + " " + this.formatFrameTime(this.TimeCounter));
                                }
                                bl3 = true;
                                this.FramePosition -= 3L;
                                continue;
                            }
                            this.FramePosition -= (long)this.unreadInputStream(byArray7, 0, 4);
                            byArray6 = new byte[audioFormat.getSize()];
                            this.readInputStream(byArray6, 0, audioFormat.getSize());
                            System.arraycopy(byArray6, 0, byArray, 0, 4);
                            byArray[3] = (byte)(byArray[3] & 0xCF);
                            byArray[2] = (byte)(byArray[2] & 0xFFFFFFFD);
                            this.CurrentFramePosition = this.FramePosition;
                            this.FramePosition += (long)audioFormat.getSize();
                            if (this.PitchAudio && nArray[1] * nArray[0] == this.FrameExportInfo.getWrittenFrames()) {
                                Common.setMessage(Resource.getString("audio.msg.frame.discard") + " " + this.FrameExportInfo.getWrittenFrames() + " (" + nArray[0] + ")");
                                nArray[0] = nArray[0] + 1;
                                continue;
                            }
                            if (this.FillGapsWithLastFrame) {
                                byArray3[0] = new byte[byArray6.length];
                                System.arraycopy(byArray6, 0, byArray3[0], 0, byArray6.length);
                                if (this.ClearCRC) {
                                    audioFormat.removeCRC(byArray3[0]);
                                }
                            }
                            if (this.FramePosition > this.FileLength) break;
                            if (this.FramePosition < this.FileLength - 4L) {
                                if (!this.AllowSpaces) {
                                    this.readInputStream(byArray7, 0, 4);
                                    this.ERRORCODE = audioFormat.parseNextHeader(byArray7, 0);
                                    this.unreadInputStream(byArray7, 0, 4);
                                    if (this.ERRORCODE < 1) {
                                        this.unreadInputStream(byArray6, 1, byArray6.length - 1);
                                        this.FramePosition = this.CurrentFramePosition + 1L;
                                        continue;
                                    }
                                }
                                this.AudioType = audioFormat.getLayer();
                            }
                            if (this.ValidateCRC && (this.ERRORCODE = audioFormat.validateCRC(byArray6, 0, audioFormat.getSize())) != 0) {
                                Common.setMessage(Resource.getString("audio.msg.crc.error", "") + " " + this.CurrentFramePosition);
                                this.unreadInputStream(byArray6, 2, byArray6.length - 2);
                                this.FramePosition = this.CurrentFramePosition + 2L;
                                continue;
                            }
                            if (this.Message_2 && bl3) {
                                Common.setMessage(Resource.getString("audio.msg.syncword.found") + " " + this.CurrentFramePosition);
                            }
                            bl3 = false;
                            this.determineFormatChange(audioFormat, n6);
                            audioFormat.saveHeader();
                            audioFormat.decodeAncillaryData(byArray6);
                            Common.setFps(this.FrameExportInfo.getWrittenFrames());
                            if (this.Debug) {
                                System.out.println(" k)" + this.TimePosition + " l)" + audioFormat.getFrameTimeLength() / 2.0 + " m)" + this.WriteEnabled + " FramePosition)" + n5 + " o)" + n4 + " p)" + this.FramePosition);
                            }
                            if ((!bl2 || !this.ContainsVideoPTS || n4 < lArray3.length) && bl2 && this.ContainsVideoPTS && (double)lArray3[n4] < (double)this.TimePosition - audioFormat.getFrameTimeLength() / 2.0) {
                                byArray4[0] = new byte[audioFormat.getSizeBase()];
                                byArray4[1] = new byte[audioFormat.getSize()];
                                for (n7 = 0; n7 < 2; ++n7) {
                                    System.arraycopy(byArray, 0, byArray4[n7], 0, 4);
                                    byte[] byArray10 = byArray4[n7];
                                    byArray10[1] = (byte)(byArray10[1] | 1);
                                    byte[] byArray11 = byArray4[n7];
                                    byArray11[2] = (byte)(byArray11[2] | n7 * 2);
                                }
                                n7 = 1;
                                long l = lArray3[n4];
                                long[] lArray9 = new long[]{(long)this.TimeCounter, 0L};
                                while ((double)l < (double)this.TimePosition - audioFormat.getFrameTimeLength() / 2.0) {
                                    double d;
                                    if (this.ContainsVideoPTS && n5 < lArray3.length) {
                                        double d10 = l - lArray3[n5 + 1];
                                        d = this.TimeCounter - (double)lArray4[n5 + 1];
                                        if (Math.abs(d) <= audioFormat.getFrameTimeLength() / 2.0) {
                                            this.WriteEnabled = false;
                                            n5 += 2;
                                        } else if (Math.abs(d10) <= audioFormat.getFrameTimeLength() / 2.0) {
                                            this.WriteEnabled = false;
                                            n5 += 2;
                                        }
                                    }
                                    if (this.ContainsVideoPTS && n4 < lArray3.length) {
                                        double d11 = l - lArray3[n4];
                                        d = this.TimeCounter - (double)lArray4[n4];
                                        if (this.Debug) {
                                            System.out.println(" \u00f6" + d11 + "/" + d + "/" + (d - d11));
                                        }
                                        if (!this.WriteEnabled && Math.abs(this.TimeCounter - (double)lArray4[n4] - (double)(l - lArray3[n4])) <= audioFormat.getFrameTimeLength() / 2.0) {
                                            this.WriteEnabled = true;
                                            double d12 = l - lArray3[(n4 += 2) - 2];
                                            double d13 = this.TimeCounter - (double)lArray4[n4 - 2];
                                            Common.getGuiInterface().showAVOffset("" + (int)(d12 / 90.0) + "/" + (int)(d13 / 90.0) + "/" + (int)((d13 - d12) / 90.0));
                                            if (this.Debug) {
                                                System.out.println(" \u00e4" + d12 + "/" + d13 + "/" + (d13 - d12));
                                            }
                                        }
                                    }
                                    if (n4 < lArray3.length) {
                                        if ((double)Math.abs(lArray3[n4] - l) <= audioFormat.getFrameTimeLength() / 2.0) {
                                            this.WriteEnabled = true;
                                            double d14 = l - lArray3[(n4 += 2) - 2];
                                            d = this.TimeCounter - (double)lArray4[n4 - 2];
                                            Common.getGuiInterface().showAVOffset("" + (int)(d14 / 90.0) + "/" + (int)(d / 90.0) + "/" + (int)((d - d14) / 90.0));
                                            if (this.Debug) {
                                                System.out.println(" \u00fc" + d14 + "/" + d + "/" + (d - d14));
                                            }
                                        }
                                        if (this.WriteEnabled && Math.abs(this.TimeCounter - (double)lArray4[n4 - 2] - (double)(l - lArray3[n4 - 2])) > audioFormat.getFrameTimeLength() / 2.0) {
                                            this.WriteEnabled = false;
                                            n4 -= 2;
                                        }
                                    }
                                    Common.getGuiInterface().showExportStatus(this.WriteEnabled || !this.ContainsVideoPTS ? Resource.getString("audio.status.pre-insert") : Resource.getString("audio.status.pause"));
                                    if (!this.checkLastAudioBound(this.ContainsVideoPTS, l, lArray3, this.FileLength)) break block21;
                                    if (this.WriteEnabled) {
                                        if (this.FillGapsWithLastFrame) {
                                            if (audioFormat.getLayer() > 0 && this.DecodeMpgAudio) {
                                                this.writeChannels(MpaDecoder.decodeArray(byArray3[0]), MpaDecoder.get2ndArray());
                                            } else if (this.MpaConversionMode > 0) {
                                                byArray2 = this.MPAConverter.modifyframe(byArray3[0], this.MpaConversionMode);
                                                this.writeChannels(byArray2);
                                                audioFormat.parseRiffData(byArray2[0], 1);
                                                if (this.MpaConversionMode >= 4) {
                                                    audioFormat.parseRiffData(byArray2[1], 2);
                                                }
                                            } else {
                                                this.writeChannel1(byArray3[0]);
                                                audioFormat.parseRiffData(byArray3[0], 1);
                                            }
                                        } else if (audioFormat.getLayer() > 0 && this.DecodeMpgAudio) {
                                            this.writeChannels(MpaDecoder.decodeArray(byArray4[n7 > 0 ? 0 : 1]), MpaDecoder.get2ndArray());
                                        } else if (this.MpaConversionMode > 0) {
                                            byArray2 = this.MPAConverter.modifyframe(byArray4[n7 > 0 ? 0 : 1], this.MpaConversionMode);
                                            this.writeChannels(byArray2);
                                            audioFormat.parseRiffData(byArray2[0], 1);
                                            if (this.MpaConversionMode >= 4) {
                                                audioFormat.parseRiffData(byArray2[1], 2);
                                            }
                                        } else {
                                            this.writeChannel1(byArray4[n7 > 0 ? 0 : 1]);
                                            audioFormat.parseRiffData(byArray4[n7 > 0 ? 0 : 1], 1);
                                        }
                                        this.FrameExportInfo.countWrittenFrames(1);
                                        this.FrameExportInfo.countPreInsertedFrames(1);
                                        this.TimeCounter += audioFormat.getFrameTimeLength();
                                        lArray9[1] = lArray9[1] + 1L;
                                    }
                                    l = (long)((double)l + audioFormat.getFrameTimeLength());
                                    if (!this.Debug) continue;
                                    System.out.println(this.FrameExportInfo.getSummary() + "  @ " + this.formatFrameTime(this.TimeCounter));
                                }
                                this.FramePosition = this.CurrentFramePosition;
                                this.unreadInputStream(byArray6, 0, byArray6.length);
                                if (lArray9[1] <= 0L) continue;
                                Common.setMessage(Resource.getString("audio.msg.summary.pre-insert", "" + lArray9[1], this.FramesToTime((int)lArray9[1], audioFormat.getFrameTimeLength())) + " " + this.formatFrameTime(lArray9[0]));
                                continue;
                            }
                            bl2 = false;
                            if (this.ContainsVideoPTS) {
                                nArray2[0] = n4;
                                nArray2[1] = n5;
                                this.WriteEnabled = this.SyncCheck(nArray2, this.TimeCounter, audioFormat.getFrameTimeLength(), this.TimePosition, this.FrameExportInfo.getWrittenFrames(), lArray3, lArray4, this.WriteEnabled, this.Debug);
                                n4 = nArray2[0];
                                n5 = nArray2[1];
                            }
                            Common.getGuiInterface().showExportStatus(this.WriteEnabled || !this.ContainsVideoPTS ? Resource.getString("audio.status.write") : Resource.getString("audio.status.pause"));
                            if (!this.checkLastAudioBound(this.ContainsVideoPTS, this.TimePosition, lArray3, this.FileLength)) break;
                            this.messageSourceFormat(jobProcessing, audioFormat, this.ContainsVideoPTS, this.TimeCounter);
                            this.TimePosition = (long)((double)this.TimePosition + audioFormat.getFrameTimeLength());
                            if (this.Debug) {
                                System.out.println(this.FrameExportInfo.getSummary() + "  @ " + this.formatFrameTime(this.TimeCounter));
                                System.out.println("ntl: " + this.TimePosition + " x" + (n3 < lArray2.length - 1 ? n3 + "/" + lArray[n3 + 1] + "/" + lArray2[n3 + 1] : "-"));
                            }
                            if (this.ClearCRC) {
                                audioFormat.removeCRC(byArray6);
                            }
                            System.arraycopy(byArray6, 0, byArray, 0, 4);
                            byArray[3] = (byte)(byArray[3] & 0xCF);
                            byArray[2] = (byte)(byArray[2] & 0xFFFFFFFD);
                            if (this.LimitPts && lArray2[n3 + 1] != -1L && lArray2[n3 + 1] < this.FramePosition) {
                                if (this.Debug) {
                                    System.out.println(" minSync " + n2 + "/ " + n3);
                                }
                                if (++n2 < 20) {
                                    ++n3;
                                } else {
                                    n2 = 0;
                                }
                            }
                            if (this.writeSuccessiveFrame(audioFormat, byArray6, byArray2, this.ContainsVideoPTS, this.FramePosition, lArray2, n3, n6)) continue;
                            n2 = 0;
                            if ((double)Math.abs(lArray[n3 + 1] - this.TimePosition) < audioFormat.getFrameTimeLength() / 2.0) {
                                this.TimePosition = lArray[n3 + 1];
                                ++n3;
                                this.writeFrame(audioFormat, byArray6, byArray2, this.ContainsVideoPTS, n6);
                                continue;
                            }
                            if (lArray[n3 + 1] > this.TimePosition) {
                                bl = true;
                            }
                            if (lArray[n3 + 1] < this.TimePosition) {
                                this.TimePosition = lArray[++n3];
                                Common.setMessage(Resource.getString("audio.msg.summary.skip") + " " + this.formatFrameTime(this.TimeCounter));
                                this.FrameExportInfo.countSkippedFrames(1);
                            }
                            if (bl) {
                                byArray4[0] = new byte[audioFormat.getSizeBase()];
                                byArray4[1] = new byte[audioFormat.getSize()];
                                for (n7 = 0; n7 < 2; ++n7) {
                                    System.arraycopy(byArray, 0, byArray4[n7], 0, 4);
                                    byte[] byArray12 = byArray4[n7];
                                    byArray12[1] = (byte)(byArray12[1] | 1);
                                    byte[] byArray13 = byArray4[n7];
                                    byArray13[2] = (byte)(byArray13[2] | n7 * 2);
                                }
                                n7 = 1;
                                long[] lArray10 = new long[]{(long)this.TimeCounter, 0L};
                                while ((double)lArray[n3 + 1] > (double)this.TimePosition - audioFormat.getFrameTimeLength() / 2.0) {
                                    if (this.ContainsVideoPTS && n5 < lArray3.length) {
                                        double d = (double)this.TimePosition - audioFormat.getFrameTimeLength() - (double)lArray3[n5 + 1];
                                        double d15 = this.TimeCounter - (double)lArray4[n5 + 1];
                                        if (Math.abs(d15) <= audioFormat.getFrameTimeLength() / 2.0) {
                                            this.WriteEnabled = false;
                                            n5 += 2;
                                        } else if (Math.abs(d) <= audioFormat.getFrameTimeLength() / 2.0) {
                                            this.WriteEnabled = false;
                                            n5 += 2;
                                        }
                                    }
                                    if (this.ContainsVideoPTS && n4 < lArray3.length && !this.WriteEnabled && Math.abs(this.TimeCounter - (double)lArray4[n4] - ((double)this.TimePosition - audioFormat.getFrameTimeLength() - (double)lArray3[n4])) <= audioFormat.getFrameTimeLength() / 2.0) {
                                        double d = (double)this.TimePosition - audioFormat.getFrameTimeLength() - (double)lArray3[n4];
                                        double d16 = this.TimeCounter - (double)lArray4[n4];
                                        Common.getGuiInterface().showAVOffset("" + (int)(d / 90.0) + "/" + (int)(d16 / 90.0) + "/" + (int)((d16 - d) / 90.0));
                                        if (this.Debug) {
                                            System.out.println(" \u00a7" + d + "/" + d16 + "/" + (d16 - d));
                                        }
                                        this.WriteEnabled = true;
                                        n4 += 2;
                                    }
                                    if (this.ContainsVideoPTS && n4 < lArray3.length) {
                                        if (Math.abs((double)lArray3[n4] - ((double)this.TimePosition - audioFormat.getFrameTimeLength())) <= audioFormat.getFrameTimeLength() / 2.0) {
                                            double d = (double)this.TimePosition - audioFormat.getFrameTimeLength() - (double)lArray3[n4];
                                            double d17 = this.TimeCounter - (double)lArray4[n4];
                                            Common.getGuiInterface().showAVOffset("" + (int)(d / 90.0) + "/" + (int)(d17 / 90.0) + "/" + (int)((d17 - d) / 90.0));
                                            if (this.Debug) {
                                                System.out.println(" \u00df" + d + "/" + d17 + "/" + (d17 - d));
                                            }
                                            this.WriteEnabled = true;
                                            n4 += 2;
                                        }
                                        if (this.WriteEnabled && Math.abs(this.TimeCounter - (double)lArray4[n4 - 2] - ((double)this.TimePosition - audioFormat.getFrameTimeLength() - (double)lArray3[n4 - 2])) > audioFormat.getFrameTimeLength() / 2.0) {
                                            this.WriteEnabled = false;
                                            n4 -= 2;
                                        }
                                    }
                                    Common.getGuiInterface().showExportStatus(this.WriteEnabled || !this.ContainsVideoPTS ? Resource.getString("audio.status.insert") : Resource.getString("audio.status.pause"));
                                    if (!this.ContainsVideoPTS || this.ContainsVideoPTS && this.WriteEnabled) {
                                        if (this.FillGapsWithLastFrame) {
                                            if (audioFormat.getLayer() > 0 && this.DecodeMpgAudio) {
                                                this.writeChannels(MpaDecoder.decodeArray(byArray3[0]), MpaDecoder.get2ndArray());
                                            } else if (this.MpaConversionMode != 0) {
                                                byArray2 = this.MPAConverter.modifyframe(byArray3[0], this.MpaConversionMode);
                                                this.writeChannels(byArray2);
                                                audioFormat.parseRiffData(byArray2[0], 1);
                                                if (this.MpaConversionMode >= 4) {
                                                    audioFormat.parseRiffData(byArray2[1], 2);
                                                }
                                            } else {
                                                this.writeChannel1(byArray3[0]);
                                                audioFormat.parseRiffData(byArray3[0], 1);
                                            }
                                        } else if (audioFormat.getLayer() > 0 && this.DecodeMpgAudio) {
                                            this.writeChannels(MpaDecoder.decodeArray(byArray4[n7 > 0 ? 0 : 1]), MpaDecoder.get2ndArray());
                                        } else if (this.MpaConversionMode != 0) {
                                            byArray2 = this.MPAConverter.modifyframe(byArray4[n7 > 0 ? 0 : 1], this.MpaConversionMode);
                                            this.writeChannels(byArray2);
                                            audioFormat.parseRiffData(byArray2[0], 1);
                                            if (this.MpaConversionMode >= 4) {
                                                audioFormat.parseRiffData(byArray2[1], 2);
                                            }
                                        } else {
                                            this.writeChannel1(byArray4[n7 > 0 ? 0 : 1]);
                                            audioFormat.parseRiffData(byArray4[n7 > 0 ? 0 : 1], 1);
                                        }
                                        this.FrameExportInfo.countWrittenFrames(1);
                                        this.FrameExportInfo.countInsertedFrames(1);
                                        this.TimeCounter += audioFormat.getFrameTimeLength();
                                        lArray10[1] = lArray10[1] + 1L;
                                    }
                                    if (this.Debug) {
                                        System.out.println(this.FrameExportInfo.getSummary() + "  @ " + this.formatFrameTime(this.TimeCounter));
                                        System.out.println("tl: " + this.TimePosition + " x" + (n3 < lArray2.length - 1 ? n3 + "/" + lArray[n3 + 1] + "/" + lArray2[n3 + 1] : "-"));
                                    }
                                    this.TimePosition = (long)((double)this.TimePosition + audioFormat.getFrameTimeLength());
                                }
                                this.TimePosition = (long)((double)this.TimePosition - audioFormat.getFrameTimeLength());
                                bl = false;
                                ++n3;
                                if (lArray10[1] > 0L) {
                                    Common.setMessage(Resource.getString("audio.msg.summary.insert", "" + lArray10[1], this.FramesToTime((int)lArray10[1], audioFormat.getFrameTimeLength())) + " " + this.formatFrameTime(lArray10[0]));
                                }
                                this.TimePosition = lArray[n3];
                                continue;
                            }
                            if (this.CurrentFramePosition + (long)audioFormat.getSize() < this.FileLength) continue;
                        }
                        break block253;
                    }
                    if (this.Debug) {
                        System.out.println(this.FrameExportInfo.getSummary() + "  @ " + this.formatFrameTime(this.TimeCounter));
                    }
                    if (n6 == 2 && this.AddFrames && this.ContainsVideoPTS && this.WriteEnabled && n5 < lArray3.length) {
                        this.TimePosition = (long)((double)this.TimePosition + audioFormat.getFrameTimeLength());
                        lArray5[0] = (long)this.TimeCounter;
                        byArray4[0] = new byte[audioFormat.getSizeBase()];
                        byArray4[1] = new byte[audioFormat.getSize()];
                        for (n7 = 0; n7 < 2; ++n7) {
                            System.arraycopy(byArray, 0, byArray4[n7], 0, 4);
                            byte[] byArray14 = byArray4[n7];
                            byArray14[1] = (byte)(byArray14[1] | 1);
                            byte[] byArray15 = byArray4[n7];
                            byArray15[2] = (byte)(byArray15[2] | n7 * 2);
                        }
                        n7 = 1;
                        while (n5 < lArray3.length) {
                            while ((double)lArray4[n5 + 1] > this.TimeCounter && Math.abs((double)lArray4[n5 + 1] - this.TimeCounter) > audioFormat.getFrameTimeLength() / 2.0) {
                                if (this.FillGapsWithLastFrame) {
                                    if (audioFormat.getLayer() > 0 && this.DecodeMpgAudio) {
                                        this.writeChannels(MpaDecoder.decodeArray(byArray3[0]), MpaDecoder.get2ndArray());
                                    } else if (this.MpaConversionMode != 0) {
                                        byArray2 = this.MPAConverter.modifyframe(byArray3[0], this.MpaConversionMode);
                                        this.writeChannels(byArray2);
                                        audioFormat.parseRiffData(byArray2[0], 1);
                                        if (this.MpaConversionMode >= 4) {
                                            audioFormat.parseRiffData(byArray2[1], 2);
                                        }
                                    } else {
                                        this.writeChannel1(byArray3[0]);
                                        audioFormat.parseRiffData(byArray3[0], 1);
                                    }
                                } else if (audioFormat.getLayer() > 0 && this.DecodeMpgAudio) {
                                    this.writeChannels(MpaDecoder.decodeArray(byArray4[n7 > 0 ? 0 : 1]), MpaDecoder.get2ndArray());
                                } else if (this.MpaConversionMode != 0) {
                                    byArray2 = this.MPAConverter.modifyframe(byArray4[n7 > 0 ? 0 : 1], this.MpaConversionMode);
                                    this.writeChannels(byArray2);
                                    audioFormat.parseRiffData(byArray2[0], 1);
                                    if (this.MpaConversionMode >= 4) {
                                        audioFormat.parseRiffData(byArray2[1], 2);
                                    }
                                } else {
                                    this.writeChannel1(byArray4[n7 > 0 ? 0 : 1]);
                                    audioFormat.parseRiffData(byArray4[n7 > 0 ? 0 : 1], 1);
                                }
                                this.FrameExportInfo.countWrittenFrames(1);
                                this.FrameExportInfo.countAddedFrames(1);
                                this.TimePosition = (long)((double)this.TimePosition + audioFormat.getFrameTimeLength());
                                lArray5[1] = lArray5[1] + 1L;
                                this.TimeCounter += audioFormat.getFrameTimeLength();
                                Common.getGuiInterface().showExportStatus(Resource.getString("audio.status.add"));
                                if (!this.Debug) continue;
                                System.out.println(this.FrameExportInfo.getSummary() + "  @ " + this.formatFrameTime(this.TimeCounter));
                                System.out.print(" t)" + (long)((double)this.TimePosition - audioFormat.getFrameTimeLength()) + " w)" + n5);
                            }
                            n5 += 2;
                        }
                        n5 -= 2;
                        this.TimePosition = (long)((double)this.TimePosition - audioFormat.getFrameTimeLength());
                        if (this.Debug) {
                            System.out.println(" eot_video:" + lArray3[n5 + 1] / 90L + "ms, eot_audio:" + this.TimePosition / 90L + "ms  ");
                        }
                    }
                    if (n6 == 2 && this.DecodeMpgAudio && MpaDecoder.PRESCAN && !MpaDecoder.RESET) {
                        MpaDecoder.PRESCAN = false;
                        MpaDecoder.NORMALIZE = false;
                        return true;
                    }
                }
            }
            if (lArray5[1] > 0L) {
                Common.setMessage(Resource.getString("audio.msg.summary.add", "" + lArray5[1], this.FramesToTime((int)lArray5[1], audioFormat.getFrameTimeLength())) + " " + this.formatFrameTime(lArray5[0]));
            }
            Common.getGuiInterface().showExportStatus(Resource.getString("audio.status.finish"));
            String string6 = this.formatFrameTime(this.TimeCounter);
            Common.setMessage(Resource.getString("audio.msg.summary.frames", "" + this.FrameExportInfo.getWrittenFrames() + "-" + this.FrameExportInfo.getShortSummary(), "" + string6));
            if (this.ModeChangeCount_JSS > 0L) {
                Common.setMessage(Resource.getString("audio.msg.summary.jstereo", String.valueOf(this.ModeChangeCount_JSS)));
            }
            this.closeInputStream();
            byteArrayOutputStream.close();
            this.closeOutputStreams();
            String[][] stringArrayArray = new String[][]{{".ac3", ".mp1", ".mp2", ".mp3", ".dts"}, {".new.ac3", ".new.mp1", ".new.mp2", ".new.mp3", ".new.dts"}};
            if (jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_renameAudio)) {
                for (int i = 1; i < 4; ++i) {
                    stringArrayArray[0][i] = ".mpa";
                    stringArrayArray[1][i] = ".new.mpa";
                }
            }
            if (this.DecodeMpgAudio && audioFormat.getLayer() > 1) {
                if (MpaDecoder.WAVE) {
                    int n9 = 1;
                    while (n9 < 4) {
                        String[] stringArray = stringArrayArray[0];
                        int n10 = n9;
                        stringArray[n10] = stringArray[n10] + ".wav";
                        String[] stringArray2 = stringArrayArray[1];
                        int n11 = n9++;
                        stringArray2[n11] = stringArray2[n11] + ".wav";
                    }
                } else if (this.AddAiffHeader) {
                    int n12 = 1;
                    while (n12 < 4) {
                        String[] stringArray = stringArrayArray[0];
                        int n13 = n12;
                        stringArray[n13] = stringArray[n13] + ".aif";
                        String[] stringArray3 = stringArrayArray[1];
                        int n14 = n12++;
                        stringArray3[n14] = stringArray3[n14] + ".aif";
                    }
                } else {
                    int n15 = 1;
                    while (n15 < 4) {
                        String[] stringArray = stringArrayArray[0];
                        int n16 = n15;
                        stringArray[n16] = stringArray[n16] + ".pcm";
                        String[] stringArray4 = stringArrayArray[1];
                        int n17 = n15++;
                        stringArray4[n17] = stringArray4[n17] + ".pcm";
                    }
                }
            } else if (this.AddWaveHeaderBWF || this.AddWaveHeaderACM) {
                int n18 = 1;
                while (n18 < 4) {
                    String[] stringArray = stringArrayArray[0];
                    int n19 = n18;
                    stringArray[n19] = stringArray[n19] + ".wav";
                    String[] stringArray5 = stringArrayArray[1];
                    int n20 = n18++;
                    stringArray5[n20] = stringArray5[n20] + ".wav";
                }
            }
            if (this.AddWaveHeaderAC3) {
                String[] stringArray = stringArrayArray[0];
                stringArray[0] = stringArray[0] + ".wav";
                String[] stringArray6 = stringArrayArray[1];
                stringArray6[0] = stringArray6[0] + ".wav";
            } else if (this.CreateDDWave) {
                String[] stringArray = stringArrayArray[0];
                stringArray[0] = stringArray[0] + ".wav";
                String[] stringArray7 = stringArrayArray[1];
                stringArray7[0] = stringArray7[0] + ".wav";
                String[] stringArray8 = stringArrayArray[0];
                stringArray8[4] = stringArray8[4] + ".wav";
                String[] stringArray9 = stringArrayArray[1];
                stringArray9[4] = stringArray9[4] + ".wav";
            }
            File file = new File(string5 + stringArrayArray[n][0]);
            File file2 = new File(string5 + stringArrayArray[n][1]);
            object = new File(string5 + stringArrayArray[n][2]);
            File file3 = new File(string5 + stringArrayArray[n][3]);
            File file4 = new File(string5 + "[L]" + stringArrayArray[0][2]);
            File file5 = new File(string5 + "[R]" + stringArrayArray[0][2]);
            File file6 = new File(string5 + stringArrayArray[n][4]);
            File file7 = new File(string5 + ".new.wav");
            this.fillWaveHeader(audioFormat, n6);
            File file8 = new File(this.FileName_Ch1);
            File file9 = new File(this.FileName_Ch2);
            jobProcessing.countMediaFilesExportLength(file8.length());
            jobProcessing.countMediaFilesExportLength(file9.length());
            String[] stringArray = new String[]{"(ac3)", "(mp3)", "(mp2)", "(mp1)", "(dts)", "(pcm)"};
            if (this.DecodeMpgAudio) {
                stringArray[2] = "(pcm)";
                stringArray[1] = "(pcm)";
            }
            String string7 = "";
            if (this.AudioType < 0) {
                this.AudioType = 10;
            } else {
                string7 = Resource.getString("audio.msg.audio") + " " + jobProcessing.countAudioStream() + " " + stringArray[this.AudioType] + ":\t" + this.FrameExportInfo.getWrittenFrames() + " Frames\t" + string6 + "\t" + this.infoPTSMatch(string, string3, this.ContainsVideoPTS, this.ContainsAudioPTS) + this.FrameExportInfo.getShortSummary();
            }
            switch (this.AudioType) {
                case 0: {
                    if (file.exists()) {
                        file.delete();
                    }
                    if (file8.length() < 100L) {
                        file8.delete();
                    } else {
                        Common.renameTo(file8, file);
                        Common.setMessage(Resource.getString("msg.newfile", "") + " '" + file + "'");
                        jobProcessing.addSummaryInfo(string7 + "\t'" + file + "'");
                    }
                    if (file9.length() < 100L) {
                        file9.delete();
                    }
                    this.OutputStream_Ch1.renameIddTo(file);
                    this.OutputStream_Ch2.deleteIdd();
                    break;
                }
                case 1: {
                    if (file3.exists()) {
                        file3.delete();
                    }
                    if (file8.length() < 100L) {
                        file8.delete();
                    } else {
                        Common.renameTo(file8, file3);
                        Common.setMessage(Resource.getString("msg.newfile", "") + " '" + file3 + "'");
                        jobProcessing.addSummaryInfo(string7 + "\t'" + file3 + "'");
                    }
                    if (file9.length() < 100L) {
                        file9.delete();
                    }
                    this.OutputStream_Ch1.renameIddTo(file3);
                    this.OutputStream_Ch2.deleteIdd();
                    break;
                }
                case 2: {
                    if (this.MpaConversionMode >= 4) {
                        if (file4.exists()) {
                            file4.delete();
                        }
                        if (file5.exists()) {
                            file5.delete();
                        }
                        if (file9.length() < 100L) {
                            file9.delete();
                        } else {
                            Common.renameTo(file9, file5);
                            Common.setMessage(Resource.getString("msg.newfile", Resource.getString("audio.msg.newfile.right")) + " '" + file5 + "'");
                            jobProcessing.addSummaryInfo(string7 + "\t'" + file5 + "'");
                        }
                        if (file8.length() < 100L) {
                            file8.delete();
                        } else {
                            Common.renameTo(file8, file4);
                            Common.setMessage(Resource.getString("msg.newfile", Resource.getString("audio.msg.newfile.left")) + " '" + file4 + "'");
                            jobProcessing.addSummaryInfo(string7 + "\t'" + file4 + "'");
                        }
                        this.OutputStream_Ch1.renameIddTo(file4);
                        this.OutputStream_Ch2.renameIddTo(file5);
                        break;
                    }
                    if (((File)object).exists()) {
                        ((File)object).delete();
                    }
                    if (file8.length() < 100L) {
                        file8.delete();
                    } else {
                        Common.renameTo(file8, (File)object);
                        Common.setMessage(Resource.getString("msg.newfile", "") + " '" + object + "'");
                        jobProcessing.addSummaryInfo(string7 + "\t'" + object + "'");
                    }
                    if (file9.length() < 100L) {
                        file9.delete();
                    }
                    this.OutputStream_Ch1.renameIddTo((File)object);
                    this.OutputStream_Ch2.deleteIdd();
                    break;
                }
                case 3: {
                    if (file2.exists()) {
                        file2.delete();
                    }
                    if (file8.length() < 100L) {
                        file8.delete();
                    } else {
                        Common.renameTo(file8, file2);
                        Common.setMessage(Resource.getString("msg.newfile", "") + " '" + file2 + "'");
                        jobProcessing.addSummaryInfo(string7 + "\t'" + file2 + "'");
                    }
                    if (file9.length() < 100L) {
                        file9.delete();
                    }
                    this.OutputStream_Ch1.renameIddTo(file2);
                    this.OutputStream_Ch2.deleteIdd();
                    break;
                }
                case 4: {
                    if (file6.exists()) {
                        file6.delete();
                    }
                    if (file8.length() < 100L) {
                        file8.delete();
                    } else {
                        Common.renameTo(file8, file6);
                        Common.setMessage(Resource.getString("msg.newfile", "") + " '" + file6 + "'");
                        jobProcessing.addSummaryInfo(string7 + "\t'" + file6 + "'");
                    }
                    if (file9.length() < 100L) {
                        file9.delete();
                    }
                    this.OutputStream_Ch1.renameIddTo(file6);
                    this.OutputStream_Ch2.deleteIdd();
                    break;
                }
                case 5: {
                    if (file7.exists()) {
                        file7.delete();
                    }
                    if (file8.length() < 100L) {
                        file8.delete();
                    } else {
                        Common.renameTo(file8, file7);
                        Common.setMessage(Resource.getString("msg.newfile", "") + " '" + file7 + "'");
                        jobProcessing.addSummaryInfo(string7 + "\t'" + file7 + "'");
                    }
                    if (file9.length() < 100L) {
                        file9.delete();
                    }
                    this.OutputStream_Ch1.renameIddTo(file7);
                    this.OutputStream_Ch2.deleteIdd();
                    break;
                }
                case 10: {
                    Common.setMessage(Resource.getString("audio.msg.noaudio"));
                    file8.delete();
                    file9.delete();
                    this.OutputStream_Ch1.deleteIdd();
                    this.OutputStream_Ch2.deleteIdd();
                }
            }
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        Common.updateProgressBar(this.FileLength, this.FileLength);
        return false;
    }

    private void messageSourceFormat(JobProcessing jobProcessing, AudioFormat audioFormat, boolean bl, double d) {
        if (!this.HasNewFormat || bl && !this.WriteEnabled) {
            return;
        }
        String string = audioFormat.displayHeader();
        if (this.ModeChangeCount < 100L) {
            String string2 = this.formatFrameTime(d);
            Common.setMessage(Resource.getString("audio.msg.source", string) + " " + string2);
            if (this.CreateChapters) {
                jobProcessing.getChapters().addChapter(string2, string);
            }
        } else if (this.Debug) {
            System.out.println("=> src_audio: " + string + " @ " + this.formatFrameTime(d));
        }
        if (this.ModeChangeCount == 100L) {
            Common.setMessage(Resource.getString("audio.msg.source.max"));
        }
        ++this.ModeChangeCount;
        this.HasNewFormat = false;
    }

    private String formatFrameTime(double d) {
        return Common.formatTime_1((long)(d / 90.0));
    }

    private String formatFrameTime(long l) {
        return Common.formatTime_1(l / 90L);
    }

    private boolean checkLastAudioBound(boolean bl, long l, long[] lArray, long l2) {
        boolean bl2 = true;
        if (!bl) {
            return bl2;
        }
        if (l > lArray[lArray.length - 1] + 10000L) {
            Common.updateProgressBar(l2, l2);
            return !bl2;
        }
        return bl2;
    }

    private boolean writeSuccessiveFrame(AudioFormat audioFormat, byte[] byArray, byte[][] byArray2, boolean bl, long l, long[] lArray, int n, int n2) {
        boolean bl2 = true;
        if (lArray[n + 1] != -1L && lArray[n + 1] <= l) {
            return !bl2;
        }
        this.writeFrame(audioFormat, byArray, byArray2, bl, n2);
        return bl2;
    }

    private boolean writeFrame(AudioFormat audioFormat, byte[] byArray, byte[][] byArray2, boolean bl, int n) {
        if (bl && !this.WriteEnabled) {
            return false;
        }
        switch (n) {
            case 6: {
                this.writeChannel1(byArray);
                break;
            }
            case 0: {
                if (this.AddWaveHeaderAC3) {
                    audioFormat.parseRiffData(byArray, 1);
                }
                this.writeChannel1(byArray);
                break;
            }
            case 2: {
                if (audioFormat.getLayer() > 0 && this.DecodeMpgAudio) {
                    this.writeChannel1(MpaDecoder.decodeArray(byArray));
                    if (this.MpaConversionMode < 4) break;
                    this.writeChannel2(MpaDecoder.get2ndArray());
                    break;
                }
                if (this.MpaConversionMode != 0) {
                    byArray2 = this.MPAConverter.modifyframe(byArray, this.MpaConversionMode);
                    this.writeChannel1(byArray2[0]);
                    if (this.MpaConversionMode >= 4) {
                        this.writeChannel2(byArray2[1]);
                    }
                    audioFormat.parseRiffData(byArray2[0], 1);
                    if (this.MpaConversionMode < 4) break;
                    audioFormat.parseRiffData(byArray2[1], 2);
                    break;
                }
                this.writeChannel1(byArray);
                audioFormat.parseRiffData(byArray, 1);
            }
        }
        this.FrameExportInfo.countWrittenFrames(1);
        this.TimeCounter += audioFormat.getFrameTimeLength();
        return true;
    }

    private void initOutputStreams() {
        try {
            this.OutputStream_Ch1 = new IDDBufferedOutputStream(new FileOutputStream(this.FileName_Ch1), 2048000);
            this.OutputStream_Ch2 = new IDDBufferedOutputStream(new FileOutputStream(this.FileName_Ch2), this.MpaConversionMode >= 4 ? 2048000 : 65536);
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void closeOutputStreams() {
        try {
            this.OutputStream_Ch1.flush();
            this.OutputStream_Ch1.close();
            this.OutputStream_Ch2.flush();
            this.OutputStream_Ch2.close();
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void writeChannel1(byte[] byArray) {
        this.writeChannel(byArray, 1);
    }

    private void writeChannel2(byte[] byArray) {
        this.writeChannel(byArray, 2);
    }

    private void writeChannels(byte[] byArray) {
        this.writeChannels(byArray, byArray);
    }

    private void writeChannels(byte[][] byArray) {
        this.writeChannels(byArray[0], byArray[1]);
    }

    private void writeChannels(byte[] byArray, byte[] byArray2) {
        this.writeChannel(byArray, 1);
        if (this.MpaConversionMode >= 4) {
            this.writeChannel(byArray2, 2);
        }
    }

    private void writeChannel(byte[] byArray, int n) {
        try {
            if (n == 1) {
                this.OutputStream_Ch1.write(byArray);
            } else if (n == 2) {
                this.OutputStream_Ch2.write(byArray);
            }
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void initInputStream(XInputFile xInputFile) {
        try {
            this.InputStream = new PushbackInputStream(xInputFile.getInputStream(), 1000000);
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void closeInputStream() {
        try {
            this.InputStream.close();
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private int readInputStream(byte[] byArray) {
        return this.readInputStream(byArray, 0, byArray.length);
    }

    private int readInputStream(byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            n3 = this.InputStream.read(byArray, n, n2);
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
        return n3;
    }

    private int unreadInputStream(byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            this.InputStream.unread(byArray, n, n2);
            n3 = n2;
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
        return n3;
    }

    private long skipInputStream(long l) {
        long l2 = 0L;
        try {
            l2 = this.InputStream.skip(l);
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
        return l2;
    }

    private boolean isCancelled(JobProcessing jobProcessing) {
        if (!CommonParsing.isProcessCancelled()) {
            return false;
        }
        CommonParsing.setProcessCancelled(false);
        jobProcessing.setSplitSize(0L);
        return true;
    }

    private byte[] getReplacementFrame(AudioFormat audioFormat, byte[] byArray, int n) {
        if (n != 0 || !this.ReplaceAc3withSilence) {
            return byArray;
        }
        if (audioFormat.getMode() == 7) {
            return byArray;
        }
        AudioFormat audioFormat2 = new AudioFormat(0);
        int n2 = Common.getAC3list().size();
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = (byte[])Common.getAC3list().get(i);
            audioFormat2.parseHeader(byArray2, 0);
            if (audioFormat2.getMode() != 7 || audioFormat2.getSamplingFrequency() != audioFormat.getSamplingFrequency()) continue;
            byArray = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
            break;
        }
        return byArray;
    }

    private void determineFormatChange(AudioFormat audioFormat, int n) {
        int n2 = audioFormat.compareHeader();
        if (n2 > 0) {
            this.HasNewFormat = true;
            if (n == 2 && n2 == 6) {
                ++this.ModeChangeCount_JSS;
                this.HasNewFormat = false;
            }
        }
        if (this.FrameExportInfo.getWrittenFrames() == 0) {
            this.HasNewFormat = true;
        }
    }

    private void addWaveHeader(AudioFormat audioFormat, int n) {
        if (n == 2) {
            this.writeChannel1(audioFormat.getExtraWaveHeader(1, true));
            if (this.MpaConversionMode >= 4) {
                this.writeChannel2(audioFormat.getExtraWaveHeader(2, true));
            }
        } else if (this.AddWaveHeaderAC3 && n == 0) {
            this.writeChannel1(audioFormat.getExtraWaveHeader(1, true));
            Common.setMessage(Resource.getString("audio.msg.addriff.ac3"));
        } else if (this.CreateDDWave && n == 0) {
            this.writeChannel1(audioFormat.getRiffHeader());
        } else if (this.CreateDDWave && n == 6) {
            this.writeChannel1(audioFormat.getRiffHeader());
        }
    }

    private void fillWaveHeader(AudioFormat audioFormat, int n) {
        try {
            if (this.DecodeMpgAudio && n == 2 && MpaDecoder.WAVE) {
                if (audioFormat.getLayer() > 1) {
                    MpaDecoder.fillRIFF(this.FileName_Ch1, this.FadeInOut, this.FadeInOutMillis);
                    if (this.MpaConversionMode >= 4) {
                        MpaDecoder.fillRIFF(this.FileName_Ch2, this.FadeInOut, this.FadeInOutMillis);
                    }
                } else {
                    MpaDecoder.deleteRIFF(this.FileName_Ch1);
                    if (this.MpaConversionMode >= 4) {
                        MpaDecoder.deleteRIFF(this.FileName_Ch2);
                    }
                }
            } else if (this.DecodeMpgAudio && n == 2 && this.AddAiffHeader) {
                if (audioFormat.getLayer() > 1) {
                    MpaDecoder.fillAiff(this.FileName_Ch1, (long)(this.TimeCounter / 90.0), this.FadeInOut, this.FadeInOutMillis);
                    if (this.MpaConversionMode >= 4) {
                        MpaDecoder.fillAiff(this.FileName_Ch2, (long)(this.TimeCounter / 90.0), this.FadeInOut, this.FadeInOutMillis);
                    }
                } else {
                    MpaDecoder.deleteAiff(this.FileName_Ch1);
                    if (this.MpaConversionMode >= 4) {
                        MpaDecoder.deleteAiff(this.FileName_Ch2);
                    }
                }
            } else if ((this.AddWaveHeaderBWF || this.AddWaveHeaderACM) && n == 2) {
                RandomAccessFile[] randomAccessFileArray = new RandomAccessFile[]{new RandomAccessFile(this.FileName_Ch1, "rw"), new RandomAccessFile(this.FileName_Ch2, "rw")};
                audioFormat.setExtraWaveLength(randomAccessFileArray[0].length(), (long)(this.TimeCounter / 90.0), 1);
                audioFormat.setExtraWaveLength(randomAccessFileArray[1].length(), (long)(this.TimeCounter / 90.0), 2);
                randomAccessFileArray[0].seek(0L);
                randomAccessFileArray[1].seek(0L);
                randomAccessFileArray[0].write(audioFormat.getExtraWaveHeader(1, false));
                if (this.MpaConversionMode >= 4) {
                    randomAccessFileArray[1].write(audioFormat.getExtraWaveHeader(2, false));
                }
                randomAccessFileArray[0].close();
                randomAccessFileArray[1].close();
            } else if (this.AddWaveHeaderAC3 && n == 0) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.FileName_Ch1, "rw");
                audioFormat.setExtraWaveLength(randomAccessFile.length(), (long)(this.TimeCounter / 90.0), 1);
                randomAccessFile.seek(0L);
                randomAccessFile.write(audioFormat.getExtraWaveHeader(1, false));
                randomAccessFile.close();
            } else if (n == 4) {
                audioFormat.fillRiffHeader(this.FileName_Ch1);
            } else if (this.CreateDDWave && n == 0) {
                audioFormat.fillStdRiffHeader(this.FileName_Ch1, (long)(this.TimeCounter / 90.0));
            } else if (this.CreateDDWave && n == 6) {
                audioFormat.fillStdRiffHeader(this.FileName_Ch1, (long)(this.TimeCounter / 90.0));
            }
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void initProjectFiles() {
        if (this.CreateM2sIndex) {
            this.OutputStream_Ch1.InitIdd(this.FileName_Ch1, 2);
            this.OutputStream_Ch2.InitIdd(this.FileName_Ch2, 2);
        }
    }

    private int determineStreamType(String string) {
        int n = 2;
        if (string.equals("ac")) {
            n = 0;
        } else if (string.equals("dt")) {
            n = 6;
        } else if (string.equals("wa")) {
            n = 4;
        }
        return n;
    }

    private void messageSettings() {
        if (this.IgnoreErrors) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_Audio_ignoreErrors[0]));
        }
        if (this.AllowSpaces) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_allowSpaces[0]));
        }
        if (this.LimitPts) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_Audio_limitPts[0]));
        }
        if (this.ValidateCRC) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_validateCRC[0]));
        }
        if (this.ClearCRC) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_clearCRC[0]));
        }
        if (this.Patch1stAc3Header) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_patch1stAc3Header[0]));
        }
        if (this.ReplaceAc3withSilence) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_replaceAc3withSilence[0]));
        }
        if (this.FillGapsWithLastFrame) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_fillGapsWithLastFrame[0]));
        }
        if (this.AddFrames) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_addFrames[0]));
        }
        if (this.CreateDDWave) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_createDDWave[0]));
        }
    }

    private void getSettings(JobCollection jobCollection) {
        this.Debug = jobCollection.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
        this.CreateChapters = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createChapters);
        this.AddWaveHeaderACM = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addRiffToMpgAudioL3);
        this.AddWaveHeaderBWF = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addRiffToMpgAudio);
        this.AddWaveHeaderAC3 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addRiffToAc3);
        this.ReplaceAc3withSilence = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_replaceAc3withSilence);
        this.CreateM2sIndex = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createM2sIndex);
        this.Message_2 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg2);
        this.Message_7 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg7);
        this.PitchAudio = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_pitchAudio);
        this.AllowSpaces = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_allowSpaces);
        this.ValidateCRC = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_validateCRC);
        this.Patch1stAc3Header = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_patch1stAc3Header);
        this.FillGapsWithLastFrame = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_fillGapsWithLastFrame);
        this.LimitPts = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Audio_limitPts);
        this.AddFrames = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addFrames);
        this.DownMix = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_Downmix);
        this.ChangeByteorder = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_changeByteorder);
        this.AddRiffHeader = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addRiffHeader);
        this.AddAiffHeader = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addAiffHeader);
        this.ClearCRC = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_clearCRC);
        this.IgnoreErrors = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Audio_ignoreErrors);
        this.CreateDDWave = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_createDDWave);
        this.FadeInOut = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_fadeInOut);
        this.Normalize = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_Normalize);
        this.FadeInOutMillis = jobCollection.getSettings().getIntProperty(Keys.KEY_AudioPanel_fadeInOutMillis);
        this.ResampleAudioMode = jobCollection.getSettings().getIntProperty(Keys.KEY_AudioPanel_resampleAudioMode);
        this.PitchValue = jobCollection.getSettings().getIntProperty(Keys.KEY_AudioPanel_PitchValue);
    }

    private void initDecoder(AudioFormat audioFormat, int n) {
        if (n != 2) {
            return;
        }
        if (!this.DecodeMpgAudio) {
            return;
        }
        MpaDecoder.init_work(this.ResampleAudioMode);
        MpaDecoder.DOWNMIX = this.DownMix;
        MpaDecoder.MONO = this.DownMix || this.MpaConversionMode == 4;
        MpaDecoder.MOTOROLA = this.ChangeByteorder;
        MpaDecoder.WAVE = this.AddRiffHeader;
        if (this.AddRiffHeader) {
            this.writeChannels(MpaDecoder.RIFF);
        }
        if (this.AddAiffHeader) {
            this.writeChannels(MpaDecoder.AIFF);
        }
    }

    private int processData(AudioFormat audioFormat, int n) {
        int n2 = 0;
        this.addWaveHeader(audioFormat, n);
        this.initDecoder(audioFormat, n);
        audioFormat.setAncillaryDataDecoder(this.Message_7, this.Debug);
        return n2;
    }

    private void processPCMData(JobProcessing jobProcessing, AudioFormat audioFormat, long[] lArray, long[] lArray2) {
        byte[] byArray = new byte[1000];
        this.readInputStream(byArray);
        audioFormat.parseHeader(byArray, 0);
        this.unreadInputStream(byArray, audioFormat.getEmphasis(), 1000 - audioFormat.getEmphasis());
        Common.setMessage(Resource.getString("audio.msg.source", audioFormat.saveAndDisplayHeader()) + " " + this.formatFrameTime(this.TimeCounter));
        this.AudioType = 5;
        this.FramePosition = audioFormat.getEmphasis();
        long l = audioFormat.getEmphasis() + audioFormat.getSizeBase();
        this.TimePosition = lArray2[0];
        this.writeChannel1(audioFormat.getRiffHeader());
        int n = 960000 / audioFormat.getMode();
        int n2 = 0;
        if (n2 < lArray2.length - 1) {
            int n3 = lArray.length;
            for (int i = 0; i < n3; i += 2) {
                long l2;
                int n4;
                long l3;
                long l4;
                while (this.pause()) {
                }
                if (this.isCancelled(jobProcessing)) {
                    return;
                }
                if (this.ContainsVideoPTS && lArray[i] < this.TimePosition) {
                    l4 = lArray[i + 1] > this.TimePosition ? this.TimePosition - lArray[i] : lArray[i + 1] - lArray[i];
                    l3 = Math.round(1.0 * (double)audioFormat.getSamplingFrequency() * (double)l4 / 90000.0) * (long)audioFormat.getMode();
                    if (this.Debug) {
                        System.out.println("i " + l4 + "/" + l3 + "/" + this.FramePosition + "/" + this.TimePosition);
                    }
                    for (l2 = 0L; l2 < l3; l2 += (long)n4) {
                        int n5 = n4 = l3 - l2 >= (long)n ? n : (int)(l3 - l2);
                        if (n4 != byArray.length) {
                            byArray = new byte[n4];
                        }
                        this.writeChannel1(byArray);
                    }
                    this.TimeCounter += (double)l4;
                    this.FrameExportInfo.countWrittenFrames(l3 / (long)audioFormat.getMode());
                    Common.setFps(this.FrameExportInfo.getWrittenFrames());
                    if (lArray[i + 1] > this.TimePosition) {
                        l4 = lArray[i + 1] - this.TimePosition;
                        l3 = Math.round(1.0 * (double)audioFormat.getSamplingFrequency() * (double)l4 / 90000.0) * (long)audioFormat.getMode();
                        if (this.Debug) {
                            System.out.println("b " + l4 + "/" + l3 + "/" + this.FramePosition + "/" + this.TimePosition);
                        }
                        for (l2 = 0L; l2 < l3; l2 += (long)n4) {
                            int n6 = n4 = l3 - l2 >= (long)n ? n : (int)(l3 - l2);
                            if (n4 != byArray.length) {
                                byArray = new byte[n4];
                            }
                            this.readInputStream(byArray);
                            this.writeChannel1(byArray);
                        }
                        this.FramePosition += l3;
                        this.TimePosition += l4;
                        this.TimeCounter += (double)l4;
                        this.FrameExportInfo.countWrittenFrames(l3 / (long)audioFormat.getMode());
                    }
                } else {
                    long l5 = this.ContainsVideoPTS ? lArray[i] - this.TimePosition : 0L;
                    long l6 = Math.round(1.0 * (double)audioFormat.getSamplingFrequency() * (double)l5 / 90000.0) * (long)audioFormat.getMode();
                    l4 = this.ContainsVideoPTS ? lArray[i + 1] - lArray[i] : (long)(1.0 * (double)(audioFormat.getSizeBase() / audioFormat.getMode()) / (double)audioFormat.getSamplingFrequency() * 90000.0);
                    l3 = Math.round(1.0 * (double)audioFormat.getSamplingFrequency() * (double)l4 / 90000.0) * (long)audioFormat.getMode();
                    for (l2 = 0L; l2 < l6; l2 += this.skipInputStream(l6 - l2)) {
                    }
                    this.FramePosition += l6;
                    if (this.Debug) {
                        System.out.println("c " + l5 + "/" + l6 + "/" + l4 + "/" + l3 + "/" + this.FramePosition + "/" + this.TimePosition);
                    }
                    for (l2 = 0L; l2 < l3; l2 += (long)n4) {
                        int n7 = n4 = l3 - l2 >= (long)n ? n : (int)(l3 - l2);
                        if (n4 != byArray.length) {
                            byArray = new byte[n4];
                        }
                        this.readInputStream(byArray);
                        this.writeChannel1(byArray);
                    }
                    this.TimePosition += l5 + l4;
                    this.TimeCounter += (double)l4;
                    this.FramePosition += l3;
                    this.FrameExportInfo.countWrittenFrames(l3 / (long)audioFormat.getMode());
                }
                if (this.Debug) {
                    System.out.println(this.FrameExportInfo.getSummary() + " @ " + this.formatFrameTime(this.TimeCounter));
                }
                Common.updateProgressBar(this.FramePosition, this.FileLength);
                if (!this.Debug) continue;
                System.out.println("FramePosition " + this.FramePosition);
            }
        }
    }

    class FrameExportInfo {
        private int writtenFrames;
        private int preInsertedFrames;
        private int skippedFrames;
        private int insertedFrames;
        private int addedFrames;
        private String head = "Audio Frames: wri-pre-skip-ins-add: ";
        private String delim = "-";

        public FrameExportInfo() {
            this.reset();
        }

        public void reset() {
            this.writtenFrames = 0;
            this.preInsertedFrames = 0;
            this.skippedFrames = 0;
            this.insertedFrames = 0;
            this.addedFrames = 0;
        }

        public int getWrittenFrames() {
            return this.writtenFrames;
        }

        public String getSummary() {
            String string = this.head;
            string = string + String.valueOf(this.writtenFrames) + this.delim;
            string = string + this.getShortSummary();
            return string;
        }

        public String getShortSummary() {
            String string = "";
            string = string + String.valueOf(this.preInsertedFrames) + this.delim;
            string = string + String.valueOf(this.skippedFrames) + this.delim;
            string = string + String.valueOf(this.insertedFrames) + this.delim;
            string = string + String.valueOf(this.addedFrames);
            return string;
        }

        public void countWrittenFrames(long l) {
            this.writtenFrames += (int)l;
        }

        public void countWrittenFrames(int n) {
            this.writtenFrames += n;
        }

        public void countPreInsertedFrames(int n) {
            this.preInsertedFrames += n;
        }

        public void countSkippedFrames(int n) {
            this.skippedFrames += n;
        }

        public void countInsertedFrames(int n) {
            this.insertedFrames += n;
        }

        public void countAddedFrames(int n) {
            this.addedFrames += n;
        }
    }
}

