/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.StreamBuffer;
import net.sourceforge.dvb.projectx.parser.StreamConverter;
import net.sourceforge.dvb.projectx.parser.StreamDemultiplexer;
import net.sourceforge.dvb.projectx.parser.StreamParserBase;
import net.sourceforge.dvb.projectx.xinput.StreamInfo;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StreamParserTS
extends StreamParserBase {
    private StreamBuffer streambuffer;
    private ArrayList usedPIDs;
    private List TSPidlist;
    private PushbackInputStream inputstream;
    private boolean HumaxAdaption;
    private boolean HandanAdaption;
    private boolean KoscomAdaption;
    private boolean Debug;
    private long count;
    private byte TS_SyncByte = (byte)71;
    private byte[] hav_chunk = new byte[]{91, 72, 79, 74, 73, 78, 32, 65};
    private byte[] tmp_chunk = new byte[36];
    private int TS_BufferSize = 189;
    private int TS_PacketLength = 188;
    private int PidMask = 8191;
    private int MaxBufferSize = 6000000;
    private int PushbackBufferSize = 225;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String parseStream(JobCollection jobCollection, XInputFile xInputFile, int n, int n2, String string) {
        int n3;
        int[] nArray;
        JobProcessing jobProcessing = jobCollection.getJobProcessing();
        this.setFileName(jobCollection, jobProcessing, xInputFile);
        string = "-1";
        boolean bl = jobCollection.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg1);
        boolean bl2 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg2);
        this.Debug = jobCollection.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
        boolean bl3 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_TS_joinPackets);
        boolean bl4 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Input_getEnclosedPackets);
        boolean bl5 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_TS_ignoreScrambled);
        boolean bl6 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Conversion_PcrCounter);
        boolean bl7 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_TS_blindSearch);
        CreateD2vIndex = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createD2vIndex);
        SplitProjectFile = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_splitProjectFile);
        boolean bl8 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_useAutoPidFilter);
        boolean bl9 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExportPanel_Export_Overlap);
        this.HumaxAdaption = jobCollection.getSettings().getBooleanProperty(Keys.KEY_TS_HumaxAdaption);
        this.HandanAdaption = jobCollection.getSettings().getBooleanProperty(Keys.KEY_TS_FinepassAdaption);
        this.KoscomAdaption = jobCollection.getSettings().getBooleanProperty(Keys.KEY_TS_KoscomAdaption);
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        byte[] byArray = new byte[this.TS_BufferSize];
        int n4 = Integer.parseInt(jobCollection.getSettings().getProperty(Keys.KEY_ExportPanel_Infoscan_Value));
        int n5 = jobCollection.getSettings().getIntProperty(Keys.KEY_CutMode);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 6;
        int n15 = 9;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int[] nArray2 = new int[]{128, 144, 192, 224, 160, 32};
        jobProcessing.clearStatusVariables();
        int[] nArray3 = jobProcessing.getStatusVariables();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        this.count = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long[] lArray = new long[jobCollection.getPrimaryInputFileSegments()];
        long l7 = 0x100000L * (long)(jobCollection.getSettings().getIntProperty(Keys.KEY_ExportPanel_Overlap_Value) + 1);
        streamconverter = new StreamConverter();
        this.usedPIDs = new ArrayList();
        demuxList = jobProcessing.getTSDemuxList();
        this.TSPidlist = jobProcessing.getTSPidList();
        if (jobProcessing.getSplitPart() == 0) {
            this.TSPidlist.clear();
            demuxList.clear();
        } else {
            int n19;
            for (n19 = 0; n19 < this.TSPidlist.size(); ++n19) {
                this.streambuffer = (StreamBuffer)this.TSPidlist.get(n19);
                this.streambuffer.reset();
                this.streambuffer.setStarted(false);
            }
            for (n19 = 0; n19 < demuxList.size(); ++n19) {
                streamdemultiplexer = (StreamDemultiplexer)demuxList.get(n19);
                if (streamdemultiplexer.getnewID() != 0) {
                    int n20 = streamdemultiplexer.getType();
                    nArray2[n20] = nArray2[n20] + 1;
                }
                if (streamdemultiplexer.getNum() == -1) continue;
                if (streamdemultiplexer.getType() == 3) {
                    streamdemultiplexer.initVideo2(jobCollection, fparent);
                    continue;
                }
                streamdemultiplexer.init2(jobCollection, fparent);
            }
        }
        if (jobProcessing.getSplitPart() == 0) {
            StreamInfo streamInfo = xInputFile.getStreamInfo();
            nArray = streamInfo.getPIDs();
            if (nArray.length > 0) {
                Common.setMessage(Resource.getString("parseTS.sid") + Integer.toHexString(nArray[0]).toUpperCase());
                Common.setMessage(Resource.getString("parseTS.pmt.refers", Integer.toHexString(nArray[1]).toUpperCase()));
                Common.setMessage(Resource.getString("ScanInfo.Video"));
                Common.setMessage(streamInfo.getVideo());
                Common.setMessage(Resource.getString("ScanInfo.Audio"));
                Common.setMessage(streamInfo.getAudio());
                Common.setMessage(Resource.getString("ScanInfo.Teletext"));
                Common.setMessage(streamInfo.getTeletext());
                Common.setMessage(Resource.getString("ScanInfo.Subpicture"));
                Common.setMessage(streamInfo.getSubpicture());
                Common.setMessage("");
                for (n3 = 2; n3 < nArray.length; ++n3) {
                    this.streambuffer = new StreamBuffer();
                    this.TSPidlist.add(this.streambuffer);
                    this.streambuffer.setPID(nArray[n3]);
                }
            } else {
                Common.setMessage(Resource.getString("parseTS.no.pmt"));
            }
        }
        this.initConversion(jobCollection, fparent, n2, 4, jobProcessing.getSplitPart());
        if (CreateD2vIndex || SplitProjectFile) {
            jobProcessing.getProjectFileD2V().Init(fparent);
        }
        jobProcessing.setMinBitrate(262143);
        jobProcessing.setMaxBitrate(0);
        jobProcessing.setExportedVideoFrameNumber(0);
        jobProcessing.setEndPtsOfGop(-10000L);
        jobProcessing.setSequenceHeader(true);
        jobProcessing.setAllMediaFilesExportLength(0L);
        jobProcessing.setProjectFileExportLength(0L);
        jobProcessing.setCutByteposition(0L);
        int[] nArray4 = bl8 ? xInputFile.getStreamInfo().getMediaPIDs() : jobCollection.getPIDsAsInteger();
        nArray = new int[nArray4.length];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = this.PidMask & nArray4[n3];
        }
        if (nArray.length > 0) {
            Arrays.sort(nArray);
            String string2 = " ";
            for (int i = 0; i < nArray.length; ++i) {
                string2 = string2 + "0x" + Integer.toHexString(nArray[i]).toUpperCase() + " ";
            }
            Common.setMessage(Resource.getString("parseTS.special.pids") + ": {" + string2 + "}");
            bl16 = true;
        }
        try {
            int n21;
            for (int i = 0; i < lArray.length; l5 += xInputFile.length(), ++i) {
                xInputFile = (XInputFile)jobCollection.getInputFile(i);
                lArray[i] = l5;
            }
            xInputFile = (XInputFile)jobCollection.getInputFile(jobProcessing.getFileNumber());
            this.count = lArray[jobProcessing.getFileNumber()];
            l5 = this.count + xInputFile.length();
            if (jobProcessing.getSplitSize() > 0L) {
                l6 = jobProcessing.getLastHeaderBytePosition();
                l6 -= !bl9 ? 0L : l7;
                jobProcessing.setLastGopTimecode(0L);
                jobProcessing.setLastGopPts(0L);
                jobProcessing.setLastSimplifiedPts(0L);
            }
            List list = jobCollection.getCutpointList();
            List list2 = jobCollection.getChapterpointList();
            if (n5 == 0 && list.size() > 0 && CommonParsing.getCutCounter() == 0) {
                l6 = Long.parseLong(list.get(CommonParsing.getCutCounter()).toString()) - (long)(n2 == 0 ? 2048000 : 0);
            }
            if (l6 < 0L) {
                l6 = this.count;
            } else if (l6 < this.count) {
                for (n21 = lArray.length; n21 > 0; --n21) {
                    if (lArray[n21 - 1] <= l6) continue;
                    jobProcessing.countFileNumber(-1);
                }
            } else if (l6 > this.count) {
                for (n21 = jobProcessing.getFileNumber() + 1; n21 < lArray.length && lArray[n21] <= l6; ++n21) {
                    jobProcessing.countFileNumber(1);
                }
            }
            xInputFile = (XInputFile)jobCollection.getInputFile(jobProcessing.getFileNumber());
            this.count = lArray[jobProcessing.getFileNumber()];
            if (jobProcessing.getFileNumber() > 0) {
                Common.setMessage(Resource.getString("parseTS.continue") + " " + xInputFile);
            }
            long l8 = this.count;
            l5 = this.count + xInputFile.length();
            this.inputstream = new PushbackInputStream(xInputFile.getInputStream(l6 - l8), this.PushbackBufferSize);
            this.count += l6 - l8;
            Common.updateProgressBar((n2 == 0 ? Resource.getString("parseTS.demuxing") : Resource.getString("parseTS.converting")) + " " + Resource.getString("parseTS.dvb.mpeg") + " " + xInputFile.getName(), this.count - l8, l5 - l8);
            long l9 = this.count + 0x100000L * (long)n4;
            block27: while (true) {
                block137: {
                    boolean bl17;
                    int n22;
                    block144: {
                        block143: {
                            block142: {
                                block140: {
                                    block141: {
                                        block138: {
                                            block139: {
                                                if (this.count >= l5) break block137;
                                                while (this.pause()) {
                                                }
                                                if (CommonParsing.isProcessCancelled() || CommonParsing.isInfoScan() && this.count > l9) {
                                                    CommonParsing.setProcessCancelled(false);
                                                    jobProcessing.setSplitSize(0L);
                                                    break;
                                                }
                                                if (jobProcessing.getCutComparePoint() + 20L < (long)jobProcessing.getSourceVideoFrameNumber()) {
                                                    bl14 = true;
                                                    break;
                                                }
                                                if (n5 == 0 && list.size() > 0 && CommonParsing.getCutCounter() == list.size() && (CommonParsing.getCutCounter() & 1) == 0 && this.count > Long.parseLong(list.get(CommonParsing.getCutCounter() - 1).toString()) + 2048000L) {
                                                    bl14 = true;
                                                    break;
                                                }
                                                if (bl10 && bl3) break block138;
                                                n18 = this.inputstream.read(byArray, 0, this.TS_BufferSize);
                                                if (n18 != this.TS_PacketLength || l5 - this.count != (long)n18) break block139;
                                                byArray[188] = this.TS_SyncByte;
                                                break block138;
                                            }
                                            if (n18 >= this.TS_BufferSize || !bl3) break block138;
                                            Common.setMessage(Resource.getString("parseTS.incomplete") + " " + this.count);
                                            this.count += (long)n18;
                                            break block137;
                                        }
                                        this.skipLeadingHumaxDataChunk(byArray);
                                        this.skipLeadingKoscomDataChunk(byArray);
                                        this.skipLeadingHandanDataChunk(byArray);
                                        if (this.skipKoscomDataChunk(byArray) || this.skipHumaxDataChunk(byArray)) break block140;
                                        if (byArray[0] == this.TS_SyncByte && (!bl4 || byArray[188] == this.TS_SyncByte)) break block141;
                                        if (bl2 && !bl15) {
                                            Common.setMessage(Resource.getString("parseTS.missing.sync") + " " + this.count);
                                        }
                                        if (!bl10 || !bl3) break block142;
                                        Common.setMessage(Resource.getString("parseTS.comp.failed"));
                                        this.inputstream.unread(byArray, 190 - n18, n18 - 1);
                                        bl10 = false;
                                        ++this.count;
                                        break block143;
                                    }
                                    if (bl10 && bl3) {
                                        Common.setMessage(Resource.getString("parseTS.comp.ok"));
                                    }
                                }
                                if (bl2 && bl15) {
                                    Common.setMessage(Resource.getString("parseTS.found.sync") + " " + this.count);
                                }
                                bl15 = false;
                                this.inputstream.unread(byArray, this.TS_PacketLength, 1);
                                jobProcessing.setLastHeaderBytePosition(this.count);
                                l = this.count;
                                if (bl10 && bl3) {
                                    this.count += (long)(n18 - 1);
                                    bl10 = false;
                                } else {
                                    this.count += (long)this.TS_PacketLength;
                                }
                                ++l4;
                                bl12 = (0x80 & byArray[1]) != 0;
                                bl11 = (0x40 & byArray[1]) != 0;
                                n22 = (0x1F & byArray[1]) << 8 | 0xFF & byArray[2];
                                n6 = (0xC0 & byArray[3]) >>> 6;
                                n7 = (0x30 & byArray[3]) >>> 4;
                                n8 = 0xF & byArray[3];
                                n9 = n7 > 1 ? (0xFF & byArray[4]) + 1 : 0;
                                Common.updateProgressBar(this.count - l8, l5 - l8);
                                if (bl16 && Arrays.binarySearch(nArray, n22) < 0) continue;
                                if (n2 == 5) {
                                    streamconverter.write(jobProcessing, byArray, 0, this.TS_PacketLength, null, l, CommonParsing.isInfoScan(), list);
                                    continue;
                                }
                                if ((n7 & 1) == 0) continue;
                                if (n9 > 183 || n9 > 180 && bl11) {
                                    bl12 = true;
                                }
                                if (bl12) {
                                    if (!bl) continue;
                                    Common.setMessage(Resource.getString("parseTS.bit.error", Integer.toHexString(n22).toUpperCase(), "" + l4, "" + (this.count - 188L)));
                                    continue;
                                }
                                n10 = bl11 ? CommonParsing.getIntValue(byArray, 4 + n9, 4, false) : 0;
                                n11 = bl11 ? n10 >>> 16 : 0;
                                bl17 = false;
                                break block144;
                            }
                            for (n21 = 1; n21 < this.TS_BufferSize && byArray[n21] != this.TS_SyncByte; ++n21) {
                            }
                            this.inputstream.unread(byArray, n21, this.TS_BufferSize - n21);
                            this.count += (long)n21;
                        }
                        bl15 = true;
                        continue;
                    }
                    for (n21 = 0; n21 < this.TSPidlist.size(); ++n21) {
                        this.streambuffer = (StreamBuffer)this.TSPidlist.get(n21);
                        boolean bl18 = bl17 = n22 == this.streambuffer.getPID();
                        if (bl17) break;
                    }
                    if (!bl17) {
                        this.streambuffer = new StreamBuffer();
                        this.TSPidlist.add(this.streambuffer);
                        this.streambuffer.setPID(n22);
                        if (n22 == this.PidMask) {
                            Common.setMessage(Resource.getString("parseTS.stuffing"));
                            this.streambuffer.setneeded(false);
                        }
                    }
                    if (this.Debug) {
                        System.out.println("pk " + l4 + " /pid " + Integer.toHexString(n22) + " /pes " + Integer.toHexString(n10) + " /tn " + this.streambuffer.isneeded() + " /er " + bl12 + " /st " + bl11 + " /sc " + n6 + " /ad " + n7 + " /al " + n9);
                    }
                    if (!this.streambuffer.isneeded()) continue;
                    if (bl5) {
                        if (n6 > 0) {
                            if (this.streambuffer.getScram()) continue;
                            this.streambuffer.setScram(true);
                            Common.setMessage(Resource.getString("parseTS.scrambled", Integer.toHexString(n22).toUpperCase(), String.valueOf(l4), String.valueOf(this.count - 188L)));
                            continue;
                        }
                        if (this.streambuffer.getScram()) {
                            this.streambuffer.setScram(false);
                            Common.setMessage(Resource.getString("parseTS.clear", Integer.toHexString(n22).toUpperCase(), String.valueOf(l4), String.valueOf(this.count - 188L)));
                        }
                    }
                    if (bl && (bl6 || !bl6 && (1 & n7) != 0)) {
                        if (this.streambuffer.getCounter() != -1) {
                            if (this.streambuffer.isStarted() && n8 != this.streambuffer.getCounter()) {
                                Common.setMessage(Resource.getString("parseTS.outof.sequence", Integer.toHexString(n22).toUpperCase(), String.valueOf(l4), String.valueOf(this.count - 188L), String.valueOf(n8), String.valueOf(this.streambuffer.getCounter())) + " (~" + Common.formatTime_1((long)(CommonParsing.getVideoFramerate() / 90.0 * (double)jobProcessing.getExportedVideoFrameNumber())) + ")");
                                this.streambuffer.setCounter(n8);
                            }
                            this.streambuffer.count();
                        } else {
                            this.streambuffer.setCounter(n8);
                            this.streambuffer.count();
                        }
                    }
                    if (!bl11) {
                        if (this.streambuffer.isneeded() && this.streambuffer.isStarted()) {
                            this.streambuffer.writeData(byArray, 4 + n9, 184 - n9);
                        }
                        if (this.streambuffer.getDataSize() > this.MaxBufferSize) {
                            Common.setMessage("!> 0x" + Integer.toHexString(this.streambuffer.getPID()).toUpperCase() + ", buffered packet exceed maximum size, flushed...");
                            this.streambuffer.reset();
                        }
                    } else {
                        byte[] byArray2;
                        int n23;
                        boolean bl19;
                        block135: {
                            bl19 = false;
                            n17 = 0;
                            if (this.streambuffer.getID() == -1 && n10 == 445) {
                                n12 = 0;
                                n16 = 0;
                                try {
                                    n12 = 0xFF & byArray[12 + n9];
                                    n16 = 13 + n9 + n12;
                                    boolean bl20 = bl19 = n12 == 36 && (0xFF & byArray[n16]) >>> 4 == 1;
                                    if (bl19) break block135;
                                    n17 = (0xFF & byArray[n16]) == 32 && (0xFF & byArray[n16 + 1]) == 0 && (0xFF & byArray[n16 + 2]) == 15 ? 32 : 0;
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    Common.setMessage(Resource.getString("parseTS.io.error") + " / " + n12 + " / " + n16);
                                    Common.setExceptionMessage(arrayIndexOutOfBoundsException);
                                    this.streambuffer.reset();
                                    this.streambuffer.setStarted(false);
                                    continue;
                                }
                            }
                        }
                        this.streambuffer.setStarted(true);
                        if (this.streambuffer.getID() == -1) {
                            this.streambuffer.setID(n10);
                            String string3 = "";
                            switch (0xFFFFFFF0 & n10) {
                                case 480: {
                                    string3 = Resource.getString("idtype.mpeg.video");
                                    this.streambuffer.setDemux(demuxList.size());
                                    streamdemultiplexer = new StreamDemultiplexer(jobCollection);
                                    streamdemultiplexer.setPID(n22);
                                    streamdemultiplexer.setID(n10);
                                    int n24 = nArray2[3];
                                    nArray2[3] = n24 + 1;
                                    streamdemultiplexer.setnewID(n24);
                                    streamdemultiplexer.setsubID(0);
                                    streamdemultiplexer.setType(3);
                                    streamdemultiplexer.setStreamType(n);
                                    demuxList.add(streamdemultiplexer);
                                    if (n2 == 0) {
                                        if (nArray2[3] - 1 == 224) {
                                            streamdemultiplexer.initVideo(jobCollection, fparent, this.MainBufferSize / demuxList.size(), demuxList.size(), 2);
                                            break;
                                        }
                                        string3 = string3 + Resource.getString("idtype.ignored");
                                        this.streambuffer.setneeded(false);
                                        break;
                                    }
                                    string3 = string3 + " " + Resource.getString("idtype.mapped.to") + Integer.toHexString(nArray2[3] - 1).toUpperCase();
                                    break;
                                }
                                case 448: 
                                case 464: {
                                    string3 = Resource.getString("idtype.mpeg.audio");
                                    this.streambuffer.setDemux(demuxList.size());
                                    streamdemultiplexer = new StreamDemultiplexer(jobCollection);
                                    streamdemultiplexer.setPID(n22);
                                    streamdemultiplexer.setID(n10);
                                    int n25 = nArray2[2];
                                    nArray2[2] = n25 + 1;
                                    streamdemultiplexer.setnewID(n25);
                                    streamdemultiplexer.setsubID(0);
                                    streamdemultiplexer.setType(2);
                                    streamdemultiplexer.setStreamType(n);
                                    demuxList.add(streamdemultiplexer);
                                    if (n2 == 0) {
                                        streamdemultiplexer.init(jobCollection, fparent, this.MainBufferSize / demuxList.size(), demuxList.size(), 2);
                                        break;
                                    }
                                    string3 = string3 + " " + Resource.getString("idtype.mapped.to") + Integer.toHexString(nArray2[2] - 1).toUpperCase();
                                    break;
                                }
                            }
                            switch (n10) {
                                case 445: {
                                    string3 = Resource.getString("idtype.private.stream");
                                    string3 = string3 + (bl19 ? " (TTX) " : "") + (n17 != 0 ? " (SubID 0x" + Integer.toHexString(n17).toUpperCase() + ")" : "");
                                    this.streambuffer.setDemux(demuxList.size());
                                    streamdemultiplexer = new StreamDemultiplexer(jobCollection);
                                    streamdemultiplexer.setPID(n22);
                                    streamdemultiplexer.setID(n10);
                                    streamdemultiplexer.setsubID(n17);
                                    streamdemultiplexer.setTTX(bl19);
                                    if (bl19) {
                                        int n26 = nArray2[1];
                                        nArray2[1] = n26 + 1;
                                        streamdemultiplexer.setnewID(n26);
                                        streamdemultiplexer.setType(1);
                                    } else if (n17 == 32) {
                                        int n27 = nArray2[5];
                                        nArray2[5] = n27 + 1;
                                        streamdemultiplexer.setnewID(n27);
                                        streamdemultiplexer.setType(5);
                                    } else {
                                        int n28 = nArray2[0];
                                        nArray2[0] = n28 + 1;
                                        streamdemultiplexer.setnewID(n28);
                                        streamdemultiplexer.setType(0);
                                    }
                                    streamdemultiplexer.setStreamType(n17 == 32 ? 3 : 1);
                                    demuxList.add(streamdemultiplexer);
                                    if (n2 == 0) {
                                        streamdemultiplexer.init(jobCollection, fparent, this.MainBufferSize / demuxList.size(), demuxList.size(), 2);
                                    }
                                    if (n2 != 0 && n17 != 0) {
                                        string3 = string3 + Resource.getString("idtype.ignored");
                                        this.streambuffer.setneeded(false);
                                    }
                                    if (n2 != 0 && !bl19) {
                                        string3 = string3 + " " + Resource.getString("idtype.mapped.to") + Integer.toHexString(nArray2[0] - 1).toUpperCase();
                                    }
                                    if (n2 == 0 || !bl19) break;
                                    string3 = string3 + " " + Resource.getString("idtype.mapped.to") + Integer.toHexString(nArray2[1] - 1).toUpperCase();
                                    break;
                                }
                                case 447: {
                                    Common.setMessage(Resource.getString("parseTS.priv.stream2.ignored", Integer.toHexString(n22).toUpperCase()));
                                    this.streambuffer.setneeded(false);
                                    continue block27;
                                }
                            }
                            if (string3.equals("")) {
                                if (n22 == 0 && n11 == 0) {
                                    string3 = "(PAT)";
                                } else if (n22 == 1 && n11 == 1) {
                                    string3 = "(CAT)";
                                } else if (n22 == 2 && n11 == 3) {
                                    string3 = "(TSDT)";
                                } else if (n22 == 16 && (n11 == 6 || n11 == 64 || n11 == 65)) {
                                    string3 = "(NIT)";
                                } else if (n22 == 17 && (n11 == 66 || n11 == 70)) {
                                    string3 = "(SDT)";
                                } else if (n22 == 17 && n11 == 74) {
                                    string3 = "(BAT)";
                                } else if (n22 == 18 && n11 >= 78 && n11 <= 111) {
                                    string3 = "(EIT)";
                                } else if (n22 == 19 && n11 == 113) {
                                    string3 = "(RST)";
                                } else if (n22 == 31 && n11 == 127) {
                                    string3 = "(SIT)";
                                } else if (n22 == 30 && n11 == 126) {
                                    string3 = "(DIT)";
                                } else if (n22 == 20 && n11 == 112) {
                                    string3 = "(TDS)";
                                } else if (n22 == 20 && n11 == 115) {
                                    string3 = "(TOT)";
                                } else if (n11 == 114 && n22 >= 16 && n22 <= 20) {
                                    string3 = "(ST)";
                                } else {
                                    switch (n11) {
                                        case 2: {
                                            string3 = "(PMT)";
                                            break;
                                        }
                                        case 4: {
                                            string3 = "(PSI)";
                                            break;
                                        }
                                        case 130: {
                                            string3 = "(EMM)";
                                            break;
                                        }
                                        case 128: 
                                        case 129: 
                                        case 131: 
                                        case 132: {
                                            string3 = "(ECM)";
                                            break;
                                        }
                                        case 67: 
                                        case 68: 
                                        case 69: 
                                        case 71: 
                                        case 72: 
                                        case 73: 
                                        case 75: 
                                        case 76: 
                                        case 77: 
                                        case 255: {
                                            string3 = "(res.)";
                                            break;
                                        }
                                        default: {
                                            if (n11 >= 4 && n11 <= 63 || n11 >= 116 && n11 <= 125) {
                                                string3 = "(res.)";
                                                break;
                                            }
                                            if (n11 >= 128 && n11 < 255) {
                                                string3 = "(user def. 0x" + Integer.toHexString(n11).toUpperCase() + ")";
                                                break;
                                            }
                                            string3 = string3 + "(payload: ";
                                            for (n23 = 0; n23 < 8; ++n23) {
                                                String string4 = Integer.toHexString(0xFF & byArray[4 + n9 + n23]).toUpperCase();
                                                string3 = string3 + " " + (string4.length() < 2 ? "0" + string4 : string4);
                                            }
                                            string3 = string3 + " ..)";
                                        }
                                    }
                                }
                                if (n6 > 0 && !bl5) {
                                    string3 = string3 + " (0x" + Long.toHexString(this.count - (long)this.TS_PacketLength).toUpperCase() + " #" + l4 + ") ";
                                    if (!this.streambuffer.getScram()) {
                                        Common.setMessage(Resource.getString("parseTS.scrambled.notignored", Integer.toHexString(n22).toUpperCase(), string3));
                                    }
                                    this.streambuffer.setScram(true);
                                    this.streambuffer.setStarted(false);
                                    this.streambuffer.setID(-1);
                                    this.streambuffer.reset();
                                    continue;
                                }
                                string3 = string3 + " (" + (this.count - (long)this.TS_PacketLength) + " #" + l4 + ") ";
                                Common.setMessage("!> PID 0x" + Integer.toHexString(n22).toUpperCase() + " " + string3 + Resource.getString("parseTS.ignored"));
                                if (!bl7 || string3.indexOf("pay") == -1) {
                                    this.streambuffer.setneeded(false);
                                    continue;
                                }
                                this.streambuffer.setID(-1);
                                continue;
                            }
                            string3 = string3 + " (" + (this.count - (long)this.TS_PacketLength) + " #" + l4 + ") ";
                            Common.setMessage(Resource.getString("parseTS.pid.has.pes", Integer.toHexString(n22).toUpperCase(), Integer.toHexString(0xFF & n10).toUpperCase(), string3));
                            this.usedPIDs.add("0x" + Integer.toHexString(n22));
                        }
                        if (this.streambuffer.getDemux() == -1 || !this.streambuffer.isneeded()) continue;
                        streamdemultiplexer = (StreamDemultiplexer)demuxList.get(this.streambuffer.getDemux());
                        if (streamdemultiplexer.StreamEnabled()) {
                            byArray2 = this.streambuffer.getData().toByteArray();
                            if (byArray2.length < 6) {
                                if (streamdemultiplexer.getPackCount() != -1) {
                                    Common.setMessage(Resource.getString("parseTS.lackof.pes", Integer.toHexString(n22).toUpperCase()));
                                }
                            } else if (CommonParsing.validateStartcode(byArray2, 0) < 0) {
                                Common.setMessage("!> PID 0x" + Integer.toHexString(n22).toUpperCase() + " - invalid start_code of buffered packet..");
                            } else {
                                n13 = CommonParsing.getPES_LengthField(byArray2, 0);
                                int n29 = n14 + n13;
                                int n30 = streamdemultiplexer.getID();
                                if (streamdemultiplexer.getType() != 3) {
                                    if (n2 == 0) {
                                        streamdemultiplexer.write(jobProcessing, byArray2, 0, n29, true);
                                    } else {
                                        streamconverter.write(jobProcessing, byArray2, streamdemultiplexer, l, CommonParsing.isInfoScan(), list);
                                    }
                                } else {
                                    n29 = n2 == 0 ? 65532 : 6144;
                                    int n31 = n29;
                                    int n32 = (0xF3 & byArray2[6]) << 16;
                                    for (int i = 0; i < byArray2.length; i += n31) {
                                        if (byArray2.length - i < n31) {
                                            n31 = byArray2.length - i;
                                        }
                                        if (i == 0) {
                                            CommonParsing.setPES_LengthField(byArray2, i, n31 - n14);
                                            if (n2 == 0) {
                                                streamdemultiplexer.writeVideo(jobProcessing, byArray2, i, n31, true, list, list2);
                                                jobProcessing.setCutByteposition(l);
                                                continue;
                                            }
                                            streamconverter.write(jobProcessing, byArray2, i, streamdemultiplexer, l, CommonParsing.isInfoScan(), list);
                                            continue;
                                        }
                                        n23 = i - n15;
                                        CommonParsing.setValue(byArray2, n23, 4, false, 0x100 | n30);
                                        CommonParsing.setPES_LengthField(byArray2, n23, n31 + 3);
                                        CommonParsing.setValue(byArray2, n23 + n14, 3, false, n32);
                                        if (n2 == 0) {
                                            streamdemultiplexer.writeVideo(jobProcessing, byArray2, n23, n31 + 3, true, list, list2);
                                            jobProcessing.setCutByteposition(l);
                                            continue;
                                        }
                                        streamconverter.write(jobProcessing, byArray2, n23, streamdemultiplexer, l, CommonParsing.isInfoScan(), list);
                                    }
                                }
                            }
                        }
                        byArray2 = null;
                        this.streambuffer.reset();
                        this.streambuffer.writeData(byArray, 4 + n9, 184 - n9);
                    }
                    nArray3[5] = nArray3[5] + 1;
                    if (n2 != 0) {
                        jobProcessing.setLastHeaderBytePosition(this.count);
                    }
                    if (jobProcessing.getSplitSize() <= 0L || jobProcessing.getSplitSize() >= jobProcessing.getAllMediaFilesExportLength()) continue;
                }
                if (jobProcessing.getSplitSize() > 0L && jobProcessing.getSplitSize() < jobProcessing.getAllMediaFilesExportLength() || jobProcessing.getFileNumber() >= jobCollection.getPrimaryInputFileSegments() - 1) break;
                this.inputstream.close();
                long l10 = this.checkNextKoscomSegment(jobCollection, jobProcessing.getFileNumber(), n18);
                XInputFile xInputFile2 = (XInputFile)jobCollection.getInputFile(jobProcessing.countFileNumber(1));
                this.count = l5 + l10;
                this.inputstream = new PushbackInputStream(xInputFile2.getInputStream(l10), this.PushbackBufferSize);
                l5 += xInputFile2.length();
                l8 = this.count;
                this.addCellTimeFromFileSegment(jobProcessing);
                Common.setMessage(Resource.getString("parseTS.actual.vframes") + " " + jobProcessing.getExportedVideoFrameNumber());
                Common.setMessage(Resource.getString("parseTS.switch.to") + " " + xInputFile2 + " (" + Common.formatNumber(xInputFile2.length()) + " bytes) @ " + l8);
                Common.updateProgressBar((n2 == 0 ? Resource.getString("parseTS.demuxing") : Resource.getString("parseTS.converting")) + " " + Resource.getString("parseTS.dvb.mpeg") + " " + xInputFile2.getName());
                if (!bl3 || n18 >= this.TS_PacketLength || xInputFile2.length() < (long)(this.TS_BufferSize - n18)) continue;
                bl10 = true;
                n18 = this.inputstream.read(byArray, n18, this.TS_BufferSize - n18);
                Common.setMessage(Resource.getString("parseTS.tryto.complete"));
            }
            Common.setMessage(Resource.getString("parseTS.packs", String.valueOf(nArray3[5]), String.valueOf(this.count * 100L / l5), String.valueOf(this.count)));
            if ((this.count >= l5 || bl14) && jobProcessing.getSplitSize() > 0L) {
                jobProcessing.setSplitLoopActive(false);
            }
            this.inputstream.close();
            string = this.processElementaryStreams(string, n2, nArray3, jobCollection, jobProcessing);
            this.loadUsablePids(jobCollection);
            return string;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        return string;
    }

    private void loadUsablePids(JobCollection jobCollection) {
        if (CommonParsing.isInfoScan() && jobCollection.getPIDCount() == 0) {
            jobCollection.addPID(this.usedPIDs.toArray());
            Common.setActiveCollection(Common.getProcessedCollection());
            Common.getGuiInterface().updateCollectionPanel(Common.getActiveCollection());
        }
    }

    private boolean skipLeadingHumaxDataChunk(byte[] byArray) {
        boolean bl = false;
        int n = 1184;
        if (!this.HumaxAdaption) {
            return bl;
        }
        if (byArray[0] != 127 || byArray[1] != 65 || byArray[2] != 4 || byArray[3] != -3) {
            return bl;
        }
        try {
            this.inputstream.skip(n - this.TS_BufferSize);
            this.inputstream.read(byArray, 0, this.TS_BufferSize);
            this.count += (long)n;
            return !bl;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
            return bl;
        }
    }

    private boolean skipLeadingKoscomDataChunk(byte[] byArray) {
        boolean bl = false;
        int n = 36;
        if (!this.KoscomAdaption) {
            return bl;
        }
        if (byArray[2] != 0 || byArray[3] != 0 || byArray[4] != 0 || byArray[36] != this.TS_SyncByte) {
            return bl;
        }
        try {
            if (this.Debug) {
                int n2 = CommonParsing.getIntValue(byArray, 0, 3, false);
                System.out.println("koscom hd chunk: " + n2);
            }
            this.inputstream.unread(byArray, n, this.TS_BufferSize - n);
            this.inputstream.read(byArray, 0, this.TS_BufferSize);
            this.count += (long)n;
            return !bl;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
            return bl;
        }
    }

    private boolean skipLeadingHandanDataChunk(byte[] byArray) {
        boolean bl = false;
        int n = 512;
        int n2 = this.TS_PacketLength;
        int n3 = this.TS_BufferSize;
        int n4 = this.hav_chunk.length;
        if (!this.HandanAdaption) {
            return bl;
        }
        if (byArray[0] != this.TS_SyncByte || byArray[188] == this.TS_SyncByte) {
            return bl;
        }
        while (n2 > 0) {
            int n5 = 0;
            while (n2 > 0 && byArray[n2] != this.hav_chunk[n5]) {
                --n2;
            }
            while (n2 > 0 && n5 < n4 && n2 + n5 < n3 && byArray[n2 + n5] == this.hav_chunk[n5]) {
                ++n5;
            }
            if (n5 <= 0) continue;
            if (n5 < n4 && n2 + n5 < n3) {
                --n2;
                continue;
            }
            try {
                this.inputstream.skip(n - (n3 - n2));
                this.inputstream.read(byArray, n2, n3 - n2);
                this.count += (long)n;
                return !bl;
            }
            catch (IOException iOException) {
                Common.setExceptionMessage(iOException);
                break;
            }
        }
        return bl;
    }

    private boolean skipHumaxDataChunk(byte[] byArray) {
        boolean bl = false;
        if (!this.HumaxAdaption) {
            return bl;
        }
        if (byArray[0] != this.TS_SyncByte || byArray[188] != 127) {
            return bl;
        }
        return !bl;
    }

    private boolean skipKoscomDataChunk(byte[] byArray) {
        boolean bl = false;
        int n = 36;
        if (!this.KoscomAdaption) {
            return bl;
        }
        if (byArray[188] == this.TS_SyncByte) {
            return bl;
        }
        try {
            this.inputstream.read(this.tmp_chunk, 0, n);
            if (this.tmp_chunk[2] == 0 && this.tmp_chunk[3] == 0 && this.tmp_chunk[35] == this.TS_SyncByte) {
                if (this.Debug) {
                    int n2 = (0xFF & this.tmp_chunk[1]) << 16 | (0xFF & this.tmp_chunk[0]) << 8 | 0xFF & byArray[188];
                    System.out.println("koscom hd chunk: " + n2);
                }
                byArray[188] = this.TS_SyncByte;
                this.count += (long)n;
                return !bl;
            }
            this.inputstream.unread(this.tmp_chunk, 0, n);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        return bl;
    }

    private long checkNextKoscomSegment(JobCollection jobCollection, int n, int n2) {
        if (!this.KoscomAdaption) {
            return 0L;
        }
        byte[] byArray = new byte[200];
        long l = 246496L;
        int n3 = 4;
        if (n < jobCollection.getPrimaryInputFileSegments() - 1) {
            try {
                ((XInputFile)jobCollection.getInputFile(n + 1)).randomAccessSingleRead(byArray, l);
                for (int i = 0; i < n3; ++i) {
                    if (byArray[i] == 0) continue;
                    return 0L;
                }
                if (byArray[n3 + this.TS_PacketLength - n2] == this.TS_SyncByte) {
                    return l + (long)n3;
                }
            }
            catch (IOException iOException) {
                Common.setExceptionMessage(iOException);
            }
        }
        return 0L;
    }
}

