/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;

public class CommonParsing {
    public static final boolean BYTEREORDERING = true;
    public static final int SECONDARY_PES_PARSER = 0;
    public static final int PRIMARY_PES_PARSER = 1;
    public static final int TS_PARSER = 2;
    public static final int PVA_PARSER = 3;
    public static final int ES_VIDEO_PARSER = 4;
    public static final int ES_AUDIO_PARSER = 5;
    public static final int ES_SUBPICTURE_PARSER = 6;
    public static final int Unsupported = 0;
    public static final int PES_AV_TYPE = 1;
    public static final int MPEG1PS_TYPE = 2;
    public static final int MPEG2PS_TYPE = 3;
    public static final int PVA_TYPE = 4;
    public static final int TS_TYPE = 5;
    public static final int PES_MPA_TYPE = 6;
    public static final int PES_PS1_TYPE = 7;
    public static final int ES_MPV_TYPE = 8;
    public static final int ES_MPA_TYPE = 9;
    public static final int ES_AC3_TYPE = 10;
    public static final int ES_AC3_A_TYPE = 11;
    public static final int ES_DTS_TYPE = 12;
    public static final int ES_DTS_A_TYPE = 13;
    public static final int ES_RIFF_TYPE = 14;
    public static final int ES_cRIFF_TYPE = 15;
    public static final int ES_SUP_TYPE = 16;
    public static final int ES_TYPE = 1;
    public static final int UNKNOWN = -1;
    public static final int AC3_AUDIO = 0;
    public static final int TELETEXT = 1;
    public static final int MPEG_AUDIO = 2;
    public static final int MPEG_VIDEO = 3;
    public static final int LPCM_AUDIO = 4;
    public static final int SUBPICTURE = 5;
    public static final int DTS_AUDIO = 6;
    public static final int WAV_AUDIO = 7;
    public static final int ACTION_UNDEFINED = -1;
    public static final int ACTION_DEMUX = 0;
    public static final int ACTION_TO_VDR = 1;
    public static final int ACTION_TO_M2P = 2;
    public static final int ACTION_TO_PVA = 3;
    public static final int ACTION_TO_TS = 4;
    public static final int ACTION_FILTER = 5;
    public static final int CUTMODE_BYTE = 0;
    public static final int CUTMODE_GOP = 1;
    public static final int CUTMODE_FRAME = 2;
    public static final int CUTMODE_PTS = 3;
    public static final int CUTMODE_TIME = 4;
    public static final int PICTURE_START_CODE = 0;
    public static final int SLICE_START_CODE_MIN = 1;
    public static final int SLICE_START_CODE_MAX = 175;
    public static final int USER_DATA_START_CODE = 178;
    public static final int SEQUENCE_HEADER_CODE = 179;
    public static final int EXTENSION_START_CODE = 181;
    public static final int SEQUENCE_END_CODE = 183;
    public static final int GROUP_START_CODE = 184;
    public static final int SYSTEM_END_CODE = 185;
    public static final int PACK_START_CODE = 186;
    public static final int SYSTEM_START_CODE = 187;
    public static final int PROGRAM_STREAM_MAP_CODE = 188;
    public static final int PRIVATE_STREAM_1_CODE = 189;
    public static final int PADDING_STREAM_CODE = 190;
    public static final int PRIVATE_STREAM_2_CODE = 191;
    public static final int ECM_STREAM_CODE = 240;
    public static final int EMM_STREAM_CODE = 241;
    public static final int DSM_CC_STREAM_CODE = 242;
    public static final int FRAME_I_TYPE = 1;
    public static final int FRAME_P_TYPE = 2;
    public static final int FRAME_B_TYPE = 3;
    public static final int FRAME_D_TYPE = 4;
    public static final int MAX_BITRATE_VALUE = 262143;
    private static int Pva_PidToExtract = -1;
    private static boolean Pva_PidExtraction = false;
    private static boolean InfoScan = false;
    private static boolean qbreak = false;
    private static boolean qpause = false;
    private static boolean _bool = false;
    private static int _cutcount = 0;
    private static double _videoframerate = 3600.0;
    private static long AudioProcessingFlags = 0L;

    private CommonParsing() {
    }

    public static boolean isInfoScan() {
        return InfoScan;
    }

    public static void setInfoScan(boolean bl) {
        InfoScan = bl;
    }

    public static boolean isProcessCancelled() {
        return qbreak;
    }

    public static void setProcessCancelled(boolean bl) {
        qbreak = bl;
    }

    public static boolean isProcessPausing() {
        return qpause;
    }

    public static void setProcessPausing(boolean bl) {
        qpause = bl;
    }

    public static long getAudioProcessingFlags() {
        return AudioProcessingFlags;
    }

    public static void setAudioProcessingFlags(long l) {
        AudioProcessingFlags = l;
    }

    public static double getVideoFramerate() {
        return _videoframerate;
    }

    public static void setVideoFramerate(double d) {
        _videoframerate = d;
    }

    public static int getCutCounter() {
        return _cutcount;
    }

    public static void setCutCounter(int n) {
        _cutcount = n;
    }

    public static boolean getCutStatus() {
        return _bool;
    }

    public static void setCutStatus(boolean bl) {
        _bool = bl;
    }

    public static boolean getPvaPidExtraction() {
        return Pva_PidExtraction;
    }

    public static void setPvaPidExtraction(boolean bl) {
        Pva_PidExtraction = bl;
    }

    public static int getPvaPidToExtract() {
        return Pva_PidToExtract;
    }

    public static void setPvaPidToExtract(int n) {
        Pva_PidToExtract = n;
    }

    public static long getPTSfromBytes(byte[] byArray, int n) {
        return CommonParsing.getPTSfromBytes(byArray, n, true);
    }

    public static long getPTSfromBytes(byte[] byArray, int n, boolean bl) {
        long l = (6 & byArray[n]) << 29 | (0xFF & byArray[n + 1]) << 22 | (0xFE & byArray[n + 2]) << 14 | (0xFF & byArray[n + 3]) << 7 | (0xFE & byArray[n + 4]) >>> 1;
        if (bl) {
            l &= 0xFFFFFFFFL;
        }
        return l;
    }

    public static long readPTS(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        long l = CommonParsing.getValue(byArray, n, n2, bl);
        if (bl2) {
            l &= 0xFFFFFFFFL;
        }
        return l;
    }

    public static void setValue(byte[] byArray, int n, int n2, boolean bl, long l) {
        int n3;
        for (n3 = 0; bl && n3 < n2; ++n3) {
            byArray[n3 + n] = (byte)(0xFFL & l >>> n3 * 8);
        }
        n3 = 0;
        int n4 = n2 - 1;
        while (!bl && n3 < n2) {
            byArray[n3 + n] = (byte)(0xFFL & l >>> n4 * 8);
            ++n3;
            --n4;
        }
    }

    public static long getValue(byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        long l = 0L;
        for (n3 = 0; bl && n3 < n2; ++n3) {
            l |= (0xFFL & (long)byArray[n3 + n]) << n3 * 8;
        }
        n3 = 0;
        int n4 = n2 - 1;
        while (!bl && n3 < n2) {
            l |= (0xFFL & (long)byArray[n3 + n]) << n4 * 8;
            ++n3;
            --n4;
        }
        return l;
    }

    public static int getIntValue(byte[] byArray, int n, int n2, boolean bl) {
        return (int)CommonParsing.getValue(byArray, n, n2, bl);
    }

    public static void setPES_PTSField(byte[] byArray, int n, long l) {
        byArray[9 + n] = (byte)(0x21L | 0xEL & l >>> 29);
        byArray[10 + n] = (byte)(0xFFL & l >>> 22);
        byArray[11 + n] = (byte)(1L | 0xFEL & l >>> 14);
        byArray[12 + n] = (byte)(0xFFL & l >>> 7);
        byArray[13 + n] = (byte)(1L | 0xFEL & l << 1);
    }

    public static void setPES_LengthField(byte[] byArray, int n, int n2) {
        byArray[4 + n] = (byte)(0xFF & n2 >>> 8);
        byArray[5 + n] = (byte)(0xFF & n2);
    }

    public static void setPES_IdField(byte[] byArray, int n, int n2) {
        byArray[3 + n] = (byte)(0xFF & n2);
    }

    public static void setPES_SubIdField(byte[] byArray, int n, int n2, int n3, int n4) {
        byArray[n2 + n3 + n] = (byte)(0xFF & n4);
    }

    public static int getPES_LengthField(byte[] byArray, int n) {
        int n2 = (0xFF & byArray[4 + n]) << 8 | 0xFF & byArray[5 + n];
        return n2;
    }

    public static int getPES_IdField(byte[] byArray, int n) {
        int n2 = 0xFF & byArray[3 + n];
        return n2;
    }

    public static int getPES_ExtensionLengthField(byte[] byArray, int n) {
        int n2 = 0xFF & byArray[8 + n];
        return n2;
    }

    public static boolean clearBit33ofPTS(byte[] byArray, int n) {
        if ((0x80 & byArray[7 + n]) != 0) {
            int n2 = 9 + n;
            byArray[n2] = (byte)(byArray[n2] & 0xFFFFFFF7);
            return true;
        }
        return false;
    }

    public static boolean clearBit33ofDTS(byte[] byArray, int n) {
        if ((0x40 & byArray[7 + n]) != 0) {
            int n2 = 14 + n;
            byArray[n2] = (byte)(byArray[n2] & 0xFFFFFFF7);
            return true;
        }
        return false;
    }

    public static int nextBits(byte[] byArray, int n, int n2) {
        int n3 = n >>> 3;
        int n4 = (0xFF & byArray[n3]) << 24 | (0xFF & byArray[n3 + 1]) << 16 | (0xFF & byArray[n3 + 2]) << 8 | 0xFF & byArray[n3 + 3];
        n4 <<= n & 7;
        return n4 >>>= 32 - n2;
    }

    public static int validateStartcode(byte[] byArray, int n) {
        if (byArray[2 + n] == 1) {
            if (byArray[1 + n] == 0 && byArray[n] == 0) {
                return 0;
            }
        } else if (byArray[2 + n] == 0) {
            if (byArray[1 + n] == 0) {
                return -1;
            }
            return -2;
        }
        return -3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean alignSyncword(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = CommonParsing.getPES_LengthField(byArray, n);
        int n5 = 9;
        int n6 = n5 - 3 + n4;
        int n7 = CommonParsing.getPES_ExtensionLengthField(byArray, n);
        int n8 = n5 + n7;
        boolean bl = false;
        int n9 = n6 - 3;
        int n10 = n8 + n;
        block5: for (n3 = n8; n3 < n9; ++n3, ++n10) {
            switch (n2) {
                case 3: {
                    if (byArray[n10] != 0 || byArray[1 + n10] != 0 || byArray[2 + n10] != 1 || byArray[3 + n10] != -77) break;
                    bl = true;
                    break block5;
                }
                case 0: 
                case 6: {
                    if (!(byArray[n10] == 11 && byArray[1 + n10] == 119 || byArray[n10] == 127 && byArray[1 + n10] == -2 && byArray[2 + n10] == -128 && byArray[3 + n10] == 1)) break;
                    bl = true;
                    break block5;
                }
                case 2: {
                    if (byArray[n10] != -1 || (0xF0 & byArray[1 + n10]) != 240) break;
                    bl = true;
                    break block5;
                }
            }
        }
        if (bl) {
            System.arraycopy(byArray, n3 + n, byArray, n8 + n, n6 - n3);
            CommonParsing.setPES_LengthField(byArray, n, n4 -= n3 - n8);
        }
        return bl;
    }

    public static void logAlias(JobProcessing jobProcessing, String string, String string2) {
        File file = new File(string);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
            randomAccessFile.seek(0L);
            if (file.exists() && file.length() > 0L) {
                RandomAccessFile randomAccessFile2 = new RandomAccessFile(string, "r");
                long l = randomAccessFile2.readLong();
                if (!jobProcessing.hasElementaryVideoStream() && jobProcessing.getSplitPart() == 0) {
                    jobProcessing.setFirstAudioPts(l);
                }
                randomAccessFile.writeLong(jobProcessing.getFirstAudioPts() + (Common.getSettings().getBooleanProperty(Keys.KEY_additionalOffset) ? 90L * (long)Common.getSettings().getIntProperty(Keys.KEY_ExportPanel_additionalOffset_Value) : 0L));
                randomAccessFile2.close();
            } else {
                randomAccessFile.writeLong(0L + (long)(Common.getSettings().getBooleanProperty(Keys.KEY_additionalOffset) ? Common.getSettings().getIntProperty(Keys.KEY_ExportPanel_additionalOffset_Value) : 0));
            }
            randomAccessFile.writeLong(0L);
            randomAccessFile.close();
            Common.setMessage("");
            Common.setMessage(Resource.getString("all.msg.pts.faked"));
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public static void resetSplitMode(JobProcessing jobProcessing, String string) {
        if (string.equals("-1") && jobProcessing.getSplitSize() > 0L) {
            jobProcessing.setSplitSize(0L);
            Common.setMessage(Resource.getString("splitreset.novideo"));
        }
    }

    public static String parseCutValue(long l) {
        if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 4) {
            return String.valueOf(l);
        }
        String string = "";
        long l2 = 1L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H:mm:ss:");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        calendar.setTime(new Date(l /= 90L));
        int n = calendar.get(14) / (int)l2;
        string = simpleDateFormat.format(new Date(l)) + (n < 10 ? "0" : "") + n;
        return string;
    }

    public static long parseCutValue(String string, boolean bl) {
        if (string == null) {
            return 0L;
        }
        string = string.trim();
        try {
            if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 4) {
                return Long.parseLong(string);
            }
        }
        catch (Exception exception) {
            return -1L;
        }
        int n = string.indexOf(" ");
        if (n > -1) {
            string = string.substring(0, n);
        }
        if ((string = string.replace('.', ':')).indexOf(":") < 0) {
            return Long.parseLong(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = null;
        long l = 0L;
        long l2 = !bl ? 90L : (long)_videoframerate;
        long[] lArray = new long[]{324000000L, 5400000L, 90000L, l2};
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < 4; ++i) {
            string2 = stringTokenizer.nextToken();
            l += lArray[i] * Long.parseLong(string2);
        }
        return l;
    }

    public static long calcVideoTime(String string) {
        long l = 0L;
        try {
            long l2 = new File(string).length();
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            randomAccessFile.seek(l2 - 8L);
            l = randomAccessFile.readLong();
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        return l;
    }

    public static boolean makecut(JobProcessing jobProcessing, long l, List list) {
        return CommonParsing.makecut(jobProcessing, null, 0L, l, new ArrayList(), 0, list, 0, new ArrayList());
    }

    public static boolean makecut(JobProcessing jobProcessing, String string, long l, long l2, List list, int n, List list2, int n2, List list3) {
        if (list2.isEmpty()) {
            return true;
        }
        if (_cutcount < list2.size()) {
            if (l2 > CommonParsing.parseCutValue(list2.get(_cutcount).toString(), true)) {
                if ((_cutcount & 1) == 1) {
                    _bool = false;
                    for (int i = list.size() - 1; i > -1; --i) {
                        long[] lArray = (long[])list.get(i);
                        if (lArray[0] >= CommonParsing.parseCutValue(list2.get(_cutcount).toString(), true)) continue;
                        _bool = true;
                        Common.setMessage(Resource.getString("msg.cuts.cutin", "" + n2, "" + n, "" + Common.formatTime_1((long)((double)n * (_videoframerate / 90.0)))) + " (" + l2 + ")");
                        CommonParsing.saveCuts(l2, l, n, string);
                        break;
                    }
                    if (!_bool) {
                        Common.setMessage(Resource.getString("msg.cuts.cutout", "" + n2) + " (" + l2 + ")");
                        CommonParsing.saveCuts(l2, l, n, string);
                    }
                    ++_cutcount;
                    return _bool;
                }
                _bool = true;
                Common.setMessage(Resource.getString("msg.cuts.cutin", "" + n2, "" + n, "" + Common.formatTime_1((long)((double)n * (_videoframerate / 90.0)))) + " (" + l2 + ")");
                CommonParsing.saveCuts(l2, l, n, string);
                if (++_cutcount >= list2.size()) {
                    return _bool;
                }
                for (int i = list.size() - 1; i > -1; --i) {
                    long[] lArray = (long[])list.get(i);
                    if (lArray[0] >= CommonParsing.parseCutValue(list2.get(_cutcount).toString(), true)) continue;
                    ++_cutcount;
                    break;
                }
                return _bool;
            }
        } else if (!_bool && jobProcessing.getCutComparePoint() == 10000000L) {
            jobProcessing.setCutComparePoint(l2);
        }
        return _bool;
    }

    private static void saveCuts(long l, long l2, long l3, String string) {
        if (Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_exportPts) && string != null) {
            try {
                string = string + ".Xpl";
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(string, l3 > 0L));
                if (new File(string).length() == 0L) {
                    printWriter.println(Keys.KEY_CutMode[0] + "=3");
                }
                printWriter.println(l2);
                printWriter.close();
                Common.setMessage(Resource.getString("msg.savecut", "" + l2));
            }
            catch (IOException iOException) {
                Common.setExceptionMessage(iOException);
            }
        }
    }

    public static void setVideoHeader(JobProcessing jobProcessing, String string, String string2, int[] nArray, int[] nArray2) {
        Object object;
        long l = 0L;
        String[] stringArray = new String[]{"(m1v)", "(m2v)"};
        String[] stringArray2 = new String[]{Resource.getString("video.msg.io.non"), Resource.getString("video.msg.io.int"), Resource.getString("video.msg.io.pro"), Resource.getString("video.msg.io.int_pro")};
        if (new File(string2).exists()) {
            l = CommonParsing.calcVideoTime(string2) / 90L;
            object = Common.formatTime_1(l / 10L * 10L);
            Common.setMessage(Resource.getString("video.msg.length", "" + jobProcessing.getExportedVideoFrameNumber()) + " " + (String)object);
            Common.setMessage(Resource.getString("video.msg.gop.summary", "" + (Short.MAX_VALUE & nArray[9] >>> 15), "" + (Short.MAX_VALUE & nArray[9]), "" + stringArray2[nArray[9] >>> 30]));
            if (nArray[8] > 0) {
                Common.setMessage(Resource.getString("video.error.pts.same", "" + nArray[8]));
            }
            jobProcessing.getSummaryInfo().add(Resource.getString("video.summary", stringArray[nArray2[0]], "" + jobProcessing.getExportedVideoFrameNumber(), "" + (String)object) + "'" + string + "'");
        }
        try {
            int n;
            object = new RandomAccessFile(string, "rw");
            if (Common.getSettings().getIntProperty(Keys.KEY_ChangeBitrateInAllSequences) > 0) {
                if (l == 0L) {
                    Common.setMessage(Resource.getString("video.msg.bitrate.avg", "" + (jobProcessing.getMinBitrate() + jobProcessing.getMaxBitrate()) / 2 * 400, "" + jobProcessing.getMinBitrate() * 400 + "/" + jobProcessing.getMaxBitrate() * 400));
                } else {
                    Common.setMessage(Resource.getString("video.msg.bitrate.avgnom", "" + ((RandomAccessFile)object).length() * 8000L / l, "" + jobProcessing.getMinBitrate() * 400 + "/" + jobProcessing.getMaxBitrate() * 400));
                }
            } else if (Common.getSettings().getBooleanProperty(Keys.KEY_DebugLog)) {
                System.out.println();
            }
            if (!Common.getSettings().getBooleanProperty(Keys.KEY_WriteOptions_writeVideo)) {
                ((RandomAccessFile)object).close();
                return;
            }
            int n2 = 22500;
            if (Common.getSettings().getIntProperty(Keys.KEY_ChangeBitrateInFirstSequence) > 0) {
                int n3 = n = Common.getSettings().getIntProperty(Keys.KEY_ChangeBitrateInFirstSequence) == 3 ? jobProcessing.getMaxBitrate() : n2;
                if (Common.getSettings().getIntProperty(Keys.KEY_ChangeBitrateInFirstSequence) == 2 && jobProcessing.getMaxBitrate() < n2) {
                    n = jobProcessing.getMaxBitrate();
                }
                if (Common.getSettings().getIntProperty(Keys.KEY_ChangeBitrateInFirstSequence) == 1) {
                    if (l == 0L) {
                        n = (jobProcessing.getMinBitrate() + jobProcessing.getMaxBitrate()) / 2;
                    } else {
                        n = (int)(((RandomAccessFile)object).length() * 8000L / l / 400L);
                        if (n < 0 || n > n2) {
                            n = (jobProcessing.getMinBitrate() + jobProcessing.getMaxBitrate()) / 2;
                        }
                    }
                }
                if (Common.getSettings().getIntProperty(Keys.KEY_ChangeBitrateInFirstSequence) == 4) {
                    n = 262143;
                    Common.setMessage(Resource.getString("video.msg.bitrate.vbr"));
                } else {
                    Common.setMessage(Resource.getString("video.msg.bitrate.val", "" + n * 400));
                }
                ((RandomAccessFile)object).seek(8L);
                n = n << 14 | ((RandomAccessFile)object).readInt() << 18 >>> 18;
                ((RandomAccessFile)object).seek(8L);
                ((RandomAccessFile)object).writeInt(n);
            }
            if (Common.getSettings().getIntProperty(Keys.KEY_ConditionalHorizontalPatch) != 0) {
                boolean bl;
                ((RandomAccessFile)object).seek(4L);
                n = ((RandomAccessFile)object).readInt();
                int n4 = n >>> 20;
                int n5 = 0xFFFFF & n | Common.getSettings().getIntProperty(Keys.KEY_ConditionalHorizontalResolution) << 20;
                switch (Common.getSettings().getIntProperty(Keys.KEY_ConditionalHorizontalPatch)) {
                    case 2: {
                        bl = n4 != 720 && n4 != 352;
                        break;
                    }
                    case 3: {
                        bl = n4 != 720 && n4 != 704 && n4 != 352;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ((RandomAccessFile)object).seek(4L);
                    ((RandomAccessFile)object).writeInt(n5);
                    Common.setMessage(Resource.getString("video.msg.resolution", "" + (n >>> 20) + "*" + ((0xFFF00 & n) >>> 8)) + " " + (n5 >>> 20) + "*" + ((0xFFF00 & n5) >>> 8));
                }
            }
            ((RandomAccessFile)object).close();
            Common.setMessage(Resource.getString("msg.newfile") + " " + string);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public static int getExtension2_Id(byte[] byArray, int n, int n2, int n3, boolean bl, long l) {
        boolean bl2 = false;
        int n4 = -1;
        if (!bl) {
            return n4;
        }
        if (n3 != 189 && (0xE0 & n3) != 192 && (0xF0 & n3) != 224) {
            return n4;
        }
        int n5 = n;
        n5 += (0x80 & byArray[7]) != 0 ? 5 : 0;
        n5 += (0x40 & byArray[7]) != 0 ? 5 : 0;
        n5 += (0x20 & byArray[7]) != 0 ? 6 : 0;
        n5 += (0x10 & byArray[7]) != 0 ? 3 : 0;
        n5 += (4 & byArray[7]) != 0 ? 1 : 0;
        boolean bl3 = (1 & byArray[7]) != 0;
        boolean bl4 = false;
        int n6 = 0xFF & byArray[8];
        if (n + n6 < (n5 += (2 & byArray[7]) != 0 ? 2 : 0)) {
            bl2 = true;
        } else if (bl3 && n + n6 < n5 + 1) {
            bl2 = true;
        } else if (bl3) {
            int n7 = n5;
            if (6 + n2 < n5 + 1) {
                bl2 = true;
            } else {
                n5 += (0x80 & byArray[n7]) != 0 ? 16 : 0;
                n5 += (0x40 & byArray[n7]) != 0 ? 1 : 0;
                n5 += (0x20 & byArray[n7]) != 0 ? 2 : 0;
                n5 += (0x10 & byArray[n7]) != 0 ? 2 : 0;
                boolean bl5 = bl4 = (1 & byArray[n7]) != 0;
                if (n + n6 < ++n5) {
                    bl2 = true;
                } else if (bl4) {
                    int n8;
                    if (6 + n2 < ++n5 + (n8 = 0x7F & byArray[n5])) {
                        bl2 = true;
                    } else if (n + n6 < n5 + n8) {
                        bl2 = true;
                    } else if (n3 == 189) {
                        n4 = 0xFF & byArray[n5];
                    }
                }
            }
        }
        if (bl2) {
            Common.setMessage("!> error in pes_extension of pes-ID 0x" + Integer.toHexString(n3).toUpperCase() + " @ pos: " + l + " (" + (6 + n2) + " / " + (n + n6) + " / " + (n5 + 1) + " / " + bl3 + " / " + bl4 + ")");
        }
        return n4;
    }
}

