/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.ColumnLayout;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.MainFrame;

public class StartUp
extends JFrame {
    private final Color BACKGROUND_COLOR = new Color(200, 200, 200);
    private boolean agreement = false;
    private JButton agree;
    private JProgressBar progressBar;
    private JLabel progress;
    private JLabel message;

    public StartUp() {
        this.open(Resource.getString("StartUp.Title"));
    }

    public StartUp(String string) {
        this.open(string);
    }

    protected void open(String string) {
        this.setTitle(string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(this.BACKGROUND_COLOR);
        jPanel.add(this.buildUpperPanel());
        jPanel.add(this.buildHLinePanel());
        jPanel.add(this.buildLoadPanel());
        jPanel.add(this.buildHLinePanel());
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel.add(this.buildButtonPanel());
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel2.setBackground(this.BACKGROUND_COLOR);
        jPanel2.add(jPanel);
        this.getContentPane().add(jPanel2);
        this.pack();
        this.setLocation(200, 200);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Common.exitApplication(0);
            }
        });
    }

    protected JPanel buildUpperPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(224, 224, 224));
        jPanel.setLayout(new ColumnLayout());
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        jPanel.add(new JLabel("  " + Resource.getString("StartUp.Init")));
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        this.message = new JLabel("  " + Resource.getString("StartUp.Wait"));
        jPanel.add(this.message);
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(new Color(224, 224, 224));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel(CommonGui.loadIcon("px.gif")), "East");
        jPanel2.add((Component)jPanel, "West");
        return jPanel2;
    }

    protected JPanel buildHLinePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new ColumnLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    protected JPanel buildLoadPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.BACKGROUND_COLOR);
        jPanel.setLayout(new ColumnLayout());
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        this.progress = new JLabel("Start...");
        jPanel.add(this.progress);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(0);
        this.progressBar.setPreferredSize(new Dimension(500, 24));
        this.progressBar.setForeground(new Color(20, 240, 20));
        jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        jPanel.add(this.progressBar);
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        String[] stringArray = Resource.getStringByLines("terms");
        for (int i = 0; i < stringArray.length; ++i) {
            jPanel.add(new JLabel(stringArray[i]));
        }
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        return jPanel;
    }

    protected JPanel buildButtonPanel() {
        JButton jButton = new JButton();
        CommonGui.localize(jButton, "Common.Cancel");
        jButton.setActionCommand("disagree");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.exitApplication(0);
            }
        });
        JButton jButton2 = new JButton(Resource.getString("terms.disagree"));
        jButton2.setActionCommand("disagree");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.exitApplication(0);
            }
        });
        this.agree = new JButton(Resource.getString("terms.agree"));
        this.agree.setActionCommand("agree");
        this.agree.setEnabled(false);
        this.agree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!StartUp.this.agree.isEnabled()) {
                    return;
                }
                StartUp.this.setVisible(false);
                Common.getSettings().setProperty(Keys.KEY_Agreement[0], "1");
                MainFrame.setVisible0(true);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.BACKGROUND_COLOR);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.agree);
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(this.BACKGROUND_COLOR);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)jButton, "East");
        return jPanel2;
    }

    public void set(boolean bl) {
        this.agree.setEnabled(!bl);
        this.agreement = bl;
        this.agree.setSelected(this.agreement);
        if (this.agreement) {
            this.agree.setForeground(Color.green);
        } else {
            this.message.setText("  " + Resource.getString("StartUp.Choose"));
        }
    }

    public boolean get() {
        return this.agree.isSelected();
    }

    public void setProgress(int n, String string) {
        this.progress.setText(string);
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(n);
        System.out.println(string);
    }

    public void close() {
        this.dispose();
    }
}

