/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.CheckBoxListener;
import net.sourceforge.dvb.projectx.gui.ComboBoxIndexListener;
import net.sourceforge.dvb.projectx.gui.ComboBoxItemListener;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.TextFieldKeyListener;
import net.sourceforge.dvb.projectx.gui.TextFieldListener;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class FileProperties
extends JFrame {
    private String title = Resource.getString("General.FileProperties");
    private final Color head_color = new Color(224, 224, 224);
    private ComboBoxIndexListener _ComboBoxIndexListener = new ComboBoxIndexListener();
    private ComboBoxItemListener _ComboBoxItemListener = new ComboBoxItemListener();
    private CheckBoxListener _CheckBoxListener = new CheckBoxListener();
    private TextFieldListener _TextFieldListener = new TextFieldListener();
    private TextFieldKeyListener _TextFieldKeyListener = new TextFieldKeyListener();

    public FileProperties() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FileProperties.this.close();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.buildMenu();
        jPanel.add(this.buildTabPanel());
        this.getContentPane().add(jPanel);
        this.setTitle(this.title);
        this.setBounds(200, 100, 720, 400);
        this.setResizable(false);
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    protected void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        this.setJMenuBar(jMenuBar);
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.File");
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "Common.Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileProperties.this.close();
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JPanel buildTabPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        JTabbedPane jTabbedPane = new JTabbedPane(2);
        jTabbedPane.addTab("Main", this.buildMainPanel());
        jTabbedPane.setSelectedIndex(0);
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    protected JPanel buildHeadPanel(JPanel jPanel, String string) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(this.head_color);
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel2.add(new JLabel(" " + string));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "North");
        return jPanel3;
    }

    protected JPanel buildMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        return jPanel;
    }

    public void close() {
        this.dispose();
    }

    public void open(XInputFile xInputFile, int n) {
        this.show();
    }
}

