/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.CheckBoxListener;
import net.sourceforge.dvb.projectx.gui.ColumnLayout;
import net.sourceforge.dvb.projectx.gui.ComboBoxIndexListener;
import net.sourceforge.dvb.projectx.gui.ComboBoxItemListener;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.CutView;
import net.sourceforge.dvb.projectx.gui.X_JFileChooser;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.video.Preview;
import net.sourceforge.dvb.projectx.video.PreviewObject;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class CollectionPanel
extends JPanel {
    private X_JFileChooser chooser;
    private JList includeList;
    private JSlider slider;
    private JTextField includeField;
    private JTextField cutfield;
    private JTextField chapterfield;
    private JTextField pointslength;
    private JTextField chp;
    private JTextField firstfile;
    private JTextField scannedPID;
    private JLabel titleLabel;
    private JButton cutdel;
    private JButton cutadd;
    private JButton chapterdel;
    private JButton chapteradd;
    private JButton loadlist;
    private JButton savelist;
    private JComboBox cut_combobox;
    private JComboBox chapter_combobox;
    private JComboBox cutmode_combobox;
    private JTabbedPane tabbedPane;
    private List previewList = new ArrayList();
    private DNDListener2 dnd2 = new DNDListener2();
    private CutListener cutAction = new CutListener();
    private JumpListener jumpAction = new JumpListener();
    private boolean action = false;
    private boolean decode = false;
    private String file = " ";
    private String title = "";
    private String[] navigation = new String[]{"bwd_ncp.gif", "bwd_100.gif", "bwd_10.gif", "bwd_gop.gif", "fwd_gop.gif", "fwd_10.gif", "fwd_100.gif", "fwd_ncp.gif"};
    private int filetype = 0;
    private int active_collection = 0;
    private int loadSizeForward = 2560000;
    private long lastPosition = 0L;
    private Preview Preview = new Preview(this.loadSizeForward);
    private JobCollection collection;
    private CutView cutview;
    private SlideShow cl = new SlideShow();
    private boolean slideshow = false;
    ComboBoxIndexListener _ComboBoxIndexListener = new ComboBoxIndexListener();
    ComboBoxItemListener _ComboBoxItemListener = new ComboBoxItemListener();
    CheckBoxListener _CheckBoxListener = new CheckBoxListener();

    public CollectionPanel() {
        this.initialize();
    }

    protected JPanel buildRightPanel() {
        JPanel jPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(3);
        this.tabbedPane.addTab("Settings", this.buildPanel_1());
        this.tabbedPane.addTab("CutViews", this.buildPanel_2());
        final String[] stringArray = Keys.KEY_OptionPanelIndex;
        int n = Common.getSettings().getIntProperty(stringArray);
        if (n >= 0 && n < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(n);
        }
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Common.getSettings().setProperty(stringArray[0], String.valueOf(CollectionPanel.this.tabbedPane.getSelectedIndex()));
            }
        });
        jPanel.add((Component)this.tabbedPane, "Center");
        return jPanel;
    }

    protected JPanel buildPanel_1() {
        int n;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new ColumnLayout());
        String[][] stringArrayArray = new String[][]{Keys.KEY_Preview_disable, Keys.KEY_Preview_fastDecode, Keys.KEY_Preview_LiveUpdate, Keys.KEY_Preview_AllGops, Keys.KEY_OptionHorizontalResolution, Keys.KEY_OptionDAR};
        JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        for (n = 0; n < stringArrayArray.length; ++n) {
            jCheckBoxArray[n] = new JCheckBox(Resource.getString(stringArrayArray[n][0]));
            jCheckBoxArray[n].setPreferredSize(new Dimension(220, 20));
            jCheckBoxArray[n].setMaximumSize(new Dimension(220, 20));
            jCheckBoxArray[n].setToolTipText(Resource.getString(stringArrayArray[n][0] + ".Tip"));
            jCheckBoxArray[n].setActionCommand(stringArrayArray[n][0]);
            jCheckBoxArray[n].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[n]));
            jCheckBoxArray[n].addActionListener(this._CheckBoxListener);
        }
        for (n = 0; n < 4; ++n) {
            jPanel.add(jCheckBoxArray[n]);
        }
        jPanel.add(Box.createRigidArea(new Dimension(1, 4)));
        jPanel.add(new JLabel(Resource.getString("CollectionPanel.ExportLimits")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jCheckBoxArray[4].setPreferredSize(new Dimension(110, 20));
        jCheckBoxArray[4].setMaximumSize(new Dimension(110, 20));
        jPanel2.add(jCheckBoxArray[4]);
        JComboBox<Object> jComboBox = new JComboBox<Object>(Keys.ITEMS_ExportHorizontalResolution);
        jComboBox.setMaximumRowCount(7);
        jComboBox.setPreferredSize(new Dimension(90, 20));
        jComboBox.setMaximumSize(new Dimension(90, 20));
        jComboBox.setActionCommand(Keys.KEY_ExportHorizontalResolution[0]);
        jComboBox.setEditable(true);
        jComboBox.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_ExportHorizontalResolution));
        jComboBox.addActionListener(this._ComboBoxItemListener);
        jPanel2.add(jComboBox);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jCheckBoxArray[5].setPreferredSize(new Dimension(80, 20));
        jCheckBoxArray[5].setMaximumSize(new Dimension(80, 20));
        jPanel3.add(jCheckBoxArray[5]);
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(Keys.ITEMS_ExportDAR);
        jComboBox2.setMaximumRowCount(7);
        jComboBox2.setPreferredSize(new Dimension(120, 20));
        jComboBox2.setMaximumSize(new Dimension(120, 20));
        jComboBox2.setActionCommand(Keys.KEY_ExportDAR[0]);
        jComboBox2.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_ExportDAR));
        jComboBox2.addActionListener(this._ComboBoxIndexListener);
        jPanel3.add(jComboBox2);
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(new Dimension(1, 4)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resource.getString("CollectionPanel.PidList")));
        this.includeField = new JTextField("");
        this.includeField.setPreferredSize(new Dimension(80, 25));
        this.includeField.setMaximumSize(new Dimension(80, 25));
        this.includeField.setEditable(true);
        this.includeField.setActionCommand("ID");
        this.includeField.setToolTipText(Resource.getString("CollectionPanel.PidList.Tip1"));
        this.includeList = new JList();
        this.includeList.setToolTipText(Resource.getString("CollectionPanel.PidList.Tip2"));
        jPanel4.add(this.includeField);
        this.includeField.addActionListener(this.cutAction);
        jPanel4.add(new JLabel("=>"));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(80, 100));
        jScrollPane.setMaximumSize(new Dimension(80, 100));
        jScrollPane.setViewportView(this.includeList);
        jPanel4.add(jScrollPane);
        this.includeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (CollectionPanel.this.collection == null) {
                    return;
                }
                if (mouseEvent.getClickCount() >= 2) {
                    Object[] objectArray = CollectionPanel.this.includeList.getSelectedValues();
                    CollectionPanel.this.collection.removePID(objectArray);
                    CollectionPanel.this.includeList.setListData(CollectionPanel.this.collection.getPIDs());
                }
            }
        });
        jPanel.add(jPanel4);
        jPanel.add(Box.createRigidArea(new Dimension(1, 4)));
        JButton jButton = new JButton(Resource.getString("CollectionPanel.transferPids1"));
        jButton.setPreferredSize(new Dimension(220, 20));
        jButton.setMaximumSize(new Dimension(220, 20));
        jButton.setActionCommand("transferPIDs");
        jButton.setToolTipText(Resource.getString("CollectionPanel.transferPids1.Tip"));
        jButton.addActionListener(this.cutAction);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(Resource.getString("CollectionPanel.transferPids2"));
        jButton2.setPreferredSize(new Dimension(220, 20));
        jButton2.setMaximumSize(new Dimension(220, 20));
        jButton2.setActionCommand("transferCuts");
        jButton2.setToolTipText(Resource.getString("CollectionPanel.transferPids2.Tip"));
        jButton2.addActionListener(this.cutAction);
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(new Dimension(1, 6)));
        return jPanel;
    }

    protected JPanel buildPanel_2() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.cutview = new CutView();
        jPanel.add(this.cutview);
        return jPanel;
    }

    protected void setComponentColor(JComponent jComponent, Color color) {
        jComponent.setBackground(color);
        jComponent.setForeground(color);
    }

    private void initialize() {
        this.chooser = CommonGui.getMainFileChooser();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), Resource.getString("CollectionPanel.CutPanel")));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setToolTipText(Resource.getString("CollectionPanel.CutPanel.Tip1"));
        jPanel2.add(CommonGui.getPicturePanel());
        this.slider = new JSlider(0, 640000, 0);
        this.slider.setPreferredSize(new Dimension(512, 24));
        this.slider.setMaximumSize(new Dimension(512, 24));
        this.slider.setValue(0);
        this.slider.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (CollectionPanel.this.slideshow || CollectionPanel.this.previewList.isEmpty() || Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 0) {
                    CollectionPanel.this.slideshow = false;
                    return;
                }
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                CollectionPanel.this.slideshow = true;
                CollectionPanel.this.cl.start(CollectionPanel.this.lastPosition);
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.buildCutPointPanel());
        jPanel3.add(this.buildChapterPointPanel());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 2));
        jPanel4.add(this.buildNavigationPanel());
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel5.add(this.slider);
        jPanel5.add((Component)jPanel4, "South");
        jPanel2.add((Component)jPanel5, "South");
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (CollectionPanel.this.collection == null) {
                    return;
                }
                if (!CollectionPanel.this.action) {
                    return;
                }
                if (CollectionPanel.this.slider.getValueIsAdjusting() && !Common.getSettings().getBooleanProperty(Keys.KEY_Preview_LiveUpdate)) {
                    return;
                }
                long l = (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0 ? 16L : 1L) * (long)CollectionPanel.this.slider.getValue();
                if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0 && l != (CollectionPanel.this.lastPosition & 0xFFFFFFFFFFFFFFF0L)) {
                    CollectionPanel.this.preview(l);
                } else if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 0) {
                    CollectionPanel.this.scannedPID.setText(Resource.getString("CollectionPanel.Preview.offline"));
                }
                CollectionPanel.this.getType();
            }
        });
        this.slider.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (CollectionPanel.this.collection == null) {
                    return;
                }
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = keyEvent.getKeyCode();
                switch (keyEvent.getKeyChar()) {
                    case 'p': {
                        n2 = CollectionPanel.this.cut_combobox.getItemCount();
                        if (n2 > 0) {
                            n = n2 - 1;
                            if (CollectionPanel.this.lastPosition > Long.parseLong(CollectionPanel.this.cut_combobox.getItemAt(0).toString())) {
                                while (CollectionPanel.this.lastPosition <= Long.parseLong(CollectionPanel.this.cut_combobox.getItemAt(n).toString())) {
                                    --n;
                                }
                            }
                            CollectionPanel.this.cut_combobox.setSelectedIndex(n);
                        }
                        return;
                    }
                    case 'n': {
                        n2 = CollectionPanel.this.cut_combobox.getItemCount();
                        if (n2 > 0) {
                            if (CollectionPanel.this.lastPosition < Long.parseLong(CollectionPanel.this.cut_combobox.getItemAt(n2 - 1).toString())) {
                                while (CollectionPanel.this.lastPosition >= Long.parseLong(CollectionPanel.this.cut_combobox.getItemAt(n).toString())) {
                                    ++n;
                                }
                            }
                            CollectionPanel.this.cut_combobox.setSelectedIndex(n);
                        }
                        return;
                    }
                    case 'a': {
                        CollectionPanel.this.cutadd.doClick();
                        return;
                    }
                    case 'd': {
                        CollectionPanel.this.cutdel.doClick();
                        return;
                    }
                }
                if (keyEvent.isShiftDown()) {
                    n3 = 62500;
                } else if (keyEvent.isControlDown()) {
                    n3 = 312500;
                } else if (keyEvent.isAltDown()) {
                    n3 = 3125000;
                } else {
                    return;
                }
                switch (n4) {
                    case 39: {
                        CollectionPanel.this.slider.setValue(CollectionPanel.this.slider.getValue() + n3);
                        break;
                    }
                    case 37: {
                        CollectionPanel.this.slider.setValue(CollectionPanel.this.slider.getValue() - n3);
                    }
                }
            }
        });
        jPanel.add(jPanel2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resource.getString("CollectionPanel.Various")));
        jPanel6.setLayout(new ColumnLayout());
        this.titleLabel = new JLabel("");
        this.titleLabel.setPreferredSize(new Dimension(230, 22));
        this.titleLabel.setMaximumSize(new Dimension(230, 22));
        jPanel6.add(this.buildRightPanel());
        this.cutmode_combobox = new JComboBox<Object>(Keys.ITEMS_CutMode);
        this.cutmode_combobox.setPreferredSize(new Dimension(230, 22));
        this.cutmode_combobox.setMaximumSize(new Dimension(230, 22));
        this.cutmode_combobox.setActionCommand(Keys.KEY_CutMode[0]);
        this.cutmode_combobox.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_CutMode));
        this.cutmode_combobox.addActionListener(this._ComboBoxIndexListener);
        jPanel6.add(this.cutmode_combobox);
        this.loadlist = new JButton(Resource.getString("CollectionPanel.loadCutpointList"));
        this.loadlist.setPreferredSize(new Dimension(230, 22));
        this.loadlist.setMaximumSize(new Dimension(230, 22));
        this.loadlist.setToolTipText(Resource.getString("CollectionPanel.loadCutpointList.Tip"));
        this.loadlist.setActionCommand("loadlist");
        this.loadlist.addActionListener(this.jumpAction);
        this.savelist = new JButton(Resource.getString("CollectionPanel.saveCutpointList"));
        this.savelist.setPreferredSize(new Dimension(230, 22));
        this.savelist.setMaximumSize(new Dimension(230, 22));
        this.savelist.setActionCommand("savelist");
        this.savelist.addActionListener(this.jumpAction);
        jPanel6.add(this.loadlist);
        jPanel6.add(this.savelist);
        DropTarget dropTarget = new DropTarget(this.loadlist, this.dnd2);
        DropTarget dropTarget2 = new DropTarget(this.cutfield, this.dnd2);
        jPanel.add((Component)jPanel6, "East");
        this.add(jPanel);
        this.setTitle(Resource.getString("CollectionPanel.Title2"));
    }

    protected JPanel buildNavigationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton[] jButtonArray = new JButton[this.navigation.length];
        for (int i = 0; i < jButtonArray.length; ++i) {
            jButtonArray[i] = new JButton(CommonGui.loadIcon(this.navigation[i]));
            jButtonArray[i].setPreferredSize(new Dimension(31, 22));
            jButtonArray[i].setMaximumSize(new Dimension(31, 22));
            jButtonArray[i].setActionCommand(this.navigation[i]);
            jButtonArray[i].addActionListener(this.jumpAction);
            jPanel.add(jButtonArray[i]);
        }
        this.firstfile = new JTextField(this.file);
        this.firstfile.setToolTipText(Resource.getString("CollectionPanel.CutPanel.Tip2"));
        this.firstfile.setBackground(new Color(230, 230, 230));
        this.firstfile.setEditable(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 1));
        jPanel2.setPreferredSize(new Dimension(248, 22));
        jPanel2.setMaximumSize(new Dimension(248, 22));
        jPanel2.setMinimumSize(new Dimension(248, 22));
        jPanel2.add(this.firstfile);
        this.scannedPID = new JTextField("");
        this.scannedPID.setToolTipText(Resource.getString("CollectionPanel.CutPanel.Tip3"));
        this.scannedPID.setBackground(new Color(230, 230, 230));
        this.scannedPID.setEditable(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 1));
        jPanel3.setPreferredSize(new Dimension(248, 22));
        jPanel3.setMaximumSize(new Dimension(248, 22));
        jPanel3.setMinimumSize(new Dimension(248, 22));
        jPanel3.add(this.scannedPID);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new ColumnLayout());
        jPanel4.add(jPanel);
        jPanel4.add(jPanel3);
        jPanel4.add(jPanel2);
        return jPanel4;
    }

    protected JPanel buildCutPointPanel() {
        this.cutadd = new JButton(CommonGui.loadIcon("add.gif"));
        this.cutadd.setActionCommand("addpoint");
        this.cutadd.setPreferredSize(new Dimension(34, 22));
        this.cutadd.setMaximumSize(new Dimension(34, 22));
        this.cutfield = new JTextField("");
        this.cutfield.setPreferredSize(new Dimension(112, 22));
        this.cutfield.setMaximumSize(new Dimension(112, 22));
        this.cutfield.setToolTipText(Resource.getString("CollectionPanel.CutPanel.Tip4"));
        this.cutfield.setActionCommand("cutnumber");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.cutadd);
        jPanel.add(this.cutfield);
        this.cutdel = new JButton(CommonGui.loadIcon("rem.gif"));
        this.cutdel.setActionCommand("delpoint");
        this.cutdel.setPreferredSize(new Dimension(34, 22));
        this.cutdel.setMaximumSize(new Dimension(34, 22));
        this.cut_combobox = new JComboBox();
        this.cut_combobox.setMaximumRowCount(8);
        this.cut_combobox.setPreferredSize(new Dimension(112, 22));
        this.cut_combobox.setMaximumSize(new Dimension(112, 22));
        this.cut_combobox.setActionCommand("cutbox");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.cutdel);
        jPanel2.add(this.cut_combobox);
        this.pointslength = new JTextField(Resource.getString("CollectionPanel.NumberOfPoints"));
        this.pointslength.setToolTipText(Resource.getString("CollectionPanel.NumberOfPoints.Tip"));
        this.pointslength.setBackground(new Color(230, 230, 230));
        this.pointslength.setEditable(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 1));
        jPanel3.setPreferredSize(new Dimension(146, 22));
        jPanel3.setMaximumSize(new Dimension(146, 22));
        jPanel3.setMinimumSize(new Dimension(146, 22));
        jPanel3.add(this.pointslength);
        this.cutdel.addActionListener(this.cutAction);
        this.cutadd.addActionListener(this.cutAction);
        this.cut_combobox.addActionListener(this.cutAction);
        this.cutfield.addActionListener(this.cutAction);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new ColumnLayout());
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        Color color = new Color(200, 150, 200);
        this.setComponentColor(this.cutadd, color);
        this.setComponentColor(this.cutdel, color);
        this.setComponentColor(jPanel4, color);
        return jPanel4;
    }

    protected JPanel buildChapterPointPanel() {
        this.chapteradd = new JButton(CommonGui.loadIcon("add.gif"));
        this.chapteradd.setActionCommand("addchapter");
        this.chapteradd.setPreferredSize(new Dimension(34, 22));
        this.chapteradd.setMaximumSize(new Dimension(34, 22));
        this.chapterdel = new JButton(CommonGui.loadIcon("rem.gif"));
        this.chapterdel.setActionCommand("delchapter");
        this.chapterdel.setPreferredSize(new Dimension(34, 22));
        this.chapterdel.setMaximumSize(new Dimension(34, 22));
        this.chapterfield = new JTextField("");
        this.chapterfield.setPreferredSize(new Dimension(34, 22));
        this.chapterfield.setMaximumSize(new Dimension(34, 22));
        this.chapterfield.setEditable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.chapteradd);
        jPanel.add(this.chapterdel);
        jPanel.add(this.chapterfield);
        this.chapter_combobox = new JComboBox();
        this.chapter_combobox.setMaximumRowCount(8);
        this.chapter_combobox.setPreferredSize(new Dimension(102, 22));
        this.chapter_combobox.setMaximumSize(new Dimension(102, 22));
        this.chapter_combobox.setActionCommand("chapterbox");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.chapter_combobox);
        this.chp = new JTextField(Resource.getString("CollectionPanel.NumberOfChapters"));
        this.chp.setToolTipText(Resource.getString("CollectionPanel.NumberOfChapters.Tip"));
        this.chp.setBackground(new Color(230, 230, 230));
        this.chp.setEditable(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 1));
        jPanel3.setPreferredSize(new Dimension(102, 22));
        jPanel3.setMaximumSize(new Dimension(102, 22));
        jPanel3.setMinimumSize(new Dimension(102, 22));
        jPanel3.add(this.chp);
        this.chapterdel.addActionListener(this.cutAction);
        this.chapteradd.addActionListener(this.cutAction);
        this.chapter_combobox.addActionListener(this.cutAction);
        this.chp.addActionListener(this.cutAction);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new ColumnLayout());
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        Color color = new Color(195, 205, 255);
        this.setComponentColor(this.chapteradd, color);
        this.setComponentColor(this.chapterdel, color);
        this.setComponentColor(jPanel4, color);
        return jPanel4;
    }

    private void getType() {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.collection != null ? this.collection.getCutpoints() : new Object[]{};
        if (objectArray.length > 0) {
            int n = this.getCutIndex(objectArray, String.valueOf(this.lastPosition));
            Common.getGuiInterface().showCutIcon((n & 1) == 0, objectArray, this.previewList);
        } else {
            Common.getGuiInterface().showCutIcon(true, null, this.previewList);
        }
        Object[] objectArray3 = objectArray = this.collection != null ? this.collection.getChapterpoints() : new Object[]{};
        if (objectArray.length > 0) {
            Common.getGuiInterface().showChapterIcon(objectArray, this.previewList);
        } else {
            Common.getGuiInterface().showChapterIcon(null, this.previewList);
        }
    }

    private int getLoadSize() {
        try {
            int n = Common.getPreviewBufferValue();
            return n;
        }
        catch (Exception exception) {
            Common.setMessage("!> wrong preview_buffer field entry", true);
            return this.loadSizeForward;
        }
    }

    private long preview(long l) {
        boolean bl = false;
        try {
            if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 0 || this.previewList.isEmpty()) {
                this.scannedPID.setText(Resource.getString("CollectionPanel.Preview.offline"));
                return this.lastPosition;
            }
            this.action = false;
            int n = this.getLoadSize();
            if (l >>> 4 >= (long)this.slider.getMaximum()) {
                l = l > (long)n ? l - (long)n : 0L;
                bl = true;
            } else if (l > 0L && l < this.lastPosition && (this.lastPosition >>> 4) - (l >>> 4) < 3L) {
                l = l > (long)n ? l - (long)n : 0L;
                bl = true;
            }
            l = this.Preview.load(l, bl && l == 0L ? (int)this.lastPosition : n, this.previewList, bl, Common.getSettings().getBooleanProperty(Keys.KEY_Preview_AllGops), Common.getSettings().getBooleanProperty(Keys.KEY_Preview_fastDecode), this.collection.getPIDs(), this.active_collection);
            String string = this.Preview.getProcessedFile();
            if (string.length() > 32) {
                int n2 = string.indexOf(45);
                String string2 = string.substring(0, n2 + 2);
                string = string2 + "..." + string.substring(n2 + 2 + (string.length() - 34 - n2), string.length());
            }
            this.firstfile.setText(string);
            this.scannedPID.setText(Resource.getString("CollectionPanel.Preview.processedPid") + this.Preview.getProcessedPID());
            this.lastPosition = l;
            this.slider.setValue((int)(this.lastPosition / 16L));
            this.cutfield.setText(String.valueOf(this.lastPosition));
            this.slider.requestFocus();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        this.setTitle(this.title);
        this.getExpectedSize();
        this.updateCutView(String.valueOf(this.lastPosition));
        this.action = true;
        return this.lastPosition;
    }

    private boolean addChapterpoint(String string) {
        int n = 0;
        n = this.getCutIndex(this.collection.getChapterpoints(), string);
        if (n >= 0) {
            return false;
        }
        this.collection.addChapterpoint(-n - 1, string);
        this.reloadChapterpoints();
        this.chapter_combobox.setSelectedItem(string);
        return true;
    }

    private Object removeChapterpoint(int n) {
        Object object = this.collection.removeChapterpoint(n);
        this.reloadChapterpoints();
        Object[] objectArray = this.collection.getChapterpoints();
        if (objectArray.length > 0) {
            int n2 = -this.getCutIndex(this.collection.getChapterpoints(), object.toString()) - 1;
            if (n2 >= objectArray.length) {
                n2 = objectArray.length - 1;
            }
            this.chapter_combobox.setSelectedIndex(n2);
        }
        return object;
    }

    private void reloadChapterpoints() {
        this.chapter_combobox.removeAllItems();
        Object[] objectArray = this.collection != null ? this.collection.getChapterpoints() : new Object[]{};
        for (int i = 0; i < objectArray.length; ++i) {
            this.chapter_combobox.addItem(objectArray[i]);
        }
    }

    private boolean addCutpoint(String string) {
        int n = 0;
        n = this.getCutIndex(this.collection.getCutpoints(), string);
        if (n >= 0) {
            return false;
        }
        this.collection.addCutpoint(-n - 1, string);
        this.reloadCutpoints();
        this.cut_combobox.setSelectedItem(string);
        return true;
    }

    private Object removeCutpoint(int n) {
        Object object = this.collection.removeCutpoint(n);
        this.reloadCutpoints();
        Object[] objectArray = this.collection.getCutpoints();
        if (objectArray.length > 0) {
            int n2 = -this.getCutIndex(this.collection.getCutpoints(), object.toString()) - 1;
            if (n2 >= objectArray.length) {
                n2 = objectArray.length - 1;
            }
            this.cut_combobox.setSelectedIndex(n2);
        }
        return object;
    }

    private void reloadCutpoints() {
        this.cut_combobox.removeAllItems();
        Object[] objectArray = this.collection != null ? this.collection.getCutpoints() : new Object[]{};
        for (int i = 0; i < objectArray.length; ++i) {
            this.cut_combobox.addItem(objectArray[i]);
        }
    }

    private int getCutIndex(Object[] objectArray, String string) {
        if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0 && CommonParsing.parseCutValue(string, false) < 0L) {
            return 0;
        }
        class MyComparator
        implements Comparator {
            MyComparator() {
            }

            public int compare(Object object, Object object2) {
                if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 4) {
                    return Long.toString(CommonParsing.parseCutValue(object.toString(), false)).compareTo(Long.toString(CommonParsing.parseCutValue(object2.toString(), false)));
                }
                return Long.valueOf(object.toString()).compareTo(Long.valueOf(object2.toString()));
            }
        }
        return Arrays.binarySearch(objectArray, string, new MyComparator());
    }

    private void updateCutView(String string) {
        Object[] objectArray;
        if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 0) {
            this.cutview.clearViews();
            return;
        }
        Object[] objectArray2 = objectArray = this.collection == null ? null : this.collection.getCutpoints();
        if (objectArray == null || objectArray.length == 0) {
            this.cutview.clearViews();
            return;
        }
        int n = this.getCutIndex(objectArray, string);
        if (n < 0) {
            int n2 = -n - 1;
            this.cutview.setMatchingPoint(false, objectArray, n);
            this.cutview.setImage(n2 < objectArray.length ? this.collection.getCutImage(objectArray[n2]) : null, objectArray, n2, this.cutview.getBottom());
            this.cutview.setImage(n2 - 1 >= 0 && n2 - 1 < objectArray.length ? this.collection.getCutImage(objectArray[n2 - 1]) : null, objectArray, n2 - 1, this.cutview.getTop());
        } else {
            if (this.collection.getCutImage(objectArray[n]) == null) {
                this.collection.setCutImage(string, Common.getMpvDecoderClass().getCutImage());
            }
            this.cutview.setMatchingPoint(true, objectArray, n);
            this.cutview.setImage(n + 1 < objectArray.length ? this.collection.getCutImage(objectArray[n + 1]) : null, objectArray, n + 1, this.cutview.getBottom());
            this.cutview.setImage(n - 1 >= 0 ? this.collection.getCutImage(objectArray[n - 1]) : null, objectArray, n - 1, this.cutview.getTop());
        }
    }

    private boolean checkActiveCollection() {
        if (this.active_collection >= 0) {
            return true;
        }
        this.collection = null;
        this.action = false;
        this.includeList.setListData(new Object[0]);
        this.previewList.clear();
        this.reloadCutpoints();
        this.reloadChapterpoints();
        Common.getGuiInterface().showCutIcon(true, null, this.previewList);
        Common.getGuiInterface().showChapterIcon(null, this.previewList);
        this.scannedPID.setText(Resource.getString("CollectionPanel.Preview.offline"));
        this.firstfile.setText("");
        this.slider.setMaximum(1);
        this.setTitle(Resource.getString("CollectionPanel.Title2"));
        Common.setOSDMessage(Resource.getString("CollectionPanel.Preview.offline"));
        this.action = true;
        return false;
    }

    public void entry(int n) {
        if (this.active_collection != n) {
            this.cutview.clearViews();
        }
        this.active_collection = n;
        Common.getMpvDecoderClass().clearPreviewPixel();
        if (!this.checkActiveCollection()) {
            return;
        }
        CommonGui.getPicturePanel().showCollectionNumber(this.active_collection);
        this.cutmode_combobox.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_CutMode));
        this.collection = Common.getCollection(this.active_collection);
        this.includeList.setListData(this.collection.getPIDs());
        List list = this.collection.getInputFilesAsList();
        this.previewList.clear();
        this.file = !list.isEmpty() ? list.get(0).toString() : "";
        long l = 0L;
        long l2 = 0L;
        int n2 = list.size();
        int n3 = 1;
        if (Common.getSettings().getBooleanProperty(Keys.KEY_Preview_disable)) {
            n2 = 0;
        }
        int n4 = -1;
        int n5 = -1;
        block3: for (int i = 0; i < n2; ++i) {
            XInputFile xInputFile = ((XInputFile)list.get(i)).getNewInstance();
            if (xInputFile == null) continue;
            if (xInputFile.getStreamInfo() == null) {
                Common.getScanClass().getStreamInfo(xInputFile);
            }
            n5 = xInputFile.getStreamInfo().getStreamType();
            if (n4 != -1 && n4 != n5) {
                n3 = i;
                break;
            }
            switch (n5) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    n4 = n5;
                    l = l2;
                    this.previewList.add(new PreviewObject(l, l2 += xInputFile.length(), n5, xInputFile));
                    continue block3;
                }
            }
        }
        this.action = false;
        this.slider.setMaximum(l2 > 16L ? (int)(l2 / 16L) : 1);
        this.action = true;
        if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0 && !this.previewList.isEmpty()) {
            this.preview(0L);
        } else {
            this.scannedPID.setText(Resource.getString("CollectionPanel.Preview.offline"));
            this.firstfile.setText("");
            Common.getMpvDecoderClass().clearPreviewPixel();
            Common.setOSDMessage(Resource.getString("CollectionPanel.Preview.offline"));
        }
        this.title = Resource.getString("CollectionPanel.Title2") + " " + this.active_collection;
        this.setTitle(this.title);
        this.action = false;
        this.reloadCutpoints();
        this.reloadChapterpoints();
        this.cut_combobox.setSelectedIndex(this.cut_combobox.getItemCount() - 1);
        this.getExpectedSize();
        this.getType();
        this.action = true;
    }

    private void saveList() {
        Object object;
        Object[] objectArray = this.collection.getCutpoints();
        if (objectArray.length == 0) {
            return;
        }
        String string = this.file + "[" + this.active_collection + "].Xcl";
        this.chooser.setSelectedFile(new File(string));
        this.chooser.rescanCurrentDirectory();
        int n = this.chooser.showSaveDialog(this);
        if (n == 0) {
            object = this.chooser.getSelectedFile();
            if (object != null && !((File)object).isDirectory()) {
                string = ((File)object).getAbsolutePath();
            }
        } else {
            return;
        }
        try {
            object = new BufferedWriter(new FileWriter(string));
            ((Writer)object).write(Keys.KEY_CutMode[0] + "=" + Common.getSettings().getProperty(Keys.KEY_CutMode));
            ((BufferedWriter)object).newLine();
            for (int i = 0; i < objectArray.length; ++i) {
                ((Writer)object).write(objectArray[i].toString());
                ((BufferedWriter)object).newLine();
            }
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            Common.setMessage(Resource.getString("CollectionPanel.FileAccessError") + " " + this.file);
        }
    }

    private void loadList() {
        this.loadList("");
    }

    private void loadList(String string) {
        Object[] objectArray;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        if (!new File(string).exists()) {
            this.chooser.rescanCurrentDirectory();
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                object = this.chooser.getSelectedFile();
                if (object != null && !((File)object).isDirectory()) {
                    string = ((File)object).getAbsolutePath();
                }
            } else {
                return;
            }
        }
        try {
            objectArray = new BufferedReader(new FileReader(string));
            while ((string2 = objectArray.readLine()) != null) {
                if (string2.trim().equals("")) continue;
                if (string2.startsWith(Keys.KEY_CutMode[0])) {
                    this.cutmode_combobox.setSelectedIndex(Integer.parseInt(string2.substring(string2.indexOf("=") + 1).trim()));
                    continue;
                }
                if (string2.startsWith("(")) continue;
                arrayList.add(string2);
            }
            objectArray.close();
        }
        catch (IOException iOException) {
            Common.setMessage(Resource.getString("CollectionPanel.loadCutpointList.Error") + " " + this.file);
        }
        objectArray = arrayList.toArray();
        if (objectArray.length > 0) {
            int n;
            object = new long[objectArray.length];
            for (n = 0; n < ((Object)object).length; ++n) {
                object[n] = CommonParsing.parseCutValue(objectArray[n].toString(), false);
            }
            Arrays.sort((long[])object);
            for (n = 0; n < ((Object)object).length; ++n) {
                this.collection.addCutpoint(CommonParsing.parseCutValue((long)object[n]));
            }
            this.action = false;
            this.reloadCutpoints();
            this.cut_combobox.setSelectedIndex(this.cut_combobox.getItemCount() - 1);
        }
        this.getExpectedSize();
        this.getType();
        this.action = true;
    }

    private void getExpectedSize() {
        if (this.previewList.isEmpty()) {
            this.pointslength.setText(Resource.getString("CollectionPanel.NumberOfPoints") + " " + this.cut_combobox.getItemCount());
            return;
        }
        Object[] objectArray = this.collection.getCutpoints();
        long[] lArray = new long[objectArray.length];
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0) {
            int n;
            for (n = 0; n < lArray.length; ++n) {
                lArray[n] = Long.parseLong(objectArray[n].toString());
            }
            l3 = lArray.length == 0 || (lArray.length & 1) == 1 ? ((PreviewObject)this.previewList.get(this.previewList.size() - 1)).getEnd() : lArray[lArray.length - 1];
            for (n = 0; n < lArray.length; n += 2) {
                l2 += lArray[n] - l;
                l = n + 1 < lArray.length ? lArray[n + 1] : l;
            }
        }
        String string = Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0 ? Resource.getString("CollectionPanel.expectedSize") + (l3 - l2) / 0x100000L + "MB" : "";
        this.pointslength.setText(string);
        this.chp.setText(Resource.getString("CollectionPanel.NumberOfChapters") + " " + this.chapter_combobox.getItemCount());
    }

    private void setTitle(String string) {
        this.titleLabel.setText(string);
    }

    class CutListener
    implements ActionListener {
        CutListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object;
            if (CollectionPanel.this.collection == null) {
                return;
            }
            if (!CollectionPanel.this.action) {
                return;
            }
            CollectionPanel.this.action = false;
            String string = actionEvent.getActionCommand();
            if (string.equals("delpoint")) {
                if (CollectionPanel.this.cut_combobox.getItemCount() > 0) {
                    CollectionPanel.this.removeCutpoint(CollectionPanel.this.cut_combobox.getSelectedIndex());
                }
            } else if (string.equals("cutnumber") || string.equals("addpoint")) {
                object = CollectionPanel.this.cutfield.getText();
                if (!((String)object).equals("") && CollectionPanel.this.addCutpoint((String)object) && Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0) {
                    CollectionPanel.this.collection.setCutImage((String)object, Common.getMpvDecoderClass().getCutImage());
                }
                CollectionPanel.this.cutfield.setText("");
            } else if (string.equals("delchapter")) {
                if (CollectionPanel.this.chapter_combobox.getItemCount() > 0) {
                    CollectionPanel.this.removeChapterpoint(CollectionPanel.this.chapter_combobox.getSelectedIndex());
                }
            } else if (string.equals("addchapter")) {
                object = CollectionPanel.this.cutfield.getText();
                if (!((String)object).equals("") && !CollectionPanel.this.addChapterpoint((String)object)) {
                    // empty if block
                }
            } else {
                if (string.equals("ID")) {
                    try {
                        String string2 = CollectionPanel.this.includeField.getText();
                        if (!string2.equals("")) {
                            if (!string2.startsWith("0x")) {
                                string2 = "0x" + Integer.toHexString(0x1FFF & Integer.parseInt(string2));
                            }
                            string2 = string2.toUpperCase().replace('X', 'x');
                            CollectionPanel.this.collection.addPID(string2);
                            CollectionPanel.this.includeList.setListData(CollectionPanel.this.collection.getPIDs());
                            CollectionPanel.this.includeList.ensureIndexIsVisible(CollectionPanel.this.collection.getPIDs().length - 1);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        Common.setOSDErrorMessage(Resource.getString("cutlistener.wrongnumber"));
                    }
                    CollectionPanel.this.includeField.setText("");
                    CollectionPanel.this.action = true;
                    return;
                }
                if (string.equals("transferPIDs")) {
                    try {
                        Object[] objectArray = CollectionPanel.this.includeList.getSelectedValues();
                        if (objectArray.length > 0) {
                            JobCollection jobCollection = Common.addCollection(CollectionPanel.this.collection.getNewInstance());
                            CollectionPanel.this.collection.removePID(objectArray);
                            jobCollection.clearPIDs();
                            jobCollection.addPID(objectArray);
                            jobCollection.determinePrimaryFileSegments();
                            CollectionPanel.this.entry(Common.getActiveCollection());
                        }
                    }
                    catch (Exception exception) {
                        Common.setExceptionMessage(exception);
                    }
                    CollectionPanel.this.action = true;
                    return;
                }
                if (string.equals("transferCuts")) {
                    try {
                        int n2 = 0;
                        n2 = CollectionPanel.this.cut_combobox.getItemCount();
                        if (n2 > 2) {
                            for (int i = 2; i < n2; i += 2) {
                                JobCollection jobCollection = Common.addCollection(CollectionPanel.this.collection.getNewInstance());
                                jobCollection.clearCutpoints();
                                for (int j = 0; j < 2 && i + j < n2; ++j) {
                                    jobCollection.addCutpoint(CollectionPanel.this.collection.removeCutpoint(2));
                                }
                                jobCollection.determinePrimaryFileSegments();
                            }
                            CollectionPanel.this.entry(Common.getActiveCollection());
                            CollectionPanel.this.action = true;
                        }
                    }
                    catch (Exception exception) {
                        Common.setExceptionMessage(exception);
                    }
                    CollectionPanel.this.action = true;
                    return;
                }
            }
            if (CollectionPanel.this.cut_combobox.getItemCount() > 0) {
                object = CollectionPanel.this.collection.getCutpoints();
                n = CollectionPanel.this.cut_combobox.getSelectedIndex();
                Common.getGuiInterface().showCutIcon((n & 1) == 0, (Object[])object, CollectionPanel.this.previewList);
                if ((string.equals("cutbox") || string.equals("delpoint")) && Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0) {
                    CollectionPanel.this.preview(Long.parseLong(object[n].toString()));
                }
                if (string.equals("addpoint")) {
                    CollectionPanel.this.updateCutView(String.valueOf(CollectionPanel.this.lastPosition));
                }
            } else {
                Common.getGuiInterface().showCutIcon(true, null, CollectionPanel.this.previewList);
                CollectionPanel.this.updateCutView(String.valueOf(CollectionPanel.this.lastPosition));
            }
            if (CollectionPanel.this.chapter_combobox.getItemCount() > 0) {
                object = CollectionPanel.this.collection.getChapterpoints();
                n = CollectionPanel.this.chapter_combobox.getSelectedIndex();
                CollectionPanel.this.chapterfield.setText(String.valueOf(n + 1));
                Common.getGuiInterface().showChapterIcon((Object[])object, CollectionPanel.this.previewList);
                if (string.equals("chapterbox") && Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0) {
                    CollectionPanel.this.preview(Long.parseLong(object[n].toString()));
                }
            } else {
                Common.getGuiInterface().showChapterIcon(null, CollectionPanel.this.previewList);
                CollectionPanel.this.chapterfield.setText("");
            }
            if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0) {
                CollectionPanel.this.slider.requestFocus();
            }
            CollectionPanel.this.getExpectedSize();
            CollectionPanel.this.action = true;
        }
    }

    class JumpListener
    implements ActionListener {
        JumpListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CollectionPanel.this.collection == null) {
                return;
            }
            if (!CollectionPanel.this.action) {
                return;
            }
            String string = actionEvent.getActionCommand();
            int n = CollectionPanel.this.slider.getValue();
            if (string.equals(CollectionPanel.this.navigation[0])) {
                int n2 = 0;
                int n3 = CollectionPanel.this.cut_combobox.getItemCount();
                if (n3 > 0) {
                    n2 = n3 - 1;
                    if (CollectionPanel.this.lastPosition > Long.parseLong(CollectionPanel.this.cut_combobox.getItemAt(0).toString())) {
                        while (CollectionPanel.this.lastPosition <= Long.parseLong(CollectionPanel.this.cut_combobox.getItemAt(n2).toString())) {
                            --n2;
                        }
                    }
                    CollectionPanel.this.cut_combobox.setSelectedIndex(n2);
                }
            } else if (string.equals(CollectionPanel.this.navigation[1])) {
                CollectionPanel.this.slider.setValue(n - 3125000);
            } else if (string.equals(CollectionPanel.this.navigation[2])) {
                CollectionPanel.this.slider.setValue(n - 312500);
            } else if (string.equals(CollectionPanel.this.navigation[3])) {
                CollectionPanel.this.slider.setValue(n - 2);
            } else if (string.equals(CollectionPanel.this.navigation[4])) {
                CollectionPanel.this.slider.setValue(n + 2);
            } else if (string.equals(CollectionPanel.this.navigation[5])) {
                CollectionPanel.this.slider.setValue(n + 312500);
            } else if (string.equals(CollectionPanel.this.navigation[6])) {
                CollectionPanel.this.slider.setValue(n + 3125000);
            } else if (string.equals(CollectionPanel.this.navigation[7])) {
                int n4 = 0;
                int n5 = CollectionPanel.this.cut_combobox.getItemCount();
                if (n5 > 0) {
                    if (CollectionPanel.this.lastPosition < Long.parseLong(CollectionPanel.this.cut_combobox.getItemAt(n5 - 1).toString())) {
                        while (CollectionPanel.this.lastPosition >= Long.parseLong(CollectionPanel.this.cut_combobox.getItemAt(n4).toString())) {
                            ++n4;
                        }
                    }
                    CollectionPanel.this.cut_combobox.setSelectedIndex(n4);
                }
            } else if (string.equals("loadlist")) {
                CollectionPanel.this.loadList();
            } else if (string.equals("savelist")) {
                CollectionPanel.this.saveList();
            }
        }
    }

    class DNDListener2
    implements DropTargetListener {
        DNDListener2() {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                int n = dropTargetDropEvent.getDropAction();
                if (n == 0 || n > 2) {
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
                dropTargetDropEvent.acceptDrop(n);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                List list = (List)transferable.getTransferData(dataFlavorArray[0]);
                Object[] objectArray = list.toArray();
                if (objectArray.length > 0) {
                    CollectionPanel.this.loadList(objectArray[0].toString());
                }
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Exception exception) {
                dropTargetDropEvent.dropComplete(false);
                Common.setExceptionMessage(exception);
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    private class SlideShow
    implements Runnable {
        private Thread clockThread = null;
        private long value = 0L;
        private long skip = 50000L;
        private Object[] cutpoints = null;

        private SlideShow() {
        }

        public void start(long l) {
            if (this.clockThread == null) {
                this.clockThread = new Thread((Runnable)this, "SlideShow");
                this.clockThread.setPriority(1);
                this.value = l;
                this.skip = CollectionPanel.this.getLoadSize() / 8;
                this.getCutPoints();
                this.clockThread.start();
            }
        }

        private void getCutPoints() {
            this.cutpoints = CollectionPanel.this.collection == null ? null : CollectionPanel.this.collection.getCutpoints();
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.clockThread == thread) {
                try {
                    long l;
                    do {
                        l = this.update(this.value);
                        Thread.sleep(5L);
                        if (!CollectionPanel.this.slideshow || l < this.value) break;
                        this.value = this.skipArea(l);
                    } while (this.value >= l);
                    this.stop();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private long update(long l) {
            return CollectionPanel.this.preview(l);
        }

        private long skipArea(long l) {
            if (this.cutpoints == null || this.cutpoints.length == 0) {
                return l + this.skip;
            }
            int n = CollectionPanel.this.getCutIndex(this.cutpoints, String.valueOf(l));
            if (n < 0) {
                if ((n & 1) == 0) {
                    return l + this.skip;
                }
                if (-n > this.cutpoints.length) {
                    return l - this.skip;
                }
                return Long.parseLong(this.cutpoints[n + 1].toString());
            }
            if ((n & 1) == 0) {
                return l + this.skip;
            }
            if (n + 1 >= this.cutpoints.length) {
                return l - this.skip;
            }
            return Long.parseLong(this.cutpoints[n + 1].toString());
        }

        public void stop() {
            this.clockThread = null;
        }
    }
}

