/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.CommonGui;

public class AboutBox
extends JDialog {
    private static final Color BACKGROUND_COLOR = new Color(224, 224, 224);

    public AboutBox(Frame frame) {
        super(frame, true);
        this.setTitle(Resource.getString("about.title"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setBackground(BACKGROUND_COLOR);
        JLabel jLabel = new JLabel(CommonGui.loadIcon("px.gif"));
        jLabel.setOpaque(true);
        jLabel.setBackground(BACKGROUND_COLOR);
        jPanel.add(new JLabel(Resource.getString("about.credits.label")));
        String string = "\n" + Resource.getString("credits") + "\n";
        JTextArea jTextArea = new JTextArea(string, 5, 10);
        jTextArea.setEnabled(false);
        jTextArea.setDisabledTextColor(Color.black);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBackground(Color.white);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jPanel.add(jScrollPane);
        final CreditsScroller creditsScroller = new CreditsScroller(jScrollPane);
        creditsScroller.start();
        jPanel.add(new JLabel(" "));
        String[] stringArray = Resource.getStringByLines("terms");
        for (int i = 0; i < stringArray.length; ++i) {
            jPanel.add(new JLabel(stringArray[i]));
        }
        JButton jButton = new JButton(Resource.getString("about.ok"));
        jButton.setBackground(BACKGROUND_COLOR);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                creditsScroller.stopIt();
                AboutBox.this.dispose();
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(BACKGROUND_COLOR);
        jPanel2.setOpaque(true);
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)jButton, "South");
        this.getContentPane().add(jPanel2);
        this.pack();
        this.setLocation(200, 200);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                creditsScroller.stopIt();
                AboutBox.this.dispose();
            }
        });
        this.setVisible(true);
    }

    private class CreditsScroller
    extends Thread {
        private boolean up = true;
        private boolean stopIt = false;
        private JScrollPane scroll;

        public CreditsScroller(JScrollPane jScrollPane) {
            this.scroll = jScrollPane;
        }

        public void run() {
            while (!this.stopIt) {
                try {
                    CreditsScroller.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                JViewport jViewport = this.scroll.getViewport();
                int n = jViewport.getViewSize().height - jViewport.getViewRect().height;
                int n2 = (int)jViewport.getViewPosition().getY();
                if (this.up) {
                    if (n2 < n) {
                        ++n2;
                    } else {
                        --n2;
                        this.up = false;
                    }
                } else if (n2 > 0) {
                    --n2;
                } else {
                    ++n2;
                    this.up = true;
                }
                jViewport.setViewPosition(new Point(0, n2));
            }
        }

        public void stopIt() {
            this.stopIt = true;
        }
    }
}

