/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.xinput.XInputDirectory;

public class Settings {
    private static final String DEFAULT_INI = "X.ini";
    private String inifile = "";
    private Properties props = new Properties();
    private ArrayList input_directories = new ArrayList();
    private ArrayList output_directories = new ArrayList();

    public Settings() {
        this(Resource.workdir + Resource.filesep + DEFAULT_INI);
    }

    public Settings(String string) {
        this.inifile = string;
        this.load();
        this.buildInputDirectories();
        this.buildOutputDirectories();
    }

    public void loadProperties(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.props.load(byteArrayInputStream);
    }

    public byte[] storeProperties() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.props.store(byteArrayOutputStream, null);
        return byteArrayOutputStream.toByteArray();
    }

    public void load() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.inifile));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.startsWith("#") || (n = string.indexOf(61)) == -1) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                this.props.put(string2, string3);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println(Resource.getString("msg.loadini.error") + " " + iOException);
        }
    }

    public void save() {
        this.save(this.inifile);
    }

    public void save(String string) {
        if (string == null) {
            string = this.inifile;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            String string2 = "# Project-X INI";
            printWriter.println(string2);
            printWriter.println("# " + Common.getVersionName() + " / " + Common.getVersionDate());
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(this.props);
            Set<Object> set = treeMap.keySet();
            for (String string3 : set) {
                String string4 = string3.substring(0, string3.indexOf("."));
                if (!string2.equals(string4)) {
                    printWriter.println();
                    printWriter.println("# " + string4);
                    string2 = string4;
                }
                printWriter.println(string3 + "=" + treeMap.get(string3));
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public void buildInputDirectories() {
        int n;
        String string = "Application.InputDirectories.";
        ArrayList arrayList = (ArrayList)this.getListProperty(string);
        for (n = 0; n < arrayList.size(); ++n) {
            if (this.addInputDirectory(arrayList.get(n)) != null) continue;
            arrayList.remove(n);
            --n;
        }
        if (n != arrayList.size()) {
            this.setListProperty(string, arrayList);
        }
    }

    public void updateInputDirectories() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.input_directories.size(); ++i) {
            arrayList.add(this.input_directories.get(i).toString());
        }
        this.setListProperty("Application.InputDirectories.", arrayList);
    }

    public String addInputDirectory(Object object) {
        if (object == null) {
            return null;
        }
        try {
            XInputDirectory xInputDirectory = (XInputDirectory)object;
            this.input_directories.add(xInputDirectory);
            return xInputDirectory.toString();
        }
        catch (Exception exception) {
            try {
                XInputDirectory xInputDirectory = new XInputDirectory(object);
                if (xInputDirectory.test()) {
                    this.input_directories.add(xInputDirectory);
                    return xInputDirectory.toString();
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }
    }

    public void removeInputDirectory(int n) {
        if (n < 0 || this.input_directories.isEmpty() || this.input_directories.size() <= n) {
            return;
        }
        this.input_directories.remove(n);
    }

    public ArrayList getInputDirectories() {
        return this.input_directories;
    }

    public void buildOutputDirectories() {
        int n;
        String string = "Application.OutputDirectories.";
        ArrayList arrayList = (ArrayList)this.getListProperty(string);
        for (n = 0; n < arrayList.size(); ++n) {
            this.addOutputDirectory(arrayList.get(n));
        }
        if (n != arrayList.size()) {
            this.setListProperty(string, arrayList);
        }
    }

    public void updateOutputDirectories() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.output_directories.size(); ++i) {
            arrayList.add(this.output_directories.get(i).toString());
        }
        this.setListProperty("Application.OutputDirectories.", arrayList);
    }

    public void addOutputDirectory(Object object) {
        this.addOutputDirectory(object, -1);
    }

    public void addOutputDirectory(Object object, int n) {
        if (object == null) {
            return;
        }
        if (n < 0 || n > this.output_directories.size()) {
            this.output_directories.add(object);
        } else {
            this.output_directories.add(n, object);
        }
        this.updateOutputDirectories();
    }

    public void removeOutputDirectory(int n) {
        if (n < 0 || this.output_directories.size() < n - 1) {
            return;
        }
        this.output_directories.remove(n);
        this.updateOutputDirectories();
    }

    public ArrayList getOutputDirectories() {
        return this.output_directories;
    }

    public void setProperty(String string, String string2) {
        if (string2 != null) {
            this.props.setProperty(string, string2);
        } else {
            this.props.remove(string);
        }
    }

    public void setProperty(String string, Object object) {
        String string2 = object == null ? null : String.valueOf(object);
        this.setProperty(string, string2);
    }

    public void setProperty(Object[] objectArray, Object object) {
        this.setProperty(objectArray[0].toString(), String.valueOf(object));
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.props.getProperty(string, string2);
    }

    public String getProperty(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        return this.props.getProperty(string, string2);
    }

    public void setIntProperty(String string, int n) {
        this.props.setProperty(string, String.valueOf(n));
    }

    public int getIntProperty(String string) {
        return Integer.parseInt(this.props.getProperty(string));
    }

    public int getIntProperty(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(this.getProperty(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public int getIntProperty(String[] stringArray) {
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        try {
            n = Integer.parseInt(this.getProperty(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public void setBooleanProperty(String string, boolean bl) {
        this.props.setProperty(string, bl ? "1" : "0");
    }

    public Boolean getBooleanProperty(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        if (string2.equals("1") || string2.equals("true") || string2.equals("yes") || string2.equals("on")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        Boolean bl2 = this.getBooleanProperty(string);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public boolean getBooleanProperty(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        Boolean bl = this.getBooleanProperty(string);
        if (bl != null) {
            return bl;
        }
        return string2.equals("1") || string2.equals("true") || string2.equals("yes") || string2.equals("on");
    }

    public void setListProperty(String string, List list) {
        this.removeListProperty(string);
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            this.setProperty(string + i, e);
        }
    }

    public List getListProperty(String string) {
        Set<Object> set = this.props.keySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : set) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(this.props.getProperty(string2));
        }
        return arrayList;
    }

    public void removeListProperty(String string) {
        Set<Object> set = this.props.keySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : set) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.remove(arrayList.get(i).toString());
        }
    }

    public void setHashMapProperty(String string, Map map) {
        Set set = map.keySet();
        for (String string2 : set) {
            this.setProperty(string + string2, map.get(string2));
        }
    }

    public Map getHashMapProperty(String string) {
        Set<Object> set = this.props.keySet();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : set) {
            if (!string2.startsWith(string)) continue;
            hashMap.put(string2.substring(string.length()), this.props.getProperty(string2));
        }
        return hashMap;
    }

    public void remove(String string) {
        this.props.remove(string);
    }

    public String getInifile() {
        return this.inifile;
    }
}

