/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.common;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.dvb.projectx.common.Keys;

public class Resource {
    private static final String PJX_RESOURCE_PREFIX = "pjxresources";
    public static final String workdir = System.getProperty("user.dir");
    public static final String filesep = System.getProperty("file.separator");
    private static Locale locale = null;
    private static ResourceBundle defaultResource = null;
    private static ResourceBundle resource = null;

    private static ResourceBundle loadResourceBundle(Locale locale) throws MissingResourceException {
        Serializable serializable;
        PropertyResourceBundle propertyResourceBundle = null;
        String string = "pjxresources_" + locale.getLanguage() + ".properties";
        try {
            serializable = new File(workdir + filesep + string);
            if (((File)serializable).exists() && ((File)serializable).canRead()) {
                propertyResourceBundle = new PropertyResourceBundle(new FileInputStream((File)serializable));
                return propertyResourceBundle;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serializable = Resource.class.getClassLoader().getResource(string);
            propertyResourceBundle = new PropertyResourceBundle(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            throw new MissingResourceException("couldn't find " + string, Resource.class.getName(), string);
        }
        return propertyResourceBundle;
    }

    private Resource() {
    }

    public static void loadLang(String string) {
        locale = new Locale(string, "");
        try {
            resource = Resource.loadResourceBundle(locale);
        }
        catch (MissingResourceException missingResourceException) {
            resource = defaultResource;
        }
        new Keys();
    }

    public static String getChosenLanguage() {
        if (locale == null) {
            return null;
        }
        return locale.getLanguage();
    }

    public static void setChosenLanguage(String string) {
        locale = string == null ? null : new Locale(string, "", "");
    }

    public static String getString(String string) {
        String string2 = null;
        try {
            string2 = resource.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                string2 = defaultResource.getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                System.out.println("ResourceKey '" + string + "' not found in pjxresources");
            }
        }
        if (string2 == null) {
            string2 = "?" + string + "?";
        }
        return string2;
    }

    public static String[] getStringByLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(Resource.getString(string), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }

    public static String getString(String string, Object[] objectArray) {
        return MessageFormat.format(Resource.getString(string), objectArray);
    }

    public static String getString(String string, Object object) {
        return MessageFormat.format(Resource.getString(string), object);
    }

    public static String getString(String string, Object object, Object object2) {
        return MessageFormat.format(Resource.getString(string), object, object2);
    }

    public static String getString(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(Resource.getString(string), object, object2, object3);
    }

    public static String getString(String string, Object object, Object object2, Object object3, Object object4) {
        return MessageFormat.format(Resource.getString(string), object, object2, object3, object4);
    }

    public static String getString(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        return MessageFormat.format(Resource.getString(string), object, object2, object3, object4, object5);
    }

    public static Locale[] getAvailableLocales() {
        HashSet hashSet = new HashSet();
        String string = Locale.getDefault().getLanguage();
        try {
            Object object;
            URL uRL = ClassLoader.getSystemResource("pjxresources_en.properties");
            if (uRL != null) {
                object = null;
                object = uRL.openConnection();
                if (object != null && object instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)object;
                    Resource.addAvailableLocalesFromJar(hashSet, jarURLConnection);
                } else {
                    File file = new File(uRL.getFile());
                    File file2 = file.getParentFile();
                    Resource.addAvailableLocalesFromFileSystem(hashSet, file2);
                }
            } else {
                System.err.println("Couldn't find \"pjxresources\"*.properties");
            }
            object = new File(workdir);
            Resource.addAvailableLocalesFromFileSystem(hashSet, (File)object);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return hashSet.toArray(new Locale[0]);
    }

    private static void addAvailableLocalesFromFileSystem(Set set, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isFile() || !file2.getName().startsWith(PJX_RESOURCE_PREFIX)) continue;
                try {
                    String string = file2.getName();
                    int n = string.indexOf(95);
                    if (n != -1) {
                        string = string.substring(n + 1);
                    }
                    if ((n = string.indexOf(46)) != -1) {
                        string = string.substring(0, n);
                    }
                    Locale locale = new Locale(string, "");
                    set.add(locale);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        }
    }

    private static void addAvailableLocalesFromJar(Set set, JarURLConnection jarURLConnection) {
        JarFile jarFile = null;
        try {
            jarFile = jarURLConnection.getJarFile();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        if (jarFile != null) {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName();
                if (!string.startsWith(PJX_RESOURCE_PREFIX)) continue;
                String string2 = string.substring(0, string.length() - ".properties".length());
                int n = string2.indexOf(95);
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                if ((n = string2.indexOf(46)) != -1) {
                    string2 = string2.substring(0, n);
                }
                Locale locale = new Locale(string2, "");
                set.add(locale);
            }
        }
    }

    public static URL getResourceURL(String string) {
        try {
            String string2 = workdir + filesep + string;
            File file = new File(string2);
            if (file.exists() && file.canRead()) {
                return file.toURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string.replace('\\', '/');
        return Resource.class.getClassLoader().getResource(string);
    }

    public static URL getLocalizedResourceURL(String string, String string2) {
        Locale locale = null;
        locale = Resource.locale != null ? Resource.locale : Locale.getDefault();
        String string3 = string + filesep + locale.getLanguage() + filesep + string2;
        URL uRL = Resource.getResourceURL(string3);
        if (uRL != null) {
            return uRL;
        }
        return Resource.getResourceURL(string + filesep + string2);
    }

    public static Image loadImage(String string) {
        try {
            return Toolkit.getDefaultToolkit().createImage(Resource.getResourceURL(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        defaultResource = Resource.loadResourceBundle(Locale.ENGLISH);
        try {
            resource = Resource.loadResourceBundle(Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            resource = defaultResource;
        }
    }
}

