/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import net.sourceforge.dvb.projectx.audio.AudioFormat;

public class AudioFormatLPCM
extends AudioFormat {
    private int[] lpcm_frequency_index = new int[]{48000, 96000};
    private int[] lpcm_bps_index = new int[]{16, 20, 24, -1};

    public int parseHeader(byte[] byArray, int n) {
        INTEL = true;
        ID = 0xFF & byArray[n];
        Padding_bit = (0xFF & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2];
        Layer = 0xFF & byArray[n + 3];
        Protection_bit = 1;
        Private_bit = 0;
        Copyright = 0;
        Original = 0;
        Size_base = 0;
        Size = this.lpcm_bps_index[3 & byArray[n + 4] >>> 6];
        Sampling_frequency = this.lpcm_frequency_index[1 & byArray[n + 4] >>> 4];
        Channel = 1 + (7 & byArray[n + 4]);
        Emphasis = 0xFF & byArray[n + 5];
        Mode = Channel * Size / 8;
        Bitrate = Channel * Sampling_frequency * Size;
        if (Size < 1) {
            return -1;
        }
        Time_length = 90000.0 / (double)Sampling_frequency;
        return 0;
    }

    public int parseNextHeader(byte[] byArray, int n) {
        INTEL = true;
        this.nID = 0xFF & byArray[n];
        this.nPadding_bit = (0xFF & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2];
        this.nLayer = 0xFF & byArray[n + 3];
        this.nProtection_bit = 1;
        this.nPrivate_bit = 0;
        this.nCopyright = 0;
        this.nOriginal = 0;
        this.nSize_base = 0;
        this.nSize = this.lpcm_bps_index[3 & byArray[n + 4] >>> 6];
        this.nSampling_frequency = this.lpcm_frequency_index[1 & byArray[n + 4] >>> 4];
        this.nChannel = 1 + (7 & byArray[n + 4]);
        this.nEmphasis = 0xFF & byArray[n + 5];
        this.nMode = this.nChannel * this.nSize / 8;
        this.nBitrate = this.nChannel * this.nSampling_frequency * this.nSize;
        if (this.nSize < 1) {
            return -1;
        }
        this.nTime_length = 90000.0 / (double)this.nSampling_frequency;
        return 0;
    }

    public String displayHeader() {
        return "LPCM, DR-" + lEmphasis + ", " + lChannel + "-ch, " + lSampling_frequency + "Hz, " + lSize + "bit, " + (double)lBitrate / 1000.0 + "kbps";
    }

    public int compareHeader() {
        if (lChannel != Channel) {
            return 1;
        }
        if (lSampling_frequency != Sampling_frequency) {
            return 2;
        }
        if (lSize != Size) {
            return 3;
        }
        if (lEmphasis != Emphasis) {
            return 4;
        }
        return 0;
    }
}

