/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import net.sourceforge.dvb.projectx.audio.AudioFormat;

public class AudioFormatDTS
extends AudioFormat {
    private int[] dts_frequency_index = new int[]{0, 8000, 16000, 32000, 64000, 128000, 11025, 22050, 44100, 88200, 176400, 12000, 24000, 48000, 96000, 192000};
    private int[] dts_bitrate_index = new int[]{32000, 56000, 64000, 96000, 112000, 128000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000, 768000, 896000, 1024000, 1152000, 1280000, 1344000, 1408000, 1411200, 1472000, 0x177000, 1920000, 2048000, 0x2EE000, 3840000, 4096000, 0, 0};
    private String[] dts_acmod = new String[]{"1", "DM", "2/0", "2/0", "2/0", "3/0", "2.1/0", "3.1/0", "2/2", "3/2", "2/2/2", "2/2/2", "3/2/2", "3.1/2/2", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    private int[] dts_channels = new int[]{1, 2, 2, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public int parseHeader(byte[] byArray, int n) {
        if (byArray[n] != 127 || byArray[n + 1] != -2 || byArray[n + 2] != -128 || byArray[n + 3] != 1) {
            return -1;
        }
        ID = 0;
        Emphasis = 0;
        Protection_bit = 1;
        Sampling_frequency = this.dts_frequency_index[0xF & byArray[n + 8] >>> 2];
        if (Sampling_frequency < 1) {
            return -4;
        }
        Bitrate = this.dts_bitrate_index[(3 & byArray[n + 8]) << 3 | 7 & byArray[n + 9] >>> 5];
        if (Bitrate < 1) {
            return -3;
        }
        Layer = 0;
        Padding_bit = 0;
        Private_bit = 0;
        Mode = (0xF & byArray[n + 7]) << 2 | (0xC0 & byArray[n + 8]) >>> 6;
        Mode_extension = 0;
        Channel = this.dts_channels[Mode];
        Copyright = 0;
        Original = 0;
        Size = (1 & byArray[n + 4]) << 6 | (0xFC & byArray[n + 5]) >>> 2;
        Size = Size + 1 << 5;
        Time_length = 90000.0 * (double)Size / (double)Sampling_frequency;
        Size = (3 & byArray[n + 5]) << 12 | (0xFF & byArray[n + 6]) << 4 | (0xF0 & byArray[n + 7]) >>> 4;
        Size_base = ++Size;
        return 1;
    }

    public int parseNextHeader(byte[] byArray, int n) {
        if (byArray[n] != 127 || byArray[n + 1] != -2 || byArray[n + 2] != -128 || byArray[n + 3] != 1) {
            return -1;
        }
        this.nID = 0;
        this.nEmphasis = 0;
        this.nProtection_bit = 1;
        this.nSampling_frequency = this.dts_frequency_index[0xF & byArray[n + 8] >>> 2];
        if (this.nSampling_frequency < 1) {
            return -4;
        }
        this.nBitrate = this.dts_bitrate_index[(3 & byArray[n + 8]) << 3 | 7 & byArray[n + 9] >>> 5];
        if (this.nBitrate < 1) {
            return -3;
        }
        this.nLayer = 0;
        this.nPadding_bit = 0;
        this.nPrivate_bit = 0;
        this.nMode = (0xF & byArray[n + 7]) << 2 | (0xC0 & byArray[n + 8]) >>> 6;
        this.nMode_extension = 0;
        this.nChannel = this.dts_channels[this.nMode];
        this.nCopyright = 0;
        this.nOriginal = 0;
        this.nSize = (1 & byArray[n + 4]) << 6 | (0xFC & byArray[n + 5]) >>> 2;
        this.nSize = this.nSize + 1 << 5;
        this.nTime_length = 90000.0 * (double)this.nSize / (double)this.nSampling_frequency;
        this.nSize = (3 & byArray[n + 5]) << 12 | (0xFF & byArray[n + 6]) << 4 | (0xF0 & byArray[n + 7]) >>> 4;
        ++this.nSize;
        this.nSize_base = this.nSize;
        return 1;
    }

    public int compareHeader() {
        if (lLayer != Layer) {
            return 1;
        }
        if (lBitrate != Bitrate) {
            return 2;
        }
        if (lSampling_frequency != Sampling_frequency) {
            return 3;
        }
        if (lMode != Mode) {
            return 4;
        }
        if (lMode_extension != Mode_extension) {
            return 5;
        }
        if (lSize != Size) {
            return 6;
        }
        return 0;
    }

    public String displayHeader() {
        return "DTS, " + this.dts_acmod[lMode] + "(" + this.dts_channels[lMode] + "), " + lSampling_frequency + "Hz, " + (double)lBitrate / 1000.0 + "kbps, " + lSize + "BpF";
    }
}

